/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.projects;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jpt.utility.internal.CollectionTools;

public class TestPlatformProject {
    private final IProject project;
    public static final String CR = System.getProperty("line.separator");

    public TestPlatformProject() throws CoreException {
        this(false);
    }

    public TestPlatformProject(boolean autoBuild) throws CoreException {
        this("TestProject", autoBuild);
    }

    public TestPlatformProject(String projectName, boolean autoBuild) throws CoreException {
        this.setAutoBuild(autoBuild);
        this.project = this.createPlatformProject(projectName);
    }

    private void setAutoBuild(boolean autoBuild) throws CoreException {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setAutoBuilding(autoBuild);
        ResourcesPlugin.getWorkspace().setDescription(description);
    }

    private IProject createPlatformProject(String projectName) throws CoreException {
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        p.create(null);
        p.open(null);
        return p;
    }

    public IProject getProject() {
        return this.project;
    }

    public void addProjectNature(String natureID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        description.setNatureIds((String[])CollectionTools.add((Object[])description.getNatureIds(), (Object)natureID));
        this.project.setDescription(description, null);
    }

    public void removeProjectNature(String natureID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        description.setNatureIds((String[])CollectionTools.removeAllOccurrences((Object[])description.getNatureIds(), (Object)natureID));
        this.project.setDescription(description, null);
    }

    public IFolder createFolder(String folderName) throws CoreException {
        return this.createFolder((IContainer)this.project, (IPath)new Path(folderName));
    }

    public IFolder createFolder(IContainer container, String folderName) throws CoreException {
        return this.createFolder(container, (IPath)new Path(folderName));
    }

    public IFolder createFolder(IContainer container, IPath folderPath) throws CoreException {
        IFolder folder = container.getFolder(folderPath);
        if (!folder.exists()) {
            folder.create(false, true, null);
        }
        return folder;
    }

    public IFile createFile(String fileName, String content) throws CoreException {
        return this.createFile((IContainer)this.project, fileName, content);
    }

    public IFile createFile(IContainer container, String fileName, String content) throws CoreException {
        return this.createFile(container, (IPath)new Path(fileName), content);
    }

    public IFile createFile(IPath filePath, String content) throws CoreException {
        return this.createFile((IContainer)this.project, filePath, content);
    }

    public IFile createFile(IContainer container, IPath filePath, String content) throws CoreException {
        return this.createFile(container, filePath, new ByteArrayInputStream(content.getBytes()));
    }

    public IFile createFile(IContainer container, IPath filePath, InputStream content) throws CoreException {
        int len = filePath.segmentCount() - 1;
        int i = 0;
        while (i < len) {
            if (!(container = container.getFolder((IPath)new Path(filePath.segment(i)))).exists()) {
                ((IFolder)container).create(true, true, null);
            }
            ++i;
        }
        IFile file = container.getFile((IPath)new Path(filePath.lastSegment()));
        if (file.exists()) {
            file.delete(true, null);
        }
        file.create(content, true, null);
        return file;
    }

    public void open() throws CoreException {
        this.project.open(null);
        TestPlatformProject.waitForJobs();
    }

    public void close() throws CoreException {
        this.project.close(null);
        TestPlatformProject.waitForJobs();
    }

    public void dispose() throws CoreException {
        this.project.delete(true, true, null);
        int i = 1;
        while (this.project.exists()) {
            TestPlatformProject.waitForJobs();
            System.out.println("Project still exists: " + i);
            ++i;
        }
    }

    public static void waitForJobs() {
        while (Job.getJobManager().currentJob() != null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

