/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.internal.jsp.JSPDefaultSymbolFactory;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class TestJSPDefaultSymbolFactory
extends TestCase {
    private IFile _testJSP;
    private JSFFacetedTestEnvironment _jsfFactedTestEnvironment;
    private IStructuredModel _structuredModel;
    private IStructuredDocument _structuredDocument;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        WebProjectTestEnvironment projectTestEnvironment = new WebProjectTestEnvironment("TestJSPDefaultSymbolFactory" + this.getName());
        projectTestEnvironment.createProject(false);
        JDTTestEnvironment jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)projectTestEnvironment);
        TestFileResource input = new TestFileResource();
        input.load(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/bundle1.resources.data");
        jdtTestEnvironment.addResourceFile("src", (InputStream)new ByteArrayInputStream(input.toBytes()), "bundles", "bundle1.properties");
        IResource res = projectTestEnvironment.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/testdata1.jsp.data", "testdata1.jsp");
        this._testJSP = (IFile)res;
        this._jsfFactedTestEnvironment = new JSFFacetedTestEnvironment(projectTestEnvironment);
        this._jsfFactedTestEnvironment.initialize("1.1");
        this._structuredModel = StructuredModelManager.getModelManager().getModelForRead(this._testJSP);
        this._structuredDocument = this._structuredModel.getStructuredDocument();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this._structuredModel.releaseFromRead();
    }

    public void testSupports() {
        JSPDefaultSymbolFactory factory = new JSPDefaultSymbolFactory();
        TestJSPDefaultSymbolFactory.assertFalse((boolean)factory.supports((IAdaptable)this._testJSP));
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._structuredDocument, 0);
        TestJSPDefaultSymbolFactory.assertTrue((boolean)factory.supports((IAdaptable)context));
    }

    public void testCreate() {
        JSPDefaultSymbolFactory factory = new JSPDefaultSymbolFactory();
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._structuredDocument, 0);
        ISymbol var = factory.create("notAVariable", 1, (IAdaptable)context, new ArrayList());
        TestJSPDefaultSymbolFactory.assertNull((Object)var);
        var = factory.create("bundle", 1, (IAdaptable)IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._structuredDocument, 552), new ArrayList());
        TestJSPDefaultSymbolFactory.assertNotNull((Object)var);
        TestJSPDefaultSymbolFactory.assertTrue((boolean)(var instanceof IInstanceSymbol));
        TestJSPDefaultSymbolFactory.assertEquals((String)"bundle", (String)var.getName());
        var = factory.create("row", 1, (IAdaptable)IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._structuredDocument, 1361), new ArrayList());
        TestJSPDefaultSymbolFactory.assertNotNull((Object)var);
        TestJSPDefaultSymbolFactory.assertTrue((boolean)(var instanceof IInstanceSymbol));
        TestJSPDefaultSymbolFactory.assertEquals((String)"row", (String)var.getName());
    }
}

