/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.designtime.internal.symbols.ResourceBundleMapSourceFactory;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResourceBundleMapSource
extends TestCase {
    private static final String BUNDLE1_PATH = "bundles";
    private static final String BUNDLE1_NAME = "bundle1.properties";
    private IProject _project1;
    private IProject _project2;
    private IProject _project3;
    private IFile _bundle1;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        List<IResource> resources = this.initProject("BundleResourceTestProject1", "/testdata/bundle1.resources.data", BUNDLE1_PATH, BUNDLE1_NAME);
        this._bundle1 = (IFile)resources.get(0);
        this._project1 = (IProject)resources.get(1);
        resources = this.initProject("BundleResourceTestProject2", "/testdata/bundle2.resources.data", BUNDLE1_PATH, BUNDLE1_NAME);
        this._project2 = (IProject)resources.get(1);
        resources = this.initProject("BundleResourceTestProject3", "/testdata/bundle1.resources.data", BUNDLE1_PATH, BUNDLE1_NAME);
        this._project3 = (IProject)resources.get(1);
    }

    private List<IResource> initProject(String projectName, String dataFilePath, String bundlePath, String bundleName) throws Exception {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        ProjectTestEnvironment testEnv = new ProjectTestEnvironment(projectName);
        testEnv.createProject(false);
        JDTTestEnvironment jdtTestEnv = new JDTTestEnvironment(testEnv);
        TestFileResource input = new TestFileResource();
        input.load(DesignTimeTestsPlugin.getDefault().getBundle(), dataFilePath);
        resources.add((IResource)jdtTestEnv.addResourceFile("src", (InputStream)new ByteArrayInputStream(input.toBytes()), bundlePath, bundleName));
        IProject project = testEnv.getTestProject();
        TestResourceBundleMapSource.assertNotNull((Object)project);
        TestResourceBundleMapSource.assertTrue((boolean)project.isAccessible());
        resources.add((IResource)project);
        return resources;
    }

    public void testSanity() throws Exception {
        Map map = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._project1, (String)"bundles.bundle1");
        TestResourceBundleMapSource.assertNotNull((Object)map);
        TestResourceBundleMapSource.assertEquals((int)map.size(), (int)3);
        map = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._project2, (String)"bundles.bundle1");
        TestResourceBundleMapSource.assertNotNull((Object)map);
        TestResourceBundleMapSource.assertEquals((int)map.size(), (int)3);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this._project1.delete(true, null);
        this._project2.delete(true, null);
        this._project3.delete(true, null);
    }

    public void testContentsProject1Bundle1() throws Exception {
        Map map = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._project1, (String)"bundles.bundle1");
        TestResourceBundleMapSource.assertTrue((boolean)map.containsKey("prop1"));
        TestResourceBundleMapSource.assertEquals((Object)"blah", map.get("prop1"));
        TestResourceBundleMapSource.assertTrue((boolean)map.containsKey("one.dot"));
        TestResourceBundleMapSource.assertEquals((Object)"blah1", map.get("one.dot"));
        TestResourceBundleMapSource.assertTrue((boolean)map.containsKey("two.dot.property"));
        TestResourceBundleMapSource.assertEquals((Object)"blah3", map.get("two.dot.property"));
    }

    public void testContentsProject2Bundle1() throws Exception {
        Map map = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._project2, (String)"bundles.bundle1");
        TestResourceBundleMapSource.assertTrue((boolean)map.containsKey("x_prop1"));
        TestResourceBundleMapSource.assertEquals((Object)"x_blah", map.get("x_prop1"));
        TestResourceBundleMapSource.assertTrue((boolean)map.containsKey("x_one.dot"));
        TestResourceBundleMapSource.assertEquals((Object)"x_blah1", map.get("x_one.dot"));
        TestResourceBundleMapSource.assertTrue((boolean)map.containsKey("x_two.dot.property"));
        TestResourceBundleMapSource.assertEquals((Object)"x_blah3", map.get("x_two.dot.property"));
    }

    public void testBundleDelete() throws JavaModelException, IOException, CoreException {
        Map map = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._project1, (String)"bundles.bundle1");
        TestResourceBundleMapSource.assertTrue((boolean)map.containsKey("prop1"));
        TestResourceBundleMapSource.assertEquals((Object)"blah", map.get("prop1"));
        TestResourceBundleMapSource.assertTrue((boolean)map.containsKey("one.dot"));
        TestResourceBundleMapSource.assertEquals((Object)"blah1", map.get("one.dot"));
        TestResourceBundleMapSource.assertTrue((boolean)map.containsKey("two.dot.property"));
        TestResourceBundleMapSource.assertEquals((Object)"blah3", map.get("two.dot.property"));
        File bundleFile = this._bundle1.getLocation().toFile();
        TestResourceBundleMapSource.assertTrue((boolean)bundleFile.delete());
        this._bundle1.refreshLocal(2, null);
        TestResourceBundleMapSource.assertFalse((boolean)this._bundle1.isAccessible());
        TestResourceBundleMapSource.assertTrue((boolean)map.isEmpty());
        TestResourceBundleMapSource.assertNull(map.get("prop1"));
        TestResourceBundleMapSource.assertNull(map.get("one.dot"));
        TestResourceBundleMapSource.assertNull(map.get("two.dot.property"));
    }

    public void testProjectCloseCleanup() throws Exception {
        Map map = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._project3, (String)"bundles.bundle1");
        TestResourceBundleMapSource.assertTrue((boolean)map.containsKey("prop1"));
        TestResourceBundleMapSource.assertEquals((Object)"blah", map.get("prop1"));
        TestResourceBundleMapSource.assertTrue((boolean)map.containsKey("one.dot"));
        TestResourceBundleMapSource.assertEquals((Object)"blah1", map.get("one.dot"));
        TestResourceBundleMapSource.assertTrue((boolean)map.containsKey("two.dot.property"));
        TestResourceBundleMapSource.assertEquals((Object)"blah3", map.get("two.dot.property"));
        this._project3.close(null);
        TestResourceBundleMapSource.assertEquals((int)0, (int)map.size());
        boolean expectedExceptionThrown = false;
        try {
            map = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._project3, (String)"bundles.bundle1");
        }
        catch (CoreException coreException) {
            expectedExceptionThrown = true;
        }
        TestResourceBundleMapSource.assertTrue((boolean)expectedExceptionThrown);
    }
}

