/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tests;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import junit.framework.TestCase;
import org.eclipse.callisto.tools.versionchecker.VersionLister;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;

public class BuildTests
extends TestCase {
    private static final String[] REQUIRED_FEATURE_FILES = new String[]{"epl-v10.html", "feature.properties", "feature.xml", "license.html"};
    private static final String REQUIRED_FEATURE_SUFFIX = ".jpg";
    private static final String[] REQUIRED_PLUGIN_FILES = new String[]{"about.html", "plugin.properties", "plugin.xml"};
    private static final String REQUIRED_PLUGIN_SUFFIX = ".jar";
    private static final String[] REQUIRED_FEATURE_PLUGIN_FILES = new String[]{"about.html", "about.ini", "about.mappings", "about.properties", "plugin.properties", "plugin.xml"};
    private static final String REQUIRED_FEATURE_PLUGIN_SUFFIX = ".gif";
    private static final String[] REQUIRED_FRAGMENT_FILES = new String[]{"fragment.xml"};
    private static final String REQUIRED_FRAGMENT_SUFFIX = "";
    private static final String[] REQUIRED_SWT_FRAGMENT_FILES = new String[]{"fragment.properties"};
    private static final String REQUIRED_SWT_FRAGMENT_SUFFIX = "";
    private static final String[] REQUIRED_SOURCE_FILES = new String[]{"about.html"};
    private static final String REQUIRED_SOURCE_SUFFIX = ".zip";
    private static final String[] REQUIRED_BUNDLE_FILES = new String[]{"about.html"};
    private static final String REQUIRED_BUNDLE_MANIFEST = "MANIFEST.MF";
    private static final String REQUIRED_BUNDLE_SUFFIX = ".jar";
    private static final String[] SUFFIX_EXEMPT_LIST = new String[]{"org.eclipse.swt", "org.apache.ant"};
    private static final int EXPECTED_NUMBER_OF_TOTAL_FEATURES = 155;
    private static final int EXPECTED_NUMBER_OF_TOTAL_PLUGINS = 581;
    private static final int EXPECTED_NUMBER_OF_WTP_FEATURES = 1;
    private static final int EXPECTED_NUMBER_OF_WTP_PLUGINS = 5;
    private static final int EXPECTED_NUMBER_OF_WST_FEATURES = 39;
    private static final int EXPECTED_NUMBER_OF_WST_PLUGINS = 124;
    private static final int EXPECTED_NUMBER_OF_JST_FEATURES = 34;
    private static final int EXPECTED_NUMBER_OF_JST_PLUGINS = 121;
    private static final int EXPECTED_NUMBER_OF_JPT_FEATURES = 4;
    private static final int EXPECTED_NUMBER_OF_JPT_PLUGINS = 11;
    FilenameFilter wtpFilenameFilter = new WTPFileNameFilter();
    FilenameFilter wstFilenameFilter = new WSTFileNameFilter();
    FilenameFilter jstFilenameFilter = new JSTFileNameFilter();
    FilenameFilter jptFilenameFilter = new JPTFileNameFilter();

    public BuildTests(String arg0) {
        super(arg0);
    }

    public void _testFeatureFiles() {
        ArrayList<String> result = new ArrayList<String>();
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File featureDir = new File(installDir, "features");
        File[] features = featureDir.listFiles();
        int i = 0;
        while (i < features.length) {
            File aFeature = features[i];
            if (!this.testDirectory(aFeature, REQUIRED_FEATURE_FILES, REQUIRED_FEATURE_SUFFIX)) {
                result.add(aFeature.getPath());
            }
            ++i;
        }
        String aString = "";
        if (result.size() > 0) {
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                aString = String.valueOf(aString) + element + "; ";
            }
        }
        BuildTests.assertTrue((String)("Feature directory missing required files: " + aString), (result.size() == 0 ? 1 : 0) != 0);
    }

    public void testNumberOfTOTALFeatures() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File featureDir = new File(installDir, "features");
        File[] features = featureDir.listFiles();
        int nFeatures = features.length;
        if (nFeatures != 155) {
            System.out.println("there were more or less TOTAL features than expected: Found: " + nFeatures + "   Expected: " + 155);
        }
    }

    public void testNumberOfWTPFeatures() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File featureDir = new File(installDir, "features");
        File[] features = featureDir.listFiles(this.wtpFilenameFilter);
        int nFeatures = features.length;
        BuildTests.assertEquals((String)"there were more or less WTP features than expected: ", (int)1, (int)nFeatures);
    }

    public void testNumberOfWSTFeatures() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File featureDir = new File(installDir, "features");
        File[] features = featureDir.listFiles(this.wstFilenameFilter);
        int nFeatures = features.length;
        BuildTests.assertEquals((String)"there were more or less WST features than expected: ", (int)39, (int)nFeatures);
    }

    public void testNumberOfJSTFeatures() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File featureDir = new File(installDir, "features");
        File[] features = featureDir.listFiles(this.jstFilenameFilter);
        int nFeatures = features.length;
        BuildTests.assertEquals((String)"there were more or less JST features than expected: ", (int)34, (int)nFeatures);
    }

    public void testNumberOfJPTFeatures() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File featureDir = new File(installDir, "features");
        File[] features = featureDir.listFiles(this.jptFilenameFilter);
        int nFeatures = features.length;
        BuildTests.assertEquals((String)"there were more or less JPT features than expected: ", (int)4, (int)nFeatures);
    }

    public void _testPluginFiles() {
        ArrayList<String> result = new ArrayList<String>();
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File pluginDir = new File(installDir, "plugins");
        File[] plugins = pluginDir.listFiles();
        System.out.println("nPlugins: " + plugins.length);
        int i = 0;
        while (i < plugins.length) {
            File aPlugin = plugins[i];
            if (aPlugin.getName().indexOf("test") == -1 && !this.testPluginFile(aPlugin)) {
                result.add(aPlugin.getPath());
            }
            ++i;
        }
        String aString = "";
        if (result.size() > 0) {
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                aString = String.valueOf(aString) + element + "; ";
            }
        }
        BuildTests.assertTrue((String)("Plugin directory missing required files: " + aString), (result.size() == 0 ? 1 : 0) != 0);
    }

    public void testNumberOfTOTALPlugins() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File pluginDir = new File(installDir, "plugins");
        File[] plugins = pluginDir.listFiles();
        int nPlugins = plugins.length;
        if (nPlugins != 581) {
            System.out.println("there were more or less TOTAL plugins than expected: Found: " + nPlugins + "   Expected: " + 581);
        }
    }

    public void testNumberOfWTPPlugins() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File pluginDir = new File(installDir, "plugins");
        File[] plugins = pluginDir.listFiles(this.wtpFilenameFilter);
        int nPlugins = plugins.length;
        BuildTests.assertEquals((String)"there were more or less WTP plugins than expected: ", (int)5, (int)nPlugins);
    }

    public void testNumberOfWSTPlugins() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File pluginDir = new File(installDir, "plugins");
        File[] plugins = pluginDir.listFiles(this.wstFilenameFilter);
        int nPlugins = plugins.length;
        BuildTests.assertEquals((String)"there were more or less WST plugins than expected: ", (int)124, (int)nPlugins);
    }

    public void testNumberOfJSTPlugins() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File pluginDir = new File(installDir, "plugins");
        File[] plugins = pluginDir.listFiles(this.jstFilenameFilter);
        int nPlugins = plugins.length;
        BuildTests.assertEquals((String)"there were more or less JST plugins than expected: ", (int)121, (int)nPlugins);
    }

    public void testNumberOfJPTPlugins() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File pluginDir = new File(installDir, "plugins");
        File[] plugins = pluginDir.listFiles(this.jptFilenameFilter);
        int nPlugins = plugins.length;
        BuildTests.assertEquals((String)"there were more or less JPT plugins than expected: ", (int)11, (int)nPlugins);
    }

    private boolean testPluginFile(File aPlugin) {
        if (this.testDirectory(aPlugin, REQUIRED_PLUGIN_FILES, REQUIRED_SOURCE_SUFFIX)) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_FEATURE_PLUGIN_FILES, REQUIRED_FEATURE_PLUGIN_SUFFIX)) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_PLUGIN_FILES, ".jar")) {
            return true;
        }
        if (this.testSourcePlugin(aPlugin)) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_FRAGMENT_FILES, "") || this.testBundleDirectory(aPlugin, REQUIRED_BUNDLE_FILES, REQUIRED_BUNDLE_MANIFEST, "")) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_SWT_FRAGMENT_FILES, "")) {
            return true;
        }
        return this.testBundleDirectory(aPlugin, REQUIRED_BUNDLE_FILES, REQUIRED_BUNDLE_MANIFEST, ".jar");
    }

    private boolean testPluginJar(File aDirectory, String[] requiredFiles) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ZipFile jarredPlugin = new ZipFile(aDirectory);
            Enumeration<? extends ZipEntry> _enum = jarredPlugin.entries();
            while (_enum.hasMoreElements()) {
                list.add(((Object)_enum.nextElement()).toString());
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list.containsAll(Arrays.asList(requiredFiles));
    }

    private boolean testDirectory(File aDirectory, String[] requiredFiles, String requiredSuffix) {
        if (aDirectory.getName().endsWith(".jar")) {
            return this.testPluginJar(aDirectory, requiredFiles);
        }
        if (!Arrays.asList(aDirectory.list()).containsAll(Arrays.asList(requiredFiles))) {
            return false;
        }
        int index = aDirectory.getName().indexOf(95);
        if (index == -1) {
            index = aDirectory.getName().length();
        }
        return true;
    }

    private boolean testBundleDirectory(File aDirectory, String[] requiredFiles, String manifestFile, String requiredSuffix) {
        if (aDirectory.getName().endsWith(".jar")) {
            return this.testPluginJar(aDirectory, requiredFiles);
        }
        if (!Arrays.asList(aDirectory.list()).containsAll(Arrays.asList(requiredFiles))) {
            return false;
        }
        int index = aDirectory.getName().indexOf(95);
        if (index == -1) {
            index = aDirectory.getName().length();
        }
        String plainName = aDirectory.getName().substring(0, index);
        File metaDir = new File(aDirectory, "META-INF");
        String[] metaFiles = metaDir.list();
        if (metaFiles == null) {
            return false;
        }
        int i = 0;
        while (i < metaFiles.length) {
            String filename = metaFiles[i];
            if (filename == manifestFile) {
                return true;
            }
            ++i;
        }
        if (!metaDir.exists()) {
            return false;
        }
        if (requiredSuffix.equals("") || Arrays.asList(SUFFIX_EXEMPT_LIST).contains(plainName)) {
            return true;
        }
        return aDirectory.listFiles(new FileSuffixFilter(requiredSuffix)).length != 0;
    }

    private boolean testSourcePlugin(File aPlugin) {
        if (!this.testDirectory(aPlugin, REQUIRED_PLUGIN_FILES, "")) {
            return false;
        }
        File sourceDir = new File(aPlugin, "src");
        File[] sourceDirs = sourceDir.listFiles();
        if (sourceDirs == null) {
            return false;
        }
        int i = 0;
        while (i < sourceDirs.length) {
            File aSourceDir = sourceDirs[i];
            if (!this.testDirectory(aSourceDir, REQUIRED_SOURCE_FILES, REQUIRED_SOURCE_SUFFIX)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void testVersionCompare() throws Exception {
        VersionLister versionLister = new VersionLister();
        String[] args = new String[]{"-testToReference", "WTP-2.0.2", "-listToReferenceFile"};
        Object result = versionLister.run((Object)args);
        boolean testok = IApplication.EXIT_OK.equals(result);
        BuildTests.assertTrue((String)"There is an error in versioning. See full listing for details.", (boolean)testok);
    }

    public class FileSuffixFilter
    implements FilenameFilter {
        private String suffix;

        public FileSuffixFilter(String suffix) {
            this.suffix = suffix;
        }

        public boolean accept(File dir, String name) {
            int lastDot = name.lastIndexOf(46);
            if (lastDot == -1) {
                return false;
            }
            return name.substring(lastDot).equals(this.suffix);
        }
    }

    public class JPTFileNameFilter
    implements FilenameFilter {
        String namespaceOfInterest = "org.eclipse.jpt";

        public boolean accept(File dir, String name) {
            return dir.getName().startsWith(this.namespaceOfInterest) || name.startsWith(this.namespaceOfInterest);
        }
    }

    public class JSTFileNameFilter
    implements FilenameFilter {
        String namespaceOfInterest = "org.eclipse.jst";

        public boolean accept(File dir, String name) {
            return dir.getName().startsWith(this.namespaceOfInterest) || name.startsWith(this.namespaceOfInterest);
        }
    }

    public class WSTFileNameFilter
    implements FilenameFilter {
        String namespaceOfInterest = "org.eclipse.wst";

        public boolean accept(File dir, String name) {
            return dir.getName().startsWith(this.namespaceOfInterest) || name.startsWith(this.namespaceOfInterest);
        }
    }

    public class WTPFileNameFilter
    implements FilenameFilter {
        String namespaceOfInterest = "org.eclipse.wtp";

        public boolean accept(File dir, String name) {
            return dir.getName().startsWith(this.namespaceOfInterest) || name.startsWith(this.namespaceOfInterest);
        }
    }
}

