/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.test.BVTValidationException;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.internal.registry.BVTValidationRegistryReader;
import org.eclipse.jst.validation.test.internal.registry.ITestcaseMetaData;
import org.eclipse.jst.validation.test.internal.registry.MessageMetaData;
import org.eclipse.jst.validation.test.internal.registry.MessageUtility;
import org.eclipse.jst.validation.test.internal.registry.OperationTestcase;
import org.eclipse.jst.validation.test.internal.registry.ValidatorTestcase;
import org.eclipse.jst.validation.test.setup.IBuffer;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.TaskListUtility;
import org.eclipse.wst.validation.internal.VThreadManager;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.OneValidatorOperation;
import org.eclipse.wst.validation.internal.operations.ValidationOperation;

public final class BVTRunner {
    private static BVTRunner _inst = null;
    private List _extra = new ArrayList();
    private List _missing = new ArrayList();

    public static BVTRunner singleton() {
        if (_inst == null) {
            _inst = new BVTRunner();
        }
        return _inst;
    }

    private BVTRunner() {
    }

    private boolean isVerbose() {
        Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
        return logger.isLoggingLevel(Level.FINEST);
    }

    private char getSeverityChar(Integer severity) {
        if (severity == null) {
            return '?';
        }
        switch (severity) {
            case 2: {
                return 'E';
            }
            case 1: {
                return 'W';
            }
            case 0: {
                return 'I';
            }
        }
        return '?';
    }

    private String[] getNames(IProject[] projects) {
        if (projects == null) {
            return new String[0];
        }
        String[] names = new String[projects.length];
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            names[i] = project.getName();
            ++i;
        }
        return names;
    }

    private void debug(IBuffer buffer, IMarker[] messages) {
        if (messages == null) {
            buffer.write("Nothing to debug because nothing was reported");
        }
        int i = 0;
        while (i < messages.length) {
            IMarker marker = messages[i];
            buffer.write(MessageUtility.toString(marker));
            ++i;
        }
    }

    protected IProgressMonitor getDebugMonitor(IProgressMonitor monitor) {
        if (this.isVerbose()) {
            return monitor;
        }
        return new NullProgressMonitor();
    }

    public int test(IBuffer buffer, IProject[] projects) throws BVTValidationException {
        String[] testNames = this.getNames(projects);
        BVTValidationRegistryReader reader = BVTValidationRegistryReader.getReader();
        buffer.getProgressMonitor().beginTask("Running BVT tests", projects.length);
        int totalTests = 0;
        int totalPassed = 0;
        int i = 0;
        while (i < projects.length) {
            buffer.getProgressMonitor().subTask("Testing project " + (i + 1) + " of " + projects.length);
            IProject project = projects[i];
            ValidatorTestcase[] tests = reader.getValidatorTests(buffer.getProgressMonitor(), testNames[i]);
            if (tests == null || tests.length == 0) {
                buffer.getProgressMonitor().subTask("There are no tests to run.");
            } else {
                int numTestsPassed = 0;
                int j = 0;
                while (j < tests.length) {
                    ValidatorTestcase tmd = tests[j];
                    if (this.test(buffer, project, tmd, 0)) {
                        ++numTestsPassed;
                        buffer.getProgressMonitor().subTask("Test " + (j + 1) + " of " + tests.length + " passed.");
                    } else {
                        buffer.getProgressMonitor().subTask("Test " + (j + 1) + " of " + tests.length + " failed.");
                    }
                    buffer.getProgressMonitor().worked(1);
                    ++j;
                }
                totalTests += tests.length;
                totalPassed += numTestsPassed;
                buffer.write(String.valueOf(numTestsPassed) + " of " + tests.length + " tests passed.");
            }
            ++i;
        }
        buffer.write("\n>>>>>>>>>>TEST RESULTS>>>>>>>>>>");
        buffer.write(String.valueOf(totalPassed) + " of " + totalTests + " tests passed.");
        buffer.getProgressMonitor().done();
        return totalPassed;
    }

    public boolean test(IBuffer buffer, IProject project, ValidatorTestcase tmd, int validationEnumType) throws BVTValidationException {
        switch (validationEnumType) {
            case 0: {
                return this.test(buffer, tmd.getName(), "RUN_VALIDATION", tmd.getMessages(validationEnumType), (ValidationOperation)new OneValidatorOperation(project, tmd.getValidatorClass(), true, false), InternalValidatorManager.getManager().getValidatorNames(new ValidatorMetaData[]{tmd.getValidatorMetaData()}));
            }
            case 6: {
                return this.build(buffer, project, tmd, validationEnumType, "FULL_BUILD");
            }
            case 10: {
                return this.build(buffer, project, tmd, validationEnumType, "INCREMENTAL_BUILD");
            }
            case 9: {
                return this.build(buffer, project, tmd, validationEnumType, "AUTO_BUILD");
            }
        }
        buffer.addExecutionStatus(tmd.getName(), null, 2, buffer, "Unrecognized validation option:" + validationEnumType);
        return false;
    }

    private boolean build(IBuffer buffer, final IProject project, final ValidatorTestcase tmd, int validationEnumType, String subTaskName) throws BVTValidationException {
        try {
            NullProgressMonitor nullMonitor = new NullProgressMonitor();
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    block3: {
                        try {
                            IResource[] resources = tmd.getResources(project);
                            int i = 0;
                            while (i < resources.length) {
                                IResource res = resources[i];
                                res.touch(monitor);
                                ++i;
                            }
                        }
                        catch (CoreException exc) {
                            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                            if (!logger.isLoggingLevel(Level.SEVERE)) break block3;
                            logger.write((Throwable)exc);
                        }
                    }
                }
            }, (IProgressMonitor)nullMonitor);
        }
        catch (CoreException exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write((Throwable)exc);
            }
            buffer.addExecutionStatus(tmd.getName(), subTaskName, 2, buffer, "CoreException caught; stack trace in LoggingUtil.log");
            return false;
        }
        try {
            project.build(validationEnumType, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write((Throwable)exc);
            }
            buffer.write("CoreException caught; stack trace in LoggingUtil.log");
            return false;
        }
        IMarker[] messages = TaskListUtility.getValidationTasks((IResource)project, (String[])InternalValidatorManager.getManager().getValidatorNames(new ValidatorMetaData[]{tmd.getValidatorMetaData()}));
        return this.verify(buffer, tmd.getName(), subTaskName, project, tmd.getMessages(validationEnumType), messages);
    }

    public boolean test(IBuffer buffer, String testName, String subTaskName, List expectedMessages, ValidationOperation op, String[] validatorNames) throws BVTValidationException {
        IProgressMonitor debugMonitor = this.getDebugMonitor(buffer.getProgressMonitor());
        boolean passed = true;
        try {
            if (op == null) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.WARNING)) {
                    logger.write(Level.WARNING, "Cannot run tests because the Operation is null.");
                }
                passed = false;
            } else {
                try {
                    ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, debugMonitor);
                    if (op.isFork()) {
                        while (!VThreadManager.getManager().isDone()) {
                        }
                    }
                    IMarker[] messages = TaskListUtility.getValidationTasks((IResource)op.getProject(), (String[])validatorNames);
                    passed = this.verify(buffer, testName, subTaskName, op.getProject(), expectedMessages, messages);
                }
                catch (Throwable exc) {
                    Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        logger.write(Level.SEVERE, exc);
                    }
                    passed = false;
                }
            }
        }
        catch (Throwable exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, exc);
            }
            passed = false;
        }
        return passed;
    }

    public boolean setupTests(IBuffer buffer, boolean verbose) {
        ValidatorTestcase[] vts = BVTValidationRegistryReader.getReader().getValidatorTests(buffer.getProgressMonitor(), (String)null);
        OperationTestcase[] ots = BVTValidationRegistryReader.getReader().getOperationTests(buffer.getProgressMonitor(), (String)null);
        boolean successful = true;
        int i = 0;
        while (i < vts.length) {
            ValidatorTestcase vtest = vts[i];
            successful = this.setupTests(buffer, vtest, false) && successful;
            ++i;
        }
        int j = 0;
        while (j < ots.length) {
            OperationTestcase otest = ots[j];
            successful = this.setupTests(buffer, otest, false) && successful;
            ++j;
        }
        return successful;
    }

    /*
     * Exception decompiling
     */
    public boolean setupTests(IBuffer buffer, ITestcaseMetaData tmd, boolean verbose) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 412->415)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compare(IBuffer buffer, String testName, String subTaskName, List tmdMmdList, IMarker[] ml2) {
        numMatched = 0;
        mmdList = new ArrayList<E>(tmdMmdList);
        numExpected = mmdList.size();
        numReported = ml2.length;
        passed = true;
        try {
            Collections.sort(mmdList, MessageUtility.getMessageComparator(buffer, this.isVerbose()));
            try {
                try {
                    i = 0;
                    while (true) {
                        block21: {
                            if (i < ml2.length) break block21;
                            if (mmdList.size() != 0) {
                                this._missing.addAll(mmdList);
                            }
                            ** GOTO lbl-1000
                        }
                        marker = ml2[i];
                        matching = this.getMatchingMetaData(buffer, mmdList, marker);
                        if (matching == null) {
                            this._extra.add(marker);
                        } else {
                            mmdList.remove(matching);
                            ++numMatched;
                        }
                        ++i;
                    }
                }
                catch (Throwable exc) {
                    logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        logger.write(Level.SEVERE, exc);
                    }
                    passed = false;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var15_15) {
                var14_16 = null;
                passed = passed != false && this._missing.size() == 0 && this._extra.size() == 0;
                Collections.sort(this._missing, MessageUtility.getMessageComparator(buffer, this.isVerbose()));
                iterator = this._missing.iterator();
            }
            while (true) {
                if (!iterator.hasNext()) break;
                mmd = (MessageMetaData)iterator.next();
                buffer.addExecutionStatus(testName, subTaskName, 2, buffer, "ERROR[missing message]: " + MessageUtility.toString(mmd));
            }
            Collections.sort(this._extra, MessageUtility.getMessageComparator(buffer, this.isVerbose()));
            iterator = this._extra.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    if (numExpected != numReported) {
                        buffer.write("Wrong number of messages reported. Expected " + numExpected + " and got " + numReported);
                    }
                    buffer.write("Number of extra messages: " + this._extra.size());
                    buffer.write("Number of missing messages: " + this._missing.size());
                    buffer.write("Number of matched messages: " + numMatched);
                    throw var15_15;
                }
                marker = (IMarker)iterator.next();
                buffer.addExecutionStatus(testName, subTaskName, 2, buffer, "ERROR[extra message]: " + MessageUtility.toString(marker) + ", Text is: \"" + MessageUtility.getMessage(marker) + "\"");
            }
lbl-1000:
            // 3 sources

            {
                var14_17 = null;
                passed = passed != false && this._missing.size() == 0 && this._extra.size() == 0;
                Collections.sort(this._missing, MessageUtility.getMessageComparator(buffer, this.isVerbose()));
                iterator = this._missing.iterator();
                while (true) {
                    if (!iterator.hasNext()) break;
                    mmd = (MessageMetaData)iterator.next();
                    buffer.addExecutionStatus(testName, subTaskName, 2, buffer, "ERROR[missing message]: " + MessageUtility.toString(mmd));
                }
                Collections.sort(this._extra, MessageUtility.getMessageComparator(buffer, this.isVerbose()));
                iterator = this._extra.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (numExpected != numReported) {
                            buffer.write("Wrong number of messages reported. Expected " + numExpected + " and got " + numReported);
                        }
                        break;
                    }
                    marker = (IMarker)iterator.next();
                    buffer.addExecutionStatus(testName, subTaskName, 2, buffer, "ERROR[extra message]: " + MessageUtility.toString(marker) + ", Text is: \"" + MessageUtility.getMessage(marker) + "\"");
                }
                buffer.write("Number of extra messages: " + this._extra.size());
                buffer.write("Number of missing messages: " + this._missing.size());
                buffer.write("Number of matched messages: " + numMatched);
            }
        }
        catch (Throwable var19_22) {
            var18_23 = null;
            mmdList.clear();
            this._extra.clear();
            this._missing.clear();
            throw var19_22;
        }
        {
            var18_24 = null;
            mmdList.clear();
            this._extra.clear();
            this._missing.clear();
            return passed;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verify(IBuffer buffer, String testName, String subTaskName, IProject project, List mmdListOrig, IMarker[] messages) {
        block49: {
            block46: {
                block45: {
                    block48: {
                        block42: {
                            block43: {
                                buffer.write("Test case: " + testName);
                                numMatched = 0;
                                numExpected = 0;
                                numReported = 0;
                                passed = true;
                                mmdList = new ArrayList<E>(mmdListOrig);
                                try {
                                    try {
                                        if (messages == null) {
                                            passed = false;
                                            logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                                            if (logger.isLoggingLevel(Level.INFO)) {
                                                logger.write(Level.INFO, "No messages were reported.");
                                            }
                                            var19_15 = passed;
                                            var17_16 = null;
                                            if (this._missing.size() != 0 || this._extra.size() != 0) {
                                                passed = false;
                                            }
                                            if (!passed) break block42;
                                            buffer.write("PASS[Testcase::" + testName + "]");
                                            break block43;
                                        }
                                        numExpected = mmdList.size();
                                        numReported = messages.length;
                                        Collections.sort(mmdList, MessageUtility.getMessageComparator(buffer, this.isVerbose()));
                                        i = 0;
                                        while (true) {
                                            block44: {
                                                block47: {
                                                    if (i < messages.length) break block47;
                                                    if (mmdList.size() != 0) {
                                                        this._missing.addAll(mmdList);
                                                    }
                                                    ** GOTO lbl-1000
                                                }
                                                marker = messages[i];
                                                mmd = this.getMatchingMetaData(buffer, mmdList, marker);
                                                if (mmd == null) {
                                                    this._extra.add(marker);
                                                } else {
                                                    mmdList.remove(mmd);
                                                    if (this.isVerbose()) {
                                                        buffer.write("matched " + MessageUtility.toString(marker) + " to " + MessageUtility.toString(mmd));
                                                    }
                                                    ++numMatched;
                                                    try {
                                                        this.verifySeverity(buffer, testName, subTaskName, mmd, marker);
                                                    }
                                                    catch (CoreException e) {
                                                        passed = false;
                                                        logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                                                        if (logger.isLoggingLevel(Level.SEVERE)) {
                                                            logger.write(Level.SEVERE, (Exception)e);
                                                        }
                                                        buffer.write("ERROR[Testcase::" + testName + "]. CoreException caught while verifying severity");
                                                        break block44;
                                                    }
                                                    try {
                                                        this.verifyResource(buffer, testName, subTaskName, mmd, marker);
                                                    }
                                                    catch (CoreException e) {
                                                        passed = false;
                                                        buffer.write("ERROR[Testcase::" + testName + "]. CoreException caught while verifying resource");
                                                        logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                                                        if (logger.isLoggingLevel(Level.SEVERE)) {
                                                            logger.write(Level.SEVERE, (Exception)e);
                                                        }
                                                        break block44;
                                                    }
                                                    try {
                                                        this.verifyLocation(buffer, testName, subTaskName, mmd, marker);
                                                    }
                                                    catch (CoreException e) {
                                                        passed = false;
                                                        logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                                                        if (logger.isLoggingLevel(Level.SEVERE)) {
                                                            logger.write(Level.SEVERE, (Exception)e);
                                                        }
                                                        buffer.write("ERROR[Testcase::" + testName + "]. CoreException caught while verifying line number");
                                                    }
                                                }
                                            }
                                            ++i;
                                        }
                                    }
                                    catch (Throwable exc) {
                                        logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                                        if (logger.isLoggingLevel(Level.SEVERE)) {
                                            logger.write(Level.SEVERE, exc);
                                        }
                                        passed = false;
                                        ** GOTO lbl-1000
                                    }
                                }
                                catch (Throwable var18_32) {
                                    var17_17 = null;
                                    if (this._missing.size() != 0 || this._extra.size() != 0) {
                                        passed = false;
                                    }
                                    if (passed) {
                                        buffer.write("PASS[Testcase::" + testName + "]");
                                        buffer.addExecutionStatus(testName, subTaskName, true);
                                    } else {
                                        buffer.write("FAIL[Testcase::" + testName + "]");
                                        if (this.isVerbose()) {
                                            buffer.write("List of markers reported:");
                                            this.debug(buffer, messages);
                                        }
                                    }
                                    Collections.sort(this._missing, MessageUtility.getMessageComparator(buffer, this.isVerbose()));
                                    iterator = this._missing.iterator();
                                    break block45;
                                }
                            }
                            buffer.addExecutionStatus(testName, subTaskName, true);
                            break block48;
                        }
                        buffer.write("FAIL[Testcase::" + testName + "]");
                        if (this.isVerbose()) {
                            buffer.write("List of markers reported:");
                            this.debug(buffer, messages);
                        }
                    }
                    Collections.sort(this._missing, MessageUtility.getMessageComparator(buffer, this.isVerbose()));
                    iterator = this._missing.iterator();
                    while (true) {
                        if (!iterator.hasNext()) break;
                        mmd = (MessageMetaData)iterator.next();
                        buffer.addExecutionStatus(testName, subTaskName, 2, buffer, "ERROR[missing message]: " + MessageUtility.toString(mmd));
                    }
                    Collections.sort(this._extra, MessageUtility.getMessageComparator(buffer, this.isVerbose()));
                    iterator = this._extra.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            if (numExpected != numReported) {
                                buffer.write("Wrong number of messages reported. Expected " + numExpected + " and got " + numReported);
                            }
                            break;
                        }
                        marker = (IMarker)iterator.next();
                        buffer.addExecutionStatus(testName, subTaskName, 2, buffer, "ERROR[extra message]: " + MessageUtility.toString(marker) + ", Text is: \"" + MessageUtility.getMessage(marker) + "\"");
                    }
                    buffer.write("Number of extra messages: " + this._extra.size());
                    buffer.write("Number of missing messages: " + this._missing.size());
                    buffer.write("Number of matched messages: " + numMatched);
                    buffer.write("End of test case: " + testName);
                    this._extra.clear();
                    this._missing.clear();
                    return var19_15;
                }
                while (true) {
                    if (!iterator.hasNext()) break;
                    mmd = (MessageMetaData)iterator.next();
                    buffer.addExecutionStatus(testName, subTaskName, 2, buffer, "ERROR[missing message]: " + MessageUtility.toString(mmd));
                }
                Collections.sort(this._extra, MessageUtility.getMessageComparator(buffer, this.isVerbose()));
                iterator = this._extra.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (numExpected != numReported) {
                            buffer.write("Wrong number of messages reported. Expected " + numExpected + " and got " + numReported);
                        }
                        buffer.write("Number of extra messages: " + this._extra.size());
                        buffer.write("Number of missing messages: " + this._missing.size());
                        buffer.write("Number of matched messages: " + numMatched);
                        buffer.write("End of test case: " + testName);
                        this._extra.clear();
                        this._missing.clear();
                        throw var18_32;
                    }
                    marker = (IMarker)iterator.next();
                    buffer.addExecutionStatus(testName, subTaskName, 2, buffer, "ERROR[extra message]: " + MessageUtility.toString(marker) + ", Text is: \"" + MessageUtility.getMessage(marker) + "\"");
                }
lbl-1000:
                // 2 sources

                {
                    var17_18 = null;
                    if (this._missing.size() != 0 || this._extra.size() != 0) {
                        passed = false;
                    }
                    if (!passed) break block46;
                    buffer.write("PASS[Testcase::" + testName + "]");
                }
                buffer.addExecutionStatus(testName, subTaskName, true);
                break block49;
            }
            buffer.write("FAIL[Testcase::" + testName + "]");
            if (this.isVerbose()) {
                buffer.write("List of markers reported:");
                this.debug(buffer, messages);
            }
        }
        Collections.sort(this._missing, MessageUtility.getMessageComparator(buffer, this.isVerbose()));
        iterator = this._missing.iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            mmd = (MessageMetaData)iterator.next();
            buffer.addExecutionStatus(testName, subTaskName, 2, buffer, "ERROR[missing message]: " + MessageUtility.toString(mmd));
        }
        Collections.sort(this._extra, MessageUtility.getMessageComparator(buffer, this.isVerbose()));
        iterator = this._extra.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (numExpected != numReported) {
                    buffer.write("Wrong number of messages reported. Expected " + numExpected + " and got " + numReported);
                }
                buffer.write("Number of extra messages: " + this._extra.size());
                buffer.write("Number of missing messages: " + this._missing.size());
                buffer.write("Number of matched messages: " + numMatched);
                buffer.write("End of test case: " + testName);
                this._extra.clear();
                this._missing.clear();
                return passed;
            }
            marker = (IMarker)iterator.next();
            buffer.addExecutionStatus(testName, subTaskName, 2, buffer, "ERROR[extra message]: " + MessageUtility.toString(marker) + ", Text is: \"" + MessageUtility.getMessage(marker) + "\"");
        }
    }

    private int verifySeverity(IBuffer buffer, String testName, String subTaskName, MessageMetaData mmd, IMarker marker) throws CoreException {
        Integer prefixSeverity = MessageUtility.getSeverity(marker);
        if (prefixSeverity != null) {
            Integer severity = (Integer)marker.getAttribute("severity");
            boolean severityEqual = true;
            severityEqual = severity == null && prefixSeverity == null ? true : (severity == null ? false : (prefixSeverity == null ? false : severity.equals(prefixSeverity)));
            if (!severityEqual) {
                buffer.addExecutionStatus(testName, subTaskName, 1, buffer, "WARNING[mismatching severity]: expected " + this.getSeverityChar(prefixSeverity) + ", got " + this.getSeverityChar(severity) + " on marker " + MessageUtility.toString(marker));
                return 1;
            }
        }
        return 0;
    }

    private int verifyResource(IBuffer buffer, String testName, String subTaskName, MessageMetaData mmd, IMarker marker) throws CoreException {
        String resource = MessageUtility.getResource(marker);
        if (!resource.equals(mmd.getResource())) {
            buffer.addExecutionStatus(testName, subTaskName, 1, buffer, "INFO[wrong resource]: expected " + mmd.getResource() + ", got " + resource + " on marker " + MessageUtility.toString(marker));
            return 1;
        }
        return 0;
    }

    private int verifyLocation(IBuffer buffer, String testName, String subTaskName, MessageMetaData mmd, IMarker marker) throws CoreException {
        if (mmd.isSetLineNumber()) {
            Integer lineNumber = MessageUtility.getLineNumber(marker);
            if (lineNumber == null) {
                return 0;
            }
            if (lineNumber.intValue() != mmd.getLineNumber()) {
                buffer.addExecutionStatus(testName, subTaskName, 1, buffer, "INFO[wrong location]: expected " + mmd.getLineNumber() + ", got " + lineNumber + " on marker " + MessageUtility.toString(marker));
                return 1;
            }
        } else if (mmd.isSetLocation()) {
            String location = MessageUtility.getLocation(marker);
            if (location == null) {
                return 0;
            }
            if (!mmd.getLocation().equals(location)) {
                buffer.addExecutionStatus(testName, subTaskName, 1, buffer, "INFO[wrong location]: expected " + mmd.getLocation() + ", got " + location + " on marker " + MessageUtility.toString(marker));
                return 1;
            }
        }
        return 0;
    }

    private MessageMetaData getMatchingMetaData(IBuffer buffer, List mmdList, IMarker marker) {
        int result = Collections.binarySearch(mmdList, marker, MessageUtility.getMessageComparator(buffer, this.isVerbose()));
        if (result < 0) {
            return null;
        }
        return (MessageMetaData)mmdList.get(result);
    }
}

