/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.beaninfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaEvent;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.jem.tests.beaninfo.AbstractBeanInfoTestCase;

public class TestReflection
extends AbstractBeanInfoTestCase {
    public TestReflection() {
    }

    public TestReflection(String name) {
        super(name);
    }

    public void testReflection() {
        JavaClass test1Class = (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test1Class"), true);
        TestReflection.assertSame((Object)TypeKind.CLASS_LITERAL, (Object)test1Class.getKind());
        EObject foo = this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test1Class/foo"), true);
        TestReflection.assertNotNull((Object)foo);
        EObject getFoo = this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#Test1Class/operation/getFoo"), true);
        TestReflection.assertNotNull((Object)getFoo);
    }

    public void testInnerReflectionInDefault() {
        JavaClass testInnerClass = (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/#TestDefaultInner"), true);
        TestReflection.assertSame((Object)TypeKind.CLASS_LITERAL, (Object)testInnerClass.getKind());
        EList properties = testInnerClass.getProperties();
        TestReflection.assertEquals((int)1, (int)properties.size());
        EStructuralFeature pf = (EStructuralFeature)properties.get(0);
        TestReflection.assertEquals((String)"propertyInner", (String)pf.getName());
        PropertyDecorator pd = Utilities.getPropertyDecorator((EModelElement)pf);
        TestReflection.assertNotNull((Object)pd);
        JavaClass pdType = (JavaClass)pd.getPropertyType();
        TestReflection.assertEquals((String)"TestDefaultInner$Inner", (String)pdType.getName());
        TestReflection.assertSame((Object)TypeKind.CLASS_LITERAL, (Object)pdType.getKind());
    }

    public void testInnerReflectionInPackage() {
        JavaClass testInnerClass = (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo#TestInner"), true);
        TestReflection.assertSame((Object)TypeKind.CLASS_LITERAL, (Object)testInnerClass.getKind());
        EList properties = testInnerClass.getProperties();
        TestReflection.assertEquals((int)1, (int)properties.size());
        EStructuralFeature pf = (EStructuralFeature)properties.get(0);
        TestReflection.assertEquals((String)"propertyInner", (String)pf.getName());
        PropertyDecorator pd = Utilities.getPropertyDecorator((EModelElement)pf);
        TestReflection.assertNotNull((Object)pd);
        JavaClass pdType = (JavaClass)pd.getPropertyType();
        TestReflection.assertEquals((String)"TestInner$Inner", (String)pdType.getName());
        TestReflection.assertSame((Object)TypeKind.CLASS_LITERAL, (Object)pdType.getKind());
    }

    private List getRealProps(List props) {
        int size = props.size();
        ArrayList<EStructuralFeature> newList = new ArrayList<EStructuralFeature>(size);
        int i = 0;
        while (i < size) {
            EStructuralFeature f = (EStructuralFeature)props.get(i);
            if (Utilities.getPropertyDecorator((EModelElement)f) != null) {
                newList.add(f);
            }
            ++i;
        }
        return newList;
    }

    public void testInterfacePropertyReflection() {
        JavaClass testPropClass = (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo.test#NotTopGuy"), true);
        TestReflection.assertTrue((boolean)testPropClass.isInterface());
        List props = this.getRealProps((List)testPropClass.getProperties());
        TestReflection.assertEquals((int)1, (int)props.size());
        TestReflection.assertEquals((String)"number", (String)((EStructuralFeature)props.get(0)).getName());
        props = this.getRealProps((List)testPropClass.getAllProperties());
        TestReflection.assertEquals((int)3, (int)props.size());
        List<String> validNames = Arrays.asList("number", "object", "integer");
        Iterator itr = props.iterator();
        while (itr.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)itr.next();
            TestReflection.assertTrue((String)("Extra feature:" + feature.getName()), (boolean)validNames.contains(feature.getName()));
        }
    }

    public void testInterfaceEventReflection() {
        JavaClass testEventClass = (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo.test#NotTopGuy"), true);
        TestReflection.assertTrue((boolean)testEventClass.isInterface());
        EList events = testEventClass.getEvents();
        TestReflection.assertTrue((boolean)events.isEmpty());
        events = testEventClass.getAllEvents();
        TestReflection.assertEquals((int)1, (int)events.size());
        TestReflection.assertEquals((String)"test1ClassEvent", (String)((JavaEvent)events.get(0)).getName());
    }

    public void testInterfaceOperationsReflection() {
        EOperation op;
        JavaClass testOpClass = (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/org.eclipse.jem.tests.beaninfo.test#NotTopGuy"), true);
        TestReflection.assertTrue((boolean)testOpClass.isInterface());
        EList ops = testOpClass.getEOperations();
        TestReflection.assertEquals((int)2, (int)ops.size());
        List<String> validNames = Arrays.asList("getNumber", "setNumber");
        Iterator itr = ops.iterator();
        while (itr.hasNext()) {
            op = (EOperation)itr.next();
            TestReflection.assertTrue((String)("Extra operation:" + op.getName()), (boolean)validNames.contains(op.getName()));
        }
        ops = testOpClass.getEAllOperations();
        TestReflection.assertEquals((int)8, (int)ops.size());
        validNames = Arrays.asList("getNumber", "setNumber", "getObject", "setObject", "getInteger", "setInteger", "addTest1ClassEventListener", "removeTest1ClassEventListener");
        itr = ops.iterator();
        while (itr.hasNext()) {
            op = (EOperation)itr.next();
            TestReflection.assertTrue((String)("Extra operation:" + op.getName()), (boolean)validNames.contains(op.getName()));
        }
    }
}

