/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.ui.ant;

import junit.framework.TestCase;
import org.apache.tools.ant.Task;
import org.eclipse.wst.wsdl.validation.internal.ui.ant.AntLogger;
import org.eclipse.wst.wsdl.validation.internal.ui.ant.AntLoggerTestTask;

public class AntLoggerTest
extends TestCase {
    AntLoggerTestTask task = null;

    protected void setUp() throws Exception {
        this.task = new AntLoggerTestTask();
    }

    protected void tearDown() throws Exception {
        this.task = null;
    }

    public void testLogErrorWithThrowable() {
        AntLogger logger = new AntLogger((Task)this.task);
        logger.log("MESSAGE", 0, new Throwable("THROWABLE"));
        AntLoggerTest.assertTrue((String)"Warnings were reported when only errors should have been reported.", (boolean)this.task.getWarnings().isEmpty());
        AntLoggerTest.assertTrue((String)"Infos were reported when only errors should have been reported.", (boolean)this.task.getInfos().isEmpty());
        AntLoggerTest.assertTrue((String)"Verboses were reported when only errors should have been reported.", (boolean)this.task.getVerboses().isEmpty());
        AntLoggerTest.assertEquals((String)"2 errors were not reported.", (int)2, (int)this.task.getErrors().size());
        AntLoggerTest.assertEquals((String)"The message was not MESSAGE.", (Object)"MESSAGE", this.task.getErrors().get(0));
        AntLoggerTest.assertEquals((String)"The throwable was not THROWABLE.", (Object)"java.lang.Throwable: THROWABLE", this.task.getErrors().get(1));
    }

    public void testLogWarningWithThrowable() {
        AntLogger logger = new AntLogger((Task)this.task);
        logger.log("MESSAGE", 1, new Throwable("THROWABLE"));
        AntLoggerTest.assertTrue((String)"Errors were reported when only warnings should have been reported.", (boolean)this.task.getErrors().isEmpty());
        AntLoggerTest.assertTrue((String)"Infos were reported when only warnings should have been reported.", (boolean)this.task.getInfos().isEmpty());
        AntLoggerTest.assertTrue((String)"Verboses were reported when only errors should have been reported.", (boolean)this.task.getVerboses().isEmpty());
        AntLoggerTest.assertEquals((String)"2 warnings were not reported.", (int)2, (int)this.task.getWarnings().size());
        AntLoggerTest.assertEquals((String)"The message was not MESSAGE.", (Object)"MESSAGE", this.task.getWarnings().get(0));
        AntLoggerTest.assertEquals((String)"The throwable was not THROWABLE.", (Object)"java.lang.Throwable: THROWABLE", this.task.getWarnings().get(1));
    }

    public void testLogInfoWithThrowable() {
        AntLogger logger = new AntLogger((Task)this.task);
        logger.log("MESSAGE", 2, new Throwable("THROWABLE"));
        AntLoggerTest.assertTrue((String)"Warnings were reported when only infos should have been reported.", (boolean)this.task.getWarnings().isEmpty());
        AntLoggerTest.assertTrue((String)"Errors were reported when only infos should have been reported.", (boolean)this.task.getErrors().isEmpty());
        AntLoggerTest.assertTrue((String)"Verboses were reported when only errors should have been reported.", (boolean)this.task.getVerboses().isEmpty());
        AntLoggerTest.assertEquals((String)"2 infos were not reported.", (int)2, (int)this.task.getInfos().size());
        AntLoggerTest.assertEquals((String)"The message was not MESSAGE.", (Object)"MESSAGE", this.task.getInfos().get(0));
        AntLoggerTest.assertEquals((String)"The throwable was not THROWABLE.", (Object)"java.lang.Throwable: THROWABLE", this.task.getInfos().get(1));
    }

    public void testLogVerboseWithThrowable() {
        AntLogger logger = new AntLogger((Task)this.task);
        logger.log("MESSAGE", 3, new Throwable("THROWABLE"));
        AntLoggerTest.assertTrue((String)"Warnings were reported when only verboses should have been reported.", (boolean)this.task.getWarnings().isEmpty());
        AntLoggerTest.assertTrue((String)"Errors were reported when only verboses should have been reported.", (boolean)this.task.getErrors().isEmpty());
        AntLoggerTest.assertTrue((String)"Infos were reported when only verboses should have been reported.", (boolean)this.task.getInfos().isEmpty());
        AntLoggerTest.assertEquals((String)"2 verboses were not reported.", (int)2, (int)this.task.getVerboses().size());
        AntLoggerTest.assertEquals((String)"The message was not MESSAGE.", (Object)"MESSAGE", this.task.getVerboses().get(0));
        AntLoggerTest.assertEquals((String)"The throwable was not THROWABLE.", (Object)"java.lang.Throwable: THROWABLE", this.task.getVerboses().get(1));
    }

    public void testLogErrorWithoutThrowable() {
        AntLogger logger = new AntLogger((Task)this.task);
        logger.log("MESSAGE", 0);
        AntLoggerTest.assertTrue((String)"Warnings were reported when only errors should have been reported.", (boolean)this.task.getWarnings().isEmpty());
        AntLoggerTest.assertTrue((String)"Infos were reported when only errors should have been reported.", (boolean)this.task.getInfos().isEmpty());
        AntLoggerTest.assertTrue((String)"Verboses were reported when only errors should have been reported.", (boolean)this.task.getVerboses().isEmpty());
        AntLoggerTest.assertEquals((String)"1 error was not reported.", (int)1, (int)this.task.getErrors().size());
        AntLoggerTest.assertEquals((String)"The message was not MESSAGE.", (Object)"MESSAGE", this.task.getErrors().get(0));
    }

    public void testLogWarningWithoutThrowable() {
        AntLogger logger = new AntLogger((Task)this.task);
        logger.log("MESSAGE", 1);
        AntLoggerTest.assertTrue((String)"Errors were reported when only warnings should have been reported.", (boolean)this.task.getErrors().isEmpty());
        AntLoggerTest.assertTrue((String)"Infos were reported when only warnings should have been reported.", (boolean)this.task.getInfos().isEmpty());
        AntLoggerTest.assertTrue((String)"Verboses were reported when only errors should have been reported.", (boolean)this.task.getVerboses().isEmpty());
        AntLoggerTest.assertEquals((String)"1 error was not reported.", (int)1, (int)this.task.getWarnings().size());
        AntLoggerTest.assertEquals((String)"The message was not MESSAGE.", (Object)"MESSAGE", this.task.getWarnings().get(0));
    }

    public void testLogInfoWithoutThrowable() {
        AntLogger logger = new AntLogger((Task)this.task);
        logger.log("MESSAGE", 2);
        AntLoggerTest.assertTrue((String)"Warnings were reported when only infos should have been reported.", (boolean)this.task.getWarnings().isEmpty());
        AntLoggerTest.assertTrue((String)"Errors were reported when only infos should have been reported.", (boolean)this.task.getErrors().isEmpty());
        AntLoggerTest.assertTrue((String)"Verboses were reported when only errors should have been reported.", (boolean)this.task.getVerboses().isEmpty());
        AntLoggerTest.assertEquals((String)"1 info was not reported.", (int)1, (int)this.task.getInfos().size());
        AntLoggerTest.assertEquals((String)"The message was not MESSAGE.", (Object)"MESSAGE", this.task.getInfos().get(0));
    }

    public void testLogVerboseWithoutThrowable() {
        AntLogger logger = new AntLogger((Task)this.task);
        logger.log("MESSAGE", 3);
        AntLoggerTest.assertTrue((String)"Warnings were reported when only verboses should have been reported.", (boolean)this.task.getWarnings().isEmpty());
        AntLoggerTest.assertTrue((String)"Errors were reported when only verboses should have been reported.", (boolean)this.task.getErrors().isEmpty());
        AntLoggerTest.assertTrue((String)"Infos were reported when only verboses should have been reported.", (boolean)this.task.getInfos().isEmpty());
        AntLoggerTest.assertEquals((String)"1 verbose was not reported.", (int)1, (int)this.task.getVerboses().size());
        AntLoggerTest.assertEquals((String)"The message was not MESSAGE.", (Object)"MESSAGE", this.task.getVerboses().get(0));
    }
}

