/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadata.tests.annotations;

import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.jst.jsf.contentmodel.annotation.CMAnnotationHelper;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.CMAnnotationFileRegistry;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.CMAnnotationMap;
import org.eclipse.jst.jsf.metadata.tests.annotations.ICMAnnotationTestCases;

public class AnnotationMapTestCases
extends TestCase
implements ICMAnnotationTestCases {
    private CMAnnotationFileRegistry reg;
    private List maps;

    public void setUp() {
        this.reg = CMAnnotationFileRegistry.getInstance();
        Assert.assertTrue((this.reg != null ? 1 : 0) != 0);
    }

    public void testAnnotationsMapsDefaultParser() {
        boolean hasInfos = CMAnnotationHelper.hasAnnotations((String)"http://org.eclipse.jsf/test");
        Assert.assertTrue((boolean)hasInfos);
        this.maps = this.reg.getAnnotationMaps("http://org.eclipse.jsf/test");
        Assert.assertNotNull((Object)this.maps);
        CMAnnotationMap map = (CMAnnotationMap)this.maps.get(0);
        this.execAsserts(map);
    }

    public void testAnnotationsMapsDifferentParser() {
        boolean hasInfos = CMAnnotationHelper.hasAnnotations((String)"http://org.eclipse.jsf/test2");
        Assert.assertTrue((boolean)hasInfos);
        this.maps = this.reg.getAnnotationMaps("http://org.eclipse.jsf/test2");
        Assert.assertNotNull((Object)this.maps);
        CMAnnotationMap map = (CMAnnotationMap)this.maps.get(0);
        this.execAsserts(map);
    }

    private void execAsserts(CMAnnotationMap map) {
        Assert.assertNull((Object)map.getCMElementProperty("validator", "foobar"));
        Assert.assertNotNull((Object)map.getCMAttributeProperty("validator", "validatorId", "attr-val-content-assistant"));
        Assert.assertEquals((String)map.getCMAttributeProperty("validator", "validatorId", "attr-val-content-assistant"), (String)"com.eclipse.wtp.jsf.ui.internal.ValidatorAttrValueContentAssistant");
        Assert.assertNull((Object)map.getCMAttributeProperty("validator", "validatorId", "A"));
        Assert.assertNull((Object)map.getCMElementProperty("nopropsOrAttrs", "A"));
        Assert.assertNull((Object)map.getCMAttributeProperty("nopropsOrAttrs", "validatorId", "A"));
        Assert.assertNotNull((Object)map.getCMElementProperty("noAttrs", "A"));
        Assert.assertEquals((String)map.getCMElementProperty("noAttrs", "A"), (String)"a");
        Assert.assertEquals((String)map.getCMElementProperty("noAttrs", "B"), (String)"b");
        Assert.assertNotNull((Object)map.getCMElementProperty("loaded", "A"));
        Assert.assertEquals((String)map.getCMElementProperty("loaded", "A"), (String)"a");
        Assert.assertEquals((String)map.getCMElementProperty("loaded", "B"), (String)"b");
        Assert.assertEquals((String)map.getCMAttributeProperty("loaded", "att1", "B1"), (String)"b1");
        Assert.assertEquals((String)map.getCMAttributeProperty("loaded", "att2", "B2"), (String)"b2");
        Assert.assertEquals((String)map.getCMAttributeProperty("loaded", "att3", "B3"), (String)"b3");
        Assert.assertEquals((int)map.getCMAttributePropertyValues("loaded", "att3", "multival").size(), (int)3);
        Assert.assertEquals((int)map.getCMElementPropertyValues("loaded", "multival").size(), (int)3);
    }
}

