/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.css.core.tests.source;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jst.jsp.core.tests.NullInputStream;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.osgi.framework.Bundle;

public class JSPedCSSSourceParserTest
extends TestCase {
    private static final String FILES_DIR = "src/org/eclipse/jst/jsp/css/core/tests/testfiles";
    private static final String RESULTS_DIR = "src/org/eclipse/jst/jsp/css/core/tests/testfiles/results";
    private static final String MODE_OPEN = "MODE_OPEN";
    private static final String MODE_APPEND = "MODE_APPEND";
    private static final String MODE_INSERT = "MODE_INSERT";
    private static final String commonEOL = "\r\n";
    static int index_jsp = 0;
    static int index_jspf = 0;

    public void testSourceOpen1() throws IOException {
        this.sourceParserTest("sample01.jsp", MODE_OPEN);
    }

    public void testSourceAppend1() throws IOException {
        this.sourceParserTest("sample01.jsp", MODE_APPEND);
    }

    public void testSourceInsert1() throws IOException {
        this.sourceParserTest("sample01.jsp", MODE_INSERT);
    }

    public void testSourceOpen2() throws IOException {
        this.sourceParserTest("sample02.jsp", MODE_OPEN);
    }

    public void testSourceAppend2() throws IOException {
        this.sourceParserTest("sample02.jsp", MODE_APPEND);
    }

    public void testSourceOpen3() throws IOException {
        this.sourceParserTest("sample03.jsp", MODE_OPEN);
    }

    public void testSourceAppend3() throws IOException {
        this.sourceParserTest("sample03.jsp", MODE_APPEND);
    }

    public void testSourceOpen4() throws IOException {
        this.sourceParserTest("sample04.jsp", MODE_OPEN);
    }

    public void testSourceAppend4() throws IOException {
        this.sourceParserTest("sample04.jsp", MODE_APPEND);
    }

    public void testSourceInsert4() throws IOException {
        this.sourceParserTest("sample04.jsp", MODE_INSERT);
    }

    public void testSourceOpen5() throws IOException {
        this.sourceParserTest("sample05.jsp", MODE_OPEN);
    }

    public void testSourceAppend5() throws IOException {
        this.sourceParserTest("sample05.jsp", MODE_APPEND);
    }

    public void testSourceInsert5() throws IOException {
        this.sourceParserTest("sample05.jsp", MODE_INSERT);
    }

    public void testSourceOpen6() throws IOException {
        this.sourceParserTest("sample06.jsp", MODE_OPEN);
    }

    public void testSourceAppend6() throws IOException {
        this.sourceParserTest("sample06.jsp", MODE_APPEND);
    }

    public void testSourceOpen7() throws IOException {
        this.sourceParserTest("sample01.jspf", MODE_OPEN);
    }

    public void testSourceAppend7() throws IOException {
        this.sourceParserTest("sample01.jspf", MODE_APPEND);
    }

    public void testSourceInsert7() throws IOException {
        this.sourceParserTest("sample01.jspf", MODE_INSERT);
    }

    public void testSourceOpen8() throws IOException {
        this.sourceParserTest("sample02.jspf", MODE_OPEN);
    }

    public void testSourceAppend8() throws IOException {
        this.sourceParserTest("sample02.jspf", MODE_APPEND);
    }

    public void testSourceOpen9() throws IOException {
        this.sourceParserTest("sample03.jspf", MODE_OPEN);
    }

    public void testSourceAppend9() throws IOException {
        this.sourceParserTest("sample03.jspf", MODE_APPEND);
    }

    public void testSourceOpen10() throws IOException {
        this.sourceParserTest("sample04.jspf", MODE_OPEN);
    }

    public void testSourceAppend10() throws IOException {
        this.sourceParserTest("sample04.jspf", MODE_APPEND);
    }

    public void testSourceInsert10() throws IOException {
        this.sourceParserTest("sample04.jspf", MODE_INSERT);
    }

    public void testSourceOpen11() throws IOException {
        this.sourceParserTest("sample05.jspf", MODE_OPEN);
    }

    public void testSourceAppend11() throws IOException {
        this.sourceParserTest("sample05.jspf", MODE_APPEND);
    }

    public void testSourceInsert11() throws IOException {
        this.sourceParserTest("sample05.jspf", MODE_INSERT);
    }

    public void testSourceOpen12() throws IOException {
        this.sourceParserTest("sample06.jspf", MODE_OPEN);
    }

    public void testSourceAppend12() throws IOException {
        this.sourceParserTest("sample06.jspf", MODE_APPEND);
    }

    public void testSourceOpen13() throws IOException {
        this.sourceParserTest("sample07.jspf", MODE_OPEN);
    }

    public void testSourceAppend13() throws IOException {
        this.sourceParserTest("sample07.jspf", MODE_APPEND);
    }

    public void testSourceInsert13() throws IOException {
        this.sourceParserTest("sample07.jspf", MODE_INSERT);
    }

    public void testSourceOpen14() throws IOException {
        this.sourceParserTest("sample07.jsp", MODE_OPEN);
    }

    public void testSourceAppend14() throws IOException {
        this.sourceParserTest("sample07.jsp", MODE_APPEND);
    }

    public void testSourceInsert14() throws IOException {
        this.sourceParserTest("sample07.jsp", MODE_INSERT);
    }

    protected void setUp() throws Exception {
        IContentType ct = Platform.getContentTypeManager().getContentType("org.eclipse.jst.jsp.core.cssjspsource");
        ct.addFileSpec("cssjsptest0.jsp", 4);
        ct.addFileSpec("cssjsptest1.jsp", 4);
        ct.addFileSpec("cssjsptest2.jsp", 4);
        ct.addFileSpec("cssjsptest3.jsp", 4);
        ct.addFileSpec("cssjsptest4.jsp", 4);
        ct.addFileSpec("cssjsptest5.jsp", 4);
        ct.addFileSpec("cssjsptest6.jsp", 4);
        ct.addFileSpec("cssjsptest7.jsp", 4);
        ct.addFileSpec("cssjsptest8.jsp", 4);
        ct.addFileSpec("cssjsptest9.jsp", 4);
        ct.addFileSpec("cssjsptest10.jsp", 4);
        ct.addFileSpec("cssjsptest11.jsp", 4);
        ct.addFileSpec("cssjsptest12.jsp", 4);
        ct.addFileSpec("cssjsptest13.jsp", 4);
        ct.addFileSpec("cssjsptest14.jsp", 4);
        ct.addFileSpec("cssjsptest15.jsp", 4);
        ct.addFileSpec("cssjsptest16.jsp", 4);
        ct.addFileSpec("cssjsptest17.jsp", 4);
        ct.addFileSpec("cssjsptest18.jsp", 4);
        ct.addFileSpec("cssjsptest19.jsp", 4);
        ct.addFileSpec("cssjsptest20.jsp", 4);
        ct = Platform.getContentTypeManager().getContentType("org.eclipse.jst.jsp.core.cssjspfragmentsource");
        ct.addFileSpec("cssjsptest0.jspf", 4);
        ct.addFileSpec("cssjsptest1.jspf", 4);
        ct.addFileSpec("cssjsptest2.jspf", 4);
        ct.addFileSpec("cssjsptest3.jspf", 4);
        ct.addFileSpec("cssjsptest4.jspf", 4);
        ct.addFileSpec("cssjsptest5.jspf", 4);
        ct.addFileSpec("cssjsptest6.jspf", 4);
        ct.addFileSpec("cssjsptest7.jspf", 4);
        ct.addFileSpec("cssjsptest8.jspf", 4);
        ct.addFileSpec("cssjsptest9.jspf", 4);
        ct.addFileSpec("cssjsptest10.jspf", 4);
        ct.addFileSpec("cssjsptest11.jspf", 4);
        ct.addFileSpec("cssjsptest12.jspf", 4);
        ct.addFileSpec("cssjsptest13.jspf", 4);
        ct.addFileSpec("cssjsptest14.jspf", 4);
        ct.addFileSpec("cssjsptest15.jspf", 4);
        ct.addFileSpec("cssjsptest16.jspf", 4);
        ct.addFileSpec("cssjsptest17.jspf", 4);
        ct.addFileSpec("cssjsptest18.jspf", 4);
        ct.addFileSpec("cssjsptest19.jspf", 4);
        ct.addFileSpec("cssjsptest20.jspf", 4);
    }

    private ICSSModel createModel(boolean isFragment) {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            model = !isFragment ? modelManager.getModelForEdit("cssjsptest" + index_jsp++ + ".jsp", (InputStream)new NullInputStream(), null) : modelManager.getModelForEdit("cssjsptest" + index_jspf++ + ".jspf", (InputStream)new NullInputStream(), null);
            model.getStructuredDocument().setLineDelimiter(commonEOL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (ICSSModel)model;
    }

    private File createFile(String directory, String filename) throws IOException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.jst.jsp.core.tests");
        URL url = bundle.getEntry("/");
        URL localURL = FileLocator.toFileURL((URL)url);
        String installPath = localURL.getPath();
        String totalDirectory = String.valueOf(installPath) + directory;
        String totalPath = String.valueOf(totalDirectory) + "/" + filename;
        URL totalURL = new URL(url, totalPath);
        String finalFile = totalURL.getFile();
        File file = new File(finalFile);
        return file;
    }

    private String createString(String directory, String filename) throws FileNotFoundException, IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        FileReader fileReader = new FileReader(this.createFile(directory, filename));
        BufferedReader reader = new BufferedReader(fileReader);
        while ((line = reader.readLine()) != null) {
            buf.append(line);
            buf.append(commonEOL);
        }
        return buf.toString();
    }

    private void sourceParserTest(String filename, String mode) throws IOException {
        ICSSModel model = null;
        if (mode.equals(MODE_OPEN)) {
            model = this.readModelOpen(filename);
        } else if (mode.equals(MODE_APPEND)) {
            model = this.readModelAppend(filename);
        } else if (mode.equals(MODE_INSERT)) {
            model = this.readModelInsert(filename);
        }
        String result = this.dumpRegions(model.getStructuredDocument());
        this.compareResult(result, "JSPedCSSSourceParserTest-" + filename);
        this.closeModel(model);
    }

    private ICSSModel readModelOpen(String filename) throws IOException {
        String source = this.createString(FILES_DIR, filename);
        ICSSModel model = this.createModel(filename.endsWith("jspf"));
        IStructuredDocument document = model.getStructuredDocument();
        document.replaceText(null, 0, 0, source);
        return model;
    }

    private ICSSModel readModelAppend(String filename) throws IOException {
        String source = this.createString(FILES_DIR, filename);
        ICSSModel model = this.createModel(filename.endsWith("jspf"));
        IStructuredDocument document = model.getStructuredDocument();
        int i = 0;
        while (i < source.length()) {
            document.replaceText(null, i, 0, source.substring(i, i + 1));
            ++i;
        }
        return model;
    }

    private ICSSModel readModelInsert(String filename) throws IOException {
        String source = this.createString(FILES_DIR, filename);
        ICSSModel model = this.createModel(filename.endsWith("jspf"));
        IStructuredDocument document = model.getStructuredDocument();
        int i = 0;
        while (i < source.length()) {
            int textIndex = source.length() - i - 1;
            document.replaceText(null, 0, 0, source.substring(textIndex, textIndex + 1));
            ++i;
        }
        return model;
    }

    private void closeModel(ICSSModel model) {
        model.releaseFromEdit();
    }

    private String dumpRegions(IStructuredDocument document) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.dumpRegions(document.getFirstStructuredDocumentRegion()));
        return buf.toString();
    }

    private String dumpRegions(IStructuredDocumentRegion region) {
        StringBuffer buf = new StringBuffer();
        while (region != null) {
            buf.append(this.dumpOneRegion(region));
            region = region.getNext();
        }
        buf.append("\r\n-------\r\n");
        return buf.toString();
    }

    private String dumpOneRegion(IStructuredDocumentRegion documentRegion) {
        StringBuffer buf = new StringBuffer();
        buf.append(documentRegion.toString());
        buf.append("\r\n    ");
        ITextRegionList regionList = documentRegion.getRegions();
        Iterator i = regionList.iterator();
        while (i.hasNext()) {
            ITextRegion textRegion = (ITextRegion)i.next();
            buf.append(textRegion.toString());
            buf.append(", ");
        }
        buf.append(commonEOL);
        return buf.toString();
    }

    private void compareResult(String actual, String filename) throws IOException {
        String result = this.createString(RESULTS_DIR, filename);
        JSPedCSSSourceParserTest.assertEquals((String)result, (String)actual);
    }
}

