/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests.performance;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.provisional.preferences.CommonEditorPreferenceNames;
import org.eclipse.wst.xml.ui.tests.performance.BasicEditorTest;
import org.eclipse.wst.xml.ui.tests.performance.EditorTestHelper;

public class ScrollTest
extends BasicEditorTest {
    public ScrollTest() {
        this.ZIP_FILE_NAME = "scroll-test.zip";
        this.PROJECT_NAME = "SCROLL-TEST";
        this.FILE_NAME = "xml/gbuna118.xml";
    }

    protected void setUpPrefs() {
        IPreferenceStore store = SSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS, false);
        IPreferenceStore editorsStore = EditorsUI.getPreferenceStore();
        editorsStore.setValue("quickdiff.quickDiff", false);
    }

    public void testScrolling() {
        this.setUpEditor(this.FILE_NAME);
        EditorTestHelper.calmDown(1000L, 5000L, 1000L);
        IDocument doc = this.getEditor().getDocumentProvider().getDocument((Object)this.getEditor().getEditorInput());
        int lines = doc.getNumberOfLines();
        int iterations = 3;
        int j = 0;
        while (j < iterations) {
            this.doScroll(lines);
            ++j;
        }
        this.startMeasuring();
        this.doScroll(lines);
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void doScroll(int lines) {
        this.setCaret(0);
        int i = 0;
        while (i < lines) {
            this.type(0x1000002, 0);
            this.runEvents();
            ++i;
        }
    }
}

