/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.classpath.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.classpath.tests.AbstractTests;
import org.eclipse.jst.j2ee.classpath.tests.util.ClasspathDependencyTestUtil;
import org.eclipse.jst.j2ee.classpathdep.UpdateClasspathAttributeUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveImpl;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyCreationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

public class ClasspathDependencyEARTests
extends AbstractTests {
    private static final String UTIL_PROJECT = "TestUtil";
    private static final String WEB_PROJECT = "TestWeb";
    private static final String EAR_PROJECT = "TestEAR";

    private ClasspathDependencyEARTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Classpath Dependency EAR Tests");
        suite.addTest((Test)new ClasspathDependencyEARTests("testEARExport"));
        suite.addTest((Test)new ClasspathDependencyEARTests("testEARPublish"));
        return suite;
    }

    public void testEARExport() throws Exception {
        this.createProjects();
        IProject earProject = ProjectUtil.getProject(EAR_PROJECT);
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add("Test1.jar");
        archiveNames.add("Test2.jar");
        this.verifyExportedEAR(earComp, archiveNames, false);
        this.addDependencyAttribute();
        this.verifyExportedEAR(earComp, archiveNames, true);
    }

    private void verifyExportedEAR(IVirtualComponent comp, Set archiveNames, boolean shouldHaveArchives) throws Exception {
        EARArtifactEdit earEdit = null;
        EARFile earFile = null;
        try {
            earEdit = EARArtifactEdit.getEARArtifactEditForRead((IVirtualComponent)comp);
            if (earEdit != null) {
                earFile = (EARFile)earEdit.asArchive(true);
                List archives = earFile.getArchiveFiles();
                Iterator it = archiveNames.iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    boolean hasArchive = false;
                    int i = 0;
                    while (i < archives.size()) {
                        org.eclipse.jst.j2ee.commonarchivecore.internal.File archive = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)archives.get(i);
                        if (archive.isArchive() && archive.getName().equals(name)) {
                            hasArchive = true;
                        }
                        ++i;
                    }
                    if (shouldHaveArchives) {
                        ClasspathDependencyEARTests.assertTrue((String)("Exported EAR missing classpath dependency Jar " + name), (boolean)hasArchive);
                        continue;
                    }
                    ClasspathDependencyEARTests.assertFalse((String)("Exported EAR has unexpected classpath dependency Jar " + name), (boolean)hasArchive);
                }
                int i = 0;
                while (i < archives.size()) {
                    org.eclipse.jst.j2ee.commonarchivecore.internal.File archive = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)archives.get(i);
                    if (archive.isArchive() && archive.getName().equals("TestUtil.jar")) {
                        ArchiveImpl archiveImpl = (ArchiveImpl)archive;
                        String[] cp = archiveImpl.getManifest().getClassPathTokenized();
                        while (it.hasNext()) {
                            String name = (String)it.next();
                            boolean isOnCP = false;
                            int j = 0;
                            while (j < cp.length) {
                                if (cp[j].equals(name)) {
                                    isOnCP = true;
                                }
                                ++j;
                            }
                            if (shouldHaveArchives) {
                                ClasspathDependencyEARTests.assertTrue((String)("Utility project MANIFEST.MF classpath in exported EAR is entry for dependency Jar " + name), (boolean)isOnCP);
                                continue;
                            }
                            ClasspathDependencyEARTests.assertTrue((String)("Utility project MANIFEST.MF classpath in exported EAR has unexpected entry for dependency Jar " + name), (boolean)isOnCP);
                        }
                    }
                    ++i;
                }
            }
        }
        finally {
            if (earEdit != null) {
                earEdit.dispose();
            }
            if (earFile != null) {
                earFile.close();
            }
        }
    }

    public void testEARPublish() throws Exception {
        this.createProjects();
        IProject earProject = ProjectUtil.getProject(EAR_PROJECT);
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add("Test1.jar");
        archiveNames.add("Test2.jar");
        this.verifyPublishedEAR(earComp, archiveNames, false);
        this.addDependencyAttribute();
        this.verifyPublishedEAR(earComp, archiveNames, true);
    }

    private void verifyPublishedEAR(IVirtualComponent comp, Set archiveNames, boolean shouldHaveArchives) throws Exception {
        J2EEFlexProjDeployable deployable = new J2EEFlexProjDeployable(comp.getProject(), comp);
        try {
            int i;
            IModuleResource[] members = deployable.members();
            for (String name : archiveNames) {
                boolean hasArchive = false;
                i = 0;
                while (i < members.length) {
                    if (members[i].getName().equals(name)) {
                        hasArchive = true;
                    }
                    ++i;
                }
                if (shouldHaveArchives) {
                    ClasspathDependencyEARTests.assertTrue((String)("Published EAR missing classpath dependency Jar " + name), (boolean)hasArchive);
                    continue;
                }
                ClasspathDependencyEARTests.assertFalse((String)("Published EAR has unexpected classpath dependency Jar " + name), (boolean)hasArchive);
            }
            IModule utilModule = null;
            IModule[] childModules = deployable.getChildModules();
            i = 0;
            while (i < childModules.length) {
                if (childModules[i].getName().equals(UTIL_PROJECT)) {
                    utilModule = childModules[i];
                }
                ++i;
            }
            ClasspathDependencyEARTests.assertNotNull((String)"Missing entry for utility project", utilModule);
            J2EEFlexProjDeployable projectModule = (J2EEFlexProjDeployable)utilModule.loadAdapter(ProjectModule.class, null);
            IModuleResource[] moduleMembers = projectModule.members();
            ArchiveManifestImpl manifest = null;
            boolean foundMetaInf = false;
            int i2 = 0;
            while (i2 < moduleMembers.length) {
                String name = moduleMembers[i2].getName();
                if (name.equals("META-INF")) {
                    foundMetaInf = true;
                    IModuleResource manifestResource = ((ModuleFolder)moduleMembers[i2]).members()[0];
                    ClasspathDependencyEARTests.assertTrue((boolean)manifestResource.getModuleRelativePath().toString().equals("META-INF"));
                    ClasspathDependencyEARTests.assertTrue((String)("Expected MANIFEST.MF, got " + manifestResource.getName()), (boolean)manifestResource.getName().equals("MANIFEST.MF"));
                    File manifestFile = (File)manifestResource.getAdapter(File.class);
                    if (manifestFile == null) {
                        manifestFile = ((IFile)manifestResource.getAdapter(IFile.class)).getLocation().toFile();
                    }
                    ClasspathDependencyEARTests.assertNotNull((Object)manifestFile);
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(manifestFile);
                        manifest = new ArchiveManifestImpl((InputStream)fis);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                }
                ++i2;
            }
            if (!foundMetaInf) {
                ClasspathDependencyEARTests.assertTrue((String)"members() failed to return META-INF for utility project module in published EAR", (boolean)foundMetaInf);
            }
            ClasspathDependencyEARTests.assertNotNull((String)"Failed to retrieve MANIFEST.MF from utility project module in published EAR", manifest);
            for (String name : archiveNames) {
                boolean isOnCP = false;
                String[] cp = manifest.getClassPathTokenized();
                int j = 0;
                while (j < cp.length) {
                    if (cp[j].equals(name)) {
                        isOnCP = true;
                    }
                    ++j;
                }
                if (shouldHaveArchives) {
                    ClasspathDependencyEARTests.assertTrue((String)("Utility project MANIFEST.MF classpath in published EAR missing entry for dependency Jar " + name), (boolean)isOnCP);
                    continue;
                }
                ClasspathDependencyEARTests.assertFalse((String)("Utility project MANIFEST.MF classpath in published EAR has unexpected entry for dependency Jar " + name), (boolean)isOnCP);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            ClasspathDependencyEARTests.fail((String)e.getMessage());
        }
    }

    private IVirtualComponent createProjects() throws Exception {
        IProject util = ProjectUtil.createUtilityProject(UTIL_PROJECT, EAR_PROJECT, true);
        util.getFolder("build").getFolder("classes");
        IJavaProject utilJava = JavaCore.create((IProject)util);
        ComponentCore.createComponent((IProject)util);
        IProject webProject = ProjectUtil.createWebProject(WEB_PROJECT, EAR_PROJECT, true);
        JavaCore.create((IProject)webProject);
        IVirtualComponent webComp = ComponentCore.createComponent((IProject)webProject);
        DependencyCreationUtil.createModuleDependency(webProject, util);
        ClasspathDependencyTestUtil.addCustomClasspathContainer(utilJava);
        return webComp;
    }

    private void addDependencyAttribute() throws Exception {
        IProject util = ProjectUtil.getProject(UTIL_PROJECT);
        IJavaProject utilJava = JavaCore.create((IProject)util);
        IVirtualComponent utilComp = ComponentCore.createComponent((IProject)util);
        HashSet<IPath> entryPaths = new HashSet<IPath>();
        entryPaths.add(ClasspathDependencyTestUtil.CUSTOM_CLASSPATH_CONTAINER);
        List entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(utilJava, entryPaths);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(utilJava);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(utilComp);
        IClasspathEntry entry = (IClasspathEntry)entries.get(0);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)util.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(utilJava);
        ClasspathDependencyTestUtil.verifyClasspathAttributes(utilJava, entryPaths);
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add("Test1.jar");
        archiveNames.add("Test2.jar");
        ClasspathDependencyTestUtil.verifyClasspathDependencies(utilComp, archiveNames);
    }
}

