/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.jca.operations;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jst.j2ee.jca.project.facet.ConnectorFacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaEEFacetConstants;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleProjectCreationOperationTest;

public class JCAProjectCreationOperationTest
extends ModuleProjectCreationOperationTest {
    public JCAProjectCreationOperationTest() {
        super("ConnectorProjectCreationOperationTests");
    }

    public JCAProjectCreationOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(JCAProjectCreationOperationTest.class);
        return suite;
    }

    public void testConnector10_Defaults() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("aConnector", null, null, JavaEEFacetConstants.CONNECTOR_1);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testConnector15_Defaults() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("bConnector", null, null, JavaEEFacetConstants.CONNECTOR_15);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testConnector10_WithEAR() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("cConnector", "myEAR", null, JavaEEFacetConstants.CONNECTOR_1);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testConnector15_WithEAR() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("dConnector", "yourEAR", null, JavaEEFacetConstants.CONNECTOR_15);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testConnector10_ChangedSrouceFolder() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("eConnector", null, "mySrc", JavaEEFacetConstants.CONNECTOR_1);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testConnector15_ChangedSrouceFolder() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("fConnector", null, "ourSrc", JavaEEFacetConstants.CONNECTOR_15);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testConnector10_ChangedSrouceFolder_WithEAR() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("gConnector", "coolEAR", "theirSrc", JavaEEFacetConstants.CONNECTOR_1);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testConnector15_ChangedSrouceFolder_WithEAR() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("hConnector", "netoEAR", "weSrc", JavaEEFacetConstants.CONNECTOR_15);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public static IDataModel getConnectorDataModel(String projName, String earName, String sourceFolder, IProjectFacetVersion version) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new ConnectorFacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        if (earName != null) {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)true);
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
        } else {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)false);
        }
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.connector");
        facetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)version);
        if (sourceFolder != null) {
            facetModel.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)sourceFolder);
        }
        if (version == JavaEEFacetConstants.CONNECTOR_15) {
            IDataModel javaFacetModel = facetMap.getFacetDataModel("jst.java");
            javaFacetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)JavaEEFacetConstants.JAVA_5);
        }
        return dm;
    }
}

