/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.contentassist.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.jsf.contentassist.tests.ContentAssistTestsPlugin;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ITextRegionContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.core.internal.contentassist.el.ContentAssistParser;
import org.eclipse.jst.jsf.core.internal.contentassist.el.ContentAssistStrategy;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.resolver.ISymbolContextResolver;
import org.eclipse.jst.jsf.designtime.resolver.StructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class Test_bug_149224
extends TestCase {
    private WebProjectTestEnvironment _testEnv;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this._testEnv = new WebProjectTestEnvironment("Test_bug_149224_" + this.getName());
        this._testEnv.createProject(false);
        Test_bug_149224.assertNotNull((Object)this._testEnv);
        Test_bug_149224.assertNotNull((Object)this._testEnv.getTestProject());
        Test_bug_149224.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize("1.1");
        this._testEnv.loadResourceInWebRoot(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/bug_149224_1.jsp.data", "/bug_149224.jsp");
        JDTTestEnvironment jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._testEnv);
        TestFileResource resource = new TestFileResource();
        resource.load(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/MyBean.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "MyBean", resource.toString());
        resource = new TestFileResource();
        resource.load(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/bug_149224.properties.data");
        jdtTestEnv.addResourceFile("src", (InputStream)new ByteArrayInputStream(resource.toBytes()), "bundles", "bundle1.properties");
    }

    public void testSanity() {
        ContextWrapper wrapper = null;
        try {
            try {
                wrapper = this.getDocumentContext("/WebContent/bug_149224.jsp", 589);
                IStructuredDocumentContext context = wrapper.getContext();
                IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
                Node node = resolver.getNode();
                JSFTestUtil.getIndexedRegion((IStructuredDocument)((IStructuredDocument)context.getStructuredDocument()), (int)589);
                Test_bug_149224.assertTrue((boolean)(node instanceof Attr));
                Test_bug_149224.assertEquals((String)"value", (String)((Attr)node).getNodeName());
                Test_bug_149224.assertEquals((String)"#{bundle1.}", (String)((Attr)node).getNodeValue());
                wrapper.dispose();
                wrapper = this.getDocumentContext("/WebContent/bug_149224.jsp", 630);
                context = wrapper.getContext();
                resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
                node = resolver.getNode();
                Test_bug_149224.assertTrue((boolean)(node instanceof Attr));
                Test_bug_149224.assertEquals((String)"value", (String)((Attr)node).getNodeName());
                Test_bug_149224.assertEquals((String)"#{bundle1.x}", (String)((Attr)node).getNodeValue());
                ISymbolContextResolver symbolResolver = StructuredDocumentSymbolResolverFactory.getInstance().getSymbolContextResolver((IModelContext)context);
                ISymbol bundleVar = symbolResolver.getVariable("bundle1");
                Test_bug_149224.assertNotNull((Object)bundleVar);
            }
            catch (Exception e) {
                e.printStackTrace();
                Test_bug_149224.fail((String)e.getLocalizedMessage());
                if (wrapper != null) {
                    wrapper.dispose();
                }
            }
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }

    public void testCompletionAtCloseBrace() {
        ContextWrapper wrapper = null;
        try {
            try {
                wrapper = this.getDocumentContext("/WebContent/bug_149224.jsp", 589);
                IStructuredDocumentContext context = wrapper.getContext();
                ITextRegionContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(context);
                ContentAssistStrategy strategy = ContentAssistParser.getPrefix((int)9, (String)"bundle1.");
                Test_bug_149224.assertNotNull((Object)strategy);
                List proposals = strategy.getProposals(context);
                ICompletionProposal proposal2 = null;
                for (ICompletionProposal proposal2 : proposals) {
                    if (proposal2.getDisplayString().startsWith("['")) break;
                }
                Test_bug_149224.assertNotNull(proposal2);
                proposal2.apply(wrapper.getContext().getStructuredDocument());
                String newELText = resolver.getRegionText();
                Test_bug_149224.assertEquals((String)"bundle1['prop.with.dots_x']", (String)newELText);
            }
            catch (Exception e) {
                e.printStackTrace();
                Test_bug_149224.fail((String)e.getLocalizedMessage());
                if (wrapper != null) {
                    wrapper.dispose();
                }
            }
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }

    public void testCompletionAtProperty() {
        ContextWrapper wrapper = null;
        try {
            try {
                wrapper = this.getDocumentContext("/WebContent/bug_149224.jsp", 630);
                IStructuredDocumentContext context = wrapper.getContext();
                ITextRegionContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(context);
                ContentAssistStrategy strategy = ContentAssistParser.getPrefix((int)9, (String)"bundle1.x");
                Test_bug_149224.assertNotNull((Object)strategy);
                List proposals = strategy.getProposals(context);
                ICompletionProposal proposal2 = null;
                for (ICompletionProposal proposal2 : proposals) {
                    if (proposal2.getDisplayString().startsWith("['")) break;
                }
                Test_bug_149224.assertNotNull(proposal2);
                proposal2.apply(wrapper.getContext().getStructuredDocument());
                String newELText = resolver.getRegionText();
                Test_bug_149224.assertEquals((String)"bundle1['prop.with.dots_x']x", (String)newELText);
            }
            catch (Exception e) {
                e.printStackTrace();
                Test_bug_149224.fail((String)e.getLocalizedMessage());
                if (wrapper != null) {
                    wrapper.dispose();
                }
            }
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }

    private ContextWrapper getDocumentContext(String path, int offset) throws Exception {
        IProject project = this._testEnv.getTestProject();
        IFile jspFile = project.getFile((IPath)new Path(path));
        Test_bug_149224.assertTrue((boolean)jspFile.exists());
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        model = modelManager.getModelForRead(jspFile);
        Test_bug_149224.assertTrue((boolean)(model instanceof DOMModelForJSP));
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)model.getStructuredDocument(), offset);
        return new ContextWrapper(context, model);
    }

    private static class ContextWrapper {
        private final IStructuredDocumentContext _context;
        private final IStructuredModel _model;

        ContextWrapper(IStructuredDocumentContext context, IStructuredModel model) {
            this._context = context;
            this._model = model;
        }

        IStructuredDocumentContext getContext() {
            return this._context;
        }

        IStructuredModel getModel() {
            return this._model;
        }

        void dispose() {
            this._model.releaseFromRead();
        }
    }
}

