/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;

public class BuiltInTypesTreeViewerProvider {
    ILabelProvider labelProvider;
    ITreeContentProvider contentProvider;
    private static int BUILT_IN_TYPES_SUB_GROUP = 3;
    static String[] numberTypes = new String[]{"base64Binary", "byte", "decimal", "double", "float", "hexBinary", "int", "integer", "long", "negativeInteger", "nonNegativeInteger", "nonPositiveInteger", "positiveInteger", "short", "unsignedByte", "unsignedInt", "unsignedLong", "unsignedShort"};
    static String[] dateAndTimeTypes = new String[]{"date", "dateTime", "duration", "gDay", "gMonth", "gMonthDay", "gYear", "gYearMonth", "time"};

    public static List getAllBuiltInTypes() {
        ArrayList items = new ArrayList();
        Iterator it = items.iterator();
        ArrayList<Object> mainContainer = new ArrayList<Object>(BUILT_IN_TYPES_SUB_GROUP);
        ComponentSpecification header = new ComponentSpecification("", "Root", null);
        mainContainer.add(header);
        ArrayList<ComponentSpecification> numbersGroup = new ArrayList<ComponentSpecification>();
        header = new ComponentSpecification("", "Numbers", null);
        numbersGroup.add(header);
        mainContainer.add(numbersGroup);
        ArrayList<ComponentSpecification> dateAndTimeGroup = new ArrayList<ComponentSpecification>();
        header = new ComponentSpecification("", "Date and Time", null);
        dateAndTimeGroup.add(header);
        mainContainer.add(dateAndTimeGroup);
        ArrayList<ComponentSpecification> otherGroup = new ArrayList<ComponentSpecification>();
        header = new ComponentSpecification("", "Other", null);
        otherGroup.add(header);
        mainContainer.add(otherGroup);
        while (it.hasNext()) {
            Object item = it.next();
            String name = item.toString();
            ComponentSpecification builtInTypeItem = new ComponentSpecification(name, "http://www.w3.org/2001/XMLSchema", null);
            if (BuiltInTypesTreeViewerProvider.partOf(name, numberTypes)) {
                numbersGroup.add(builtInTypeItem);
                continue;
            }
            if (BuiltInTypesTreeViewerProvider.partOf(name, dateAndTimeTypes)) {
                dateAndTimeGroup.add(builtInTypeItem);
                continue;
            }
            otherGroup.add(builtInTypeItem);
        }
        return mainContainer;
    }

    public ILabelProvider getLabelProvider() {
        if (this.labelProvider != null) {
            return this.labelProvider;
        }
        this.labelProvider = new BuiltInTypeLabelProvider();
        return this.labelProvider;
    }

    public ITreeContentProvider getContentProvider() {
        if (this.contentProvider != null) {
            return this.contentProvider;
        }
        this.contentProvider = new BuiltInTypesTreeContentProvider();
        return this.contentProvider;
    }

    private static boolean partOf(String item, String[] array) {
        int i = 0;
        while (i < array.length) {
            if (item.equals(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class BuiltInTypeLabelProvider
    implements ILabelProvider {
        BuiltInTypeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (this.getText(element).equals("Numbers")) {
                return XSDEditorPlugin.getXSDImage("icons/XSDNumberTypes.gif");
            }
            if (this.getText(element).equals("Date and Time")) {
                return XSDEditorPlugin.getXSDImage("icons/XSDDateAndTimeTypes.gif");
            }
            if (this.getText(element).equals("Other")) {
                return XSDEditorPlugin.getXSDImage("icons/browsebutton.gif");
            }
            if (element instanceof ComponentSpecification) {
                return XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif");
            }
            return null;
        }

        public String getText(Object element) {
            ComponentSpecification spec = null;
            if (element instanceof List) {
                spec = (ComponentSpecification)((List)element).get(0);
            } else if (element instanceof ComponentSpecification) {
                spec = (ComponentSpecification)element;
            }
            return spec.getName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class BuiltInTypesTreeContentProvider
    implements ITreeContentProvider {
        BuiltInTypesTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                List parentContent = (List)parentElement;
                return parentContent.subList(1, parentContent.size()).toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 1;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

