/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.osgi.framework.Bundle;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JSFTestUtil {
    public static void setValidationEnabled(boolean isEnabled) throws InvocationTargetException {
        GlobalConfiguration config = new GlobalConfiguration(ConfigurationManager.getManager().getGlobalConfiguration());
        config.setDisableAllValidation(!isEnabled);
        config.passivate();
        config.store();
    }

    public static void setInternetProxyPreferences(boolean proxied, String proxyHostName, String proxyPort) {
    }

    public static void loadSourceClass(Bundle bundle, String fileName, String beanClassName, String srcFolderName, String packageName, JDTTestEnvironment jdtTestEnvironment) throws Exception {
        TestFileResource codeRes = new TestFileResource();
        codeRes.load(bundle, fileName);
        String code = codeRes.toString();
        jdtTestEnvironment.addSourceFile(srcFolderName, packageName, beanClassName, code);
    }

    public static URI getPlatformAbsPath(String relativePath) throws MalformedURLException, URISyntaxException {
        URL url = new URL(Platform.getInstanceLocation().getURL(), relativePath);
        return url.toURI();
    }

    public static IPath getAbsolutePath(Bundle bundle, String relativePath) throws IOException, URISyntaxException {
        URL url = FileLocator.resolve((URL)bundle.getEntry(relativePath));
        return new Path(new File(url.toURI()).getAbsolutePath());
    }

    public static void savePlatformRelative(TestFileResource testFile, String relativePath) throws IOException, URISyntaxException {
        JSFTestUtil.saveToFileSystem(testFile, JSFTestUtil.getPlatformAbsPath(relativePath));
    }

    public static void saveToFileSystem(TestFileResource testFile, URI absPath) throws IOException {
        JSFTestUtil.saveToFileSystem(testFile.toBytes(), absPath);
    }

    public static void saveToFileSystem(byte[] buffer, URI absPath) throws IOException {
        File file = new File(absPath);
        FileOutputStream outFile = null;
        try {
            outFile = new FileOutputStream(file);
            outFile.write(buffer);
        }
        finally {
            if (outFile != null) {
                outFile.close();
            }
        }
    }

    public static boolean areEqual(TestFileResource testFile, URI absPath) throws IOException {
        File file = new File(absPath);
        return Arrays.equals(JSFTestUtil.loadFromFile(file).toByteArray(), testFile.toBytes());
    }

    public static ByteArrayOutputStream loadFromFile(File file) throws IOException {
        FileInputStream inFile = null;
        ByteArrayOutputStream buffer = null;
        try {
            int bytesRead;
            inFile = new FileInputStream(file);
            buffer = new ByteArrayOutputStream();
            byte[] inBuffer = new byte[1024];
            int curPos = 0;
            while ((bytesRead = inFile.read(inBuffer)) != -1) {
                buffer.write(inBuffer, 0, bytesRead);
                curPos += bytesRead;
            }
            ByteArrayOutputStream byteArrayOutputStream = buffer;
            return byteArrayOutputStream;
        }
        finally {
            if (inFile != null) {
                inFile.close();
            }
        }
    }

    public static IndexedRegion getIndexedRegion(IStructuredDocument document, int documentOffset) {
        IndexedRegion region;
        block8: {
            IStructuredModel model = JSFTestUtil.getStructuredModel(document);
            region = null;
            if (model != null) {
                try {
                    int lastOffset = documentOffset;
                    region = model.getIndexedRegion(documentOffset);
                    JSFTestUtil.trace("Starting at region: " + region.toString());
                    while (region == null && lastOffset >= 0) {
                        region = model.getIndexedRegion(--lastOffset);
                        JSFTestUtil.trace("Iterating on region: " + region.toString());
                    }
                    JSFTestUtil.trace("Finished with: " + region.toString() + ", Class: " + region.getClass());
                    if (!(region instanceof IDOMElement)) break block8;
                    JSFTestUtil.trace("Region is an IDOMElement");
                    IDOMElement domElement = (IDOMElement)region;
                    NamedNodeMap attributes = domElement.getAttributes();
                    int i = 0;
                    while (i < attributes.getLength()) {
                        Node attrNode = attributes.item(i);
                        if (attrNode instanceof IDOMAttr) {
                            IDOMAttr attr = (IDOMAttr)attrNode;
                            JSFTestUtil.trace("Examining attribute: " + attr.toString());
                            if (documentOffset >= attr.getStartOffset() && documentOffset < attr.getEndOffset()) {
                                region = attr;
                                JSFTestUtil.trace("Found attribute: " + region.toString());
                                break;
                            }
                        }
                        ++i;
                    }
                }
                finally {
                    JSFTestUtil.trace("releasing model");
                    model.releaseFromRead();
                }
            }
        }
        JSFTestUtil.trace("returning: " + region);
        return region;
    }

    private static void trace(String message) {
        System.out.println("getIndexedRegion: " + message);
    }

    private static IStructuredModel getStructuredModel(IStructuredDocument document) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        if (modelManager != null) {
            return StructuredModelManager.getModelManager().getModelForRead(document);
        }
        return null;
    }
}

