/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.classpath.tests;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.j2ee.classpath.tests.AbstractTests;
import org.eclipse.jst.j2ee.classpath.tests.util.ClasspathDependencyTestUtil;
import org.eclipse.jst.j2ee.classpathdep.UpdateClasspathAttributeUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyCreationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainer;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ClasspathDependencyValidationTests
extends AbstractTests {
    private ClasspathDependencyValidationTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Classpath Component Dependency Validation Tests");
        suite.addTest((Test)new ClasspathDependencyValidationTests("testSourceEntryRule"));
        suite.addTest((Test)new ClasspathDependencyValidationTests("testProjectEntryRule"));
        suite.addTest((Test)new ClasspathDependencyValidationTests("testClassFolderRule"));
        suite.addTest((Test)new ClasspathDependencyValidationTests("testNonWebNonExportedRule"));
        suite.addTest((Test)new ClasspathDependencyValidationTests("testRootMappingNonEARWARRefRule"));
        suite.addTest((Test)new ClasspathDependencyValidationTests("testInvalidContainerRules"));
        suite.addTest((Test)new ClasspathDependencyValidationTests("testNonTaggedExportedClassesRule"));
        return suite;
    }

    public void testSourceEntryRule() throws Exception {
        IProject project = ProjectUtil.createUtilityProject("TestUtil", "TestEAR", true);
        ClasspathDependencyTestUtil.verifyNoValidationError(project);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        IClasspathEntry src = null;
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 3) {
                src = entries[i];
                break;
            }
            ++i;
        }
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)project.getName(), src);
        DependencyUtil.waitForValidationJobs(project);
        ClasspathDependencyTestUtil.verifyClasspathDependencyError(project);
        UpdateClasspathAttributeUtil.removeDependencyAttribute(null, (String)project.getName(), (IClasspathEntry)src);
        DependencyUtil.waitForValidationJobs(project);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencyError(project);
    }

    public void testProjectEntryRule() throws Exception {
        IProject utilProject = ProjectUtil.createUtilityProject("TestUtil", "TestEAR");
        IProject webProject = ProjectUtil.createWebProject("TestWeb", "TestEAR", true);
        IJavaProject webJavaProject = JavaCore.create((IProject)webProject);
        IVirtualComponent webComp = ComponentCore.createComponent((IProject)webProject);
        IClasspathEntry entry = JavaCore.newProjectEntry((IPath)utilProject.getFullPath());
        ClasspathDependencyTestUtil.addEntryToCP(webJavaProject, entry);
        DependencyUtil.waitForValidationJobs(webProject);
        ClasspathDependencyTestUtil.verifyNoValidationError(webProject);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(webJavaProject);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(webJavaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(webComp);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)webProject.getName(), (IClasspathEntry)entry);
        DependencyUtil.waitForValidationJobs(webProject);
        ClasspathDependencyTestUtil.verifyClasspathDependencyError(webProject);
        UpdateClasspathAttributeUtil.removeDependencyAttribute(null, (String)webProject.getName(), (IClasspathEntry)entry);
        DependencyUtil.waitForValidationJobs(webProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencyError(webProject);
    }

    public void testClassFolderRule() throws Exception {
        IProject project = ProjectUtil.createUtilityProject("TestUtil", "TestEAR", true);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        ClasspathDependencyTestUtil.addLibraryEntry(javaProject, ClasspathDependencyTestUtil.TEST3_BIN_PATH, true);
        DependencyUtil.waitForValidationJobs(project);
        ClasspathDependencyTestUtil.verifyNoValidationError(project);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        IClasspathEntry lib = null;
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 1) {
                lib = entries[i];
                break;
            }
            ++i;
        }
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)project.getName(), lib);
        Set<IPath> entryPaths = Collections.singleton(ClasspathDependencyTestUtil.TEST3_BIN_PATH);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(javaProject);
        ClasspathDependencyTestUtil.verifyClasspathAttributes(javaProject, entryPaths);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
        DependencyUtil.waitForValidationJobs(project);
        ClasspathDependencyTestUtil.verifyClasspathDependencyError(project);
        UpdateClasspathAttributeUtil.removeDependencyAttribute(null, (String)project.getName(), (IClasspathEntry)lib);
        DependencyUtil.waitForValidationJobs(project);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencyError(project);
    }

    public void testNonWebNonExportedRule() throws Exception {
        IProject project = ProjectUtil.createUtilityProject("TestUtil", "TestEAR", true);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        ClasspathDependencyTestUtil.addLibraryEntry(javaProject, ClasspathDependencyTestUtil.TEST3_JAR_PATH, false);
        DependencyUtil.waitForValidationJobs(project);
        ClasspathDependencyTestUtil.verifyNoValidationError(project);
        Set<IPath> entryPaths = Collections.singleton(ClasspathDependencyTestUtil.TEST3_JAR_PATH);
        List entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(javaProject, entryPaths);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
        IClasspathEntry entry = (IClasspathEntry)entries.get(0);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)project.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(javaProject);
        ClasspathDependencyTestUtil.verifyClasspathAttributes(javaProject, entryPaths);
        Set<String> archiveNames = Collections.singleton("Test3.jar");
        ClasspathDependencyTestUtil.verifyClasspathDependencies(comp, archiveNames);
        DependencyUtil.waitForValidationJobs(project);
        ClasspathDependencyTestUtil.verifyClasspathDependencyMarker(project);
    }

    public void testDuplicateArchiveNamesRule() throws Exception {
        IProject webProject = ProjectUtil.createWebProject("TestWeb", "TestEAR");
        JavaCore.create((IProject)webProject);
        IProject util1 = ProjectUtil.createUtilityProject("TestUtil1", "TestEAR");
        DependencyCreationUtil.createWebLibDependency(webProject, util1);
        IJavaProject utilJava1 = JavaCore.create((IProject)util1);
        IVirtualComponent utilComp1 = ComponentCore.createComponent((IProject)util1);
        IProject util2 = ProjectUtil.createUtilityProject("TestUtil2", "TestEAR");
        DependencyCreationUtil.createWebLibDependency(webProject, util2);
        IVirtualComponent utilComp2 = ComponentCore.createComponent((IProject)util2);
        IJavaProject utilJava2 = JavaCore.create((IProject)util2);
        IProject util3 = ProjectUtil.createUtilityProject("TestUtil3", "TestEAR", true);
        DependencyCreationUtil.createWebLibDependency(webProject, util3);
        IVirtualComponent utilComp3 = ComponentCore.createComponent((IProject)util3);
        IJavaProject utilJava3 = JavaCore.create((IProject)util3);
        ClasspathDependencyTestUtil.addLibraryEntry(utilJava1, ClasspathDependencyTestUtil.TEST3_JAR_PATH, true);
        ClasspathDependencyTestUtil.addLibraryEntry(utilJava2, ClasspathDependencyTestUtil.TEST3_JAR_PATH, true);
        ClasspathDependencyTestUtil.addLibraryEntry(utilJava3, ClasspathDependencyTestUtil.TEST3_JAR_OTHER_LOCATION_PATH, true);
        Set<IPath> entryPaths = Collections.singleton(ClasspathDependencyTestUtil.TEST3_JAR_PATH);
        Set<IPath> otherEntryPaths = Collections.singleton(ClasspathDependencyTestUtil.TEST3_JAR_OTHER_LOCATION_PATH);
        Set<String> archiveNames = Collections.singleton("Test3.jar");
        List entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(utilJava1, entryPaths);
        IClasspathEntry entry = (IClasspathEntry)entries.get(0);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)util1.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyClasspathDependencies(utilComp1, archiveNames);
        entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(utilJava2, entryPaths);
        entry = (IClasspathEntry)entries.get(0);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)util2.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyClasspathDependencies(utilComp2, archiveNames);
        DependencyUtil.waitForValidationJobs(webProject);
        IProject earProject = ProjectUtil.getProject("TestEAR");
        ClasspathDependencyTestUtil.verifyNoValidationError(earProject);
        ClasspathDependencyTestUtil.verifyNoValidationError(webProject);
        entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(utilJava3, otherEntryPaths);
        entry = (IClasspathEntry)entries.get(0);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)util3.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyClasspathDependencies(utilComp3, archiveNames);
        DependencyUtil.waitForValidationJobs(webProject);
        DependencyUtil.waitForValidationJobs(earProject);
        ClasspathDependencyTestUtil.verifyValidationError(webProject);
        ClasspathDependencyTestUtil.verifyValidationError(earProject);
        UpdateClasspathAttributeUtil.removeDependencyAttribute(null, (String)util3.getName(), (IClasspathEntry)entry);
        DependencyUtil.waitForValidationJobs(webProject);
        DependencyUtil.waitForValidationJobs(earProject);
        ClasspathDependencyTestUtil.verifyNoValidationError(webProject);
        ClasspathDependencyTestUtil.verifyNoValidationError(earProject);
    }

    public void testRootMappingNonEARWARRefRule() throws Exception {
        IProject project = ProjectUtil.createUtilityProject("TestUtil", null, true);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        ClasspathDependencyTestUtil.addLibraryEntry(javaProject, ClasspathDependencyTestUtil.TEST3_JAR_PATH, true);
        DependencyUtil.waitForValidationJobs(project);
        ClasspathDependencyTestUtil.verifyNoValidationError(project);
        Set<IPath> entryPaths = Collections.singleton(ClasspathDependencyTestUtil.TEST3_JAR_PATH);
        List entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(javaProject, entryPaths);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
        IClasspathEntry entry = (IClasspathEntry)entries.get(0);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)project.getName(), (IClasspathEntry)entry);
        DependencyUtil.waitForValidationJobs(project);
        ClasspathDependencyTestUtil.verifyClasspathDependencyMarker(project);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(javaProject);
        ClasspathDependencyTestUtil.verifyClasspathAttributes(javaProject, entryPaths);
        Set<String> archiveNames = Collections.singleton("Test3.jar");
        ClasspathDependencyTestUtil.verifyClasspathDependencies(comp, archiveNames);
        UpdateClasspathAttributeUtil.removeDependencyAttribute(null, (String)project.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
    }

    public void testInvalidContainerRules() throws Exception {
        IProject project = ProjectUtil.createWebProject("TestWeb", "TestEAR", true);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        DependencyUtil.waitForValidationJobs(project);
        ClasspathDependencyTestUtil.verifyNoValidationError(project);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
        IClasspathEntry[] rawCP = javaProject.getRawClasspath();
        int i = 0;
        while (i < rawCP.length) {
            if (rawCP[i].getEntryKind() == 5) {
                IPath path = rawCP[i].getPath();
                if (path.equals((Object)J2EEComponentClasspathContainer.CONTAINER_PATH)) {
                    IClasspathEntry cfr_ignored_0 = rawCP[i];
                } else if (path.segment(0).equals("org.eclipse.jst.j2ee.internal.web.container")) {
                    IClasspathEntry cfr_ignored_1 = rawCP[i];
                } else if (path.segment(0).equals(JavaRuntime.JRE_CONTAINER)) {
                    IClasspathEntry cfr_ignored_2 = rawCP[i];
                }
            }
            ++i;
        }
    }

    private void testInvalidContainer(IJavaProject javaProject, IClasspathEntry entry) throws Exception {
        IProject project = javaProject.getProject();
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)project.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyClasspathAttributes(javaProject, Collections.singleton(entry.getPath()));
        DependencyUtil.waitForValidationJobs(project);
        ClasspathDependencyTestUtil.verifyClasspathDependencyError(project);
        UpdateClasspathAttributeUtil.removeDependencyAttribute(null, (String)project.getName(), (IClasspathEntry)entry);
        DependencyUtil.waitForValidationJobs(project);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencyError(project);
    }

    public void testNonTaggedExportedClassesRule() throws Exception {
        IProject project = ProjectUtil.createUtilityProject("TestUtil", "TestEAR", true);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        ClasspathDependencyTestUtil.addLibraryEntry(javaProject, ClasspathDependencyTestUtil.TEST3_JAR_PATH, true);
        DependencyUtil.waitForValidationJobs(project);
        ClasspathDependencyTestUtil.verifyClasspathDependencyMarker(project);
        Set<IPath> entryPaths = Collections.singleton(ClasspathDependencyTestUtil.TEST3_JAR_PATH);
        List entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(javaProject, entryPaths);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
        IClasspathEntry entry = (IClasspathEntry)entries.get(0);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)project.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(javaProject);
        ClasspathDependencyTestUtil.verifyClasspathAttributes(javaProject, entryPaths);
        DependencyUtil.waitForValidationJobs(project);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencyMarker(project);
    }
}

