/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.dependency.tests.util;

import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyVerificationUtil;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.EARFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.UtilityProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.OperationTestCase;

public class ProjectUtil {
    public static final IWorkspace ws = ResourcesPlugin.getWorkspace();
    private static ClasspathUpdateJobListener listener = new ClasspathUpdateJobListener();

    public static IProject getProject(String name) {
        return ws.getRoot().getProject(name);
    }

    public static void deleteProject(final IProject project) throws CoreException, InterruptedException {
        if (!project.exists()) {
            return;
        }
        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                project.delete(true, null);
            }
        };
        ResourcesPlugin.getWorkspace().run(workspaceRunnable, null);
        DependencyUtil.waitForProjectRefactoringJobs();
        ProjectUtil.waitForClasspathUpdate();
    }

    public static IProject renameProject(final IProject project, String newName) throws CoreException, InterruptedException {
        final IProject newProject = ProjectUtil.getProject(newName);
        Assert.assertFalse((String)("Cannot rename project " + project + ", a project already exists with name " + newName), (boolean)newProject.exists());
        Assert.assertTrue((String)("Project " + project + " does not exist, cannot rename."), (boolean)project.exists());
        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                project.move(newProject.getFullPath(), true, null);
            }
        };
        ResourcesPlugin.getWorkspace().run(workspaceRunnable, null);
        DependencyUtil.waitForProjectRefactoringJobs();
        ProjectUtil.waitForClasspathUpdate();
        return newProject;
    }

    public static IProject createEARProject(String name) throws Exception {
        return ProjectUtil.createEARProject(name, false);
    }

    public static IProject createEARProject(String name, boolean waitForBuildToComplete) throws Exception {
        IDataModel dataModel = ProjectUtil.getEARCreationDataModel(name);
        return ProjectUtil.createAndVerify(dataModel, name, "jst.ear", null, waitForBuildToComplete);
    }

    public static IProject createWebProject(String name, String earName) throws Exception {
        return ProjectUtil.createWebProject(name, earName, false);
    }

    public static IProject createWebProject(String name, String earName, boolean waitForBuildToComplete) throws Exception {
        IDataModel dataModel = ProjectUtil.getWebCreationDataModel(name, earName);
        return ProjectUtil.createAndVerify(dataModel, name, "jst.web", earName, waitForBuildToComplete);
    }

    public static IProject createUtilityProject(String name, String earName) throws Exception {
        return ProjectUtil.createUtilityProject(name, earName, false);
    }

    public static IProject createUtilityProject(String name, String earName, boolean waitForBuildToComplete) throws Exception {
        IDataModel dataModel = ProjectUtil.getUtilityCreationDataModel(name, earName);
        return ProjectUtil.createAndVerify(dataModel, name, "jst.utility", earName, waitForBuildToComplete);
    }

    public static IProject createEJBProject(String name, String earName) throws Exception {
        return ProjectUtil.createEJBProject(name, earName, false);
    }

    public static IProject createEJBProject(String name, String earName, boolean waitForBuildToComplete) throws Exception {
        IDataModel dataModel = ProjectUtil.getEJBCreationDataModel(name, earName);
        return ProjectUtil.createAndVerify(dataModel, name, "jst.ejb", earName, waitForBuildToComplete);
    }

    private static IDataModel getEARCreationDataModel(String name) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EARFacetProjectCreationDataModelProvider());
        ProjectUtil.configure(model, name, "jst.ear", null, 14);
        return model;
    }

    private static IDataModel getWebCreationDataModel(String name, String earName) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
        ProjectUtil.configure(model, name, "jst.web", earName, 24);
        return model;
    }

    private static IDataModel getUtilityCreationDataModel(String name, String earName) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new UtilityProjectCreationDataModelProvider());
        ProjectUtil.configure(model, name, "jst.utility", earName, 0);
        return model;
    }

    private static IDataModel getEJBCreationDataModel(String name, String earName) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetProjectCreationDataModelProvider());
        ProjectUtil.configure(model, name, "jst.ejb", earName, 21);
        return model;
    }

    private static void configure(IDataModel model, String name, String facet, String earName, int facetVersion) {
        model.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)name);
        if (earName != null) {
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            IDataModel facetDM = map.getFacetDataModel(facet);
            facetDM.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", true);
            facetDM.setProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
            if (facetVersion != 0) {
                String versionText = J2EEVersionUtil.getJ2EETextVersion((int)facetVersion);
                facetDM.setStringProperty("IFacetDataModelProperties.FACET_VERSION_STR", versionText);
            }
        }
    }

    private static IProject createAndVerify(IDataModel model, String projectName, String type, String earName, boolean waitForBuildToComplete) throws Exception {
        OperationTestCase.runAndVerify((IDataModel)model, (boolean)false, (boolean)true, (boolean)waitForBuildToComplete);
        ProjectUtil.waitForClasspathUpdate();
        ProjectUtil.verifyProject(earName, "jst.ear");
        return ProjectUtil.verifyProject(projectName, type);
    }

    private static IProject verifyProject(String projectName, String type) {
        if (projectName != null) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            Assert.assertTrue((String)("Failed to create project " + projectName), (boolean)project.exists());
            Assert.assertTrue((String)("Project not is of type " + type), (boolean)J2EEProjectUtilities.isProjectOfType((IProject)project, (String)type));
            return project;
        }
        return null;
    }

    public static void waitForClasspathUpdate() {
        DependencyVerificationUtil.waitForClasspathUpdate();
    }

    private static class ClasspathUpdateJobListener
    extends JobChangeAdapter {
        public boolean isDone = false;

        public ClasspathUpdateJobListener() {
            Job.getJobManager().addJobChangeListener((IJobChangeListener)this);
        }

        public void done(IJobChangeEvent event) {
            Job job = event.getJob();
            if (job.getName().equals("EAR Libraries Update Job")) {
                this.isDone = true;
            }
        }
    }
}

