/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project.facet.tests;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.tests.SimpleTestSuite;

public class ProjectFacetCreationTest
extends TestCase {
    public ProjectFacetCreationTest(String name) {
        super(name);
    }

    public ProjectFacetCreationTest() {
    }

    public static Test suite() {
        return new SimpleTestSuite(ProjectFacetCreationTest.class);
    }

    public void testWebCreation() throws Exception {
        IFacetedProject facetProj = ProjectFacetsManager.create((String)"SampleWebProject", null, (IProgressMonitor)new NullProgressMonitor());
        this.setRuntime(facetProj);
        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
        actions.add(this.setupJavaInstallAction());
        actions.add(this.setupWebInstallAction());
        facetProj.modify(actions, null);
        IVirtualComponent comp = ComponentCore.createComponent((IProject)facetProj.getProject());
        ProjectFacetCreationTest.assertTrue((boolean)J2EEProjectUtilities.isDynamicWebProject((IProject)comp.getProject()));
    }

    private IFacetedProject.Action setupWebInstallAction() {
        IProjectFacetVersion webfacetversion = ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.4");
        IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, webfacetversion, null);
        return action;
    }

    private IFacetedProject.Action setupJavaInstallAction() {
        IProjectFacetVersion webfacetversion = ProjectFacetsManager.getProjectFacet((String)"jst.java").getVersion("1.4");
        IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, webfacetversion, null);
        return action;
    }

    protected void setRuntime(IFacetedProject facetProj) throws CoreException {
        try {
            IRuntime runtime = RuntimeManager.getRuntime((String)"org.eclipse.jst.server.tomcat");
            facetProj.setRuntime(runtime, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Runtime not found: org.eclipse.jst.server.tomcat");
        }
    }
}

