/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.jca.operations;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jst.j2ee.internal.jca.operations.ConnectorComponentExportDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaEEFacetConstants;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaFileTestingUtilities;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.jca.operations.JCAProjectCreationOperationTest;

public class JCAExportOperationTest
extends ModuleExportOperationTest {
    public JCAExportOperationTest() {
        super("JCAExportOperationTests");
    }

    public JCAExportOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(JCAExportOperationTest.class);
        return suite;
    }

    public void testConnectorExport10_Defaults() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("aConnector", null, null, JavaEEFacetConstants.CONNECTOR_1);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testConnectorExport15_Defaults() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("bConnector", null, null, JavaEEFacetConstants.CONNECTOR_15);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testConnectorExport10_WithEAR() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("cConnector", "myEAR", null, JavaEEFacetConstants.CONNECTOR_1);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testConnectorExport15_WithEAR() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("dConnector", "yourEAR", null, JavaEEFacetConstants.CONNECTOR_15);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testConnectorExport10_ChangedSourceFolder() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("eConnector", null, "mySrc", JavaEEFacetConstants.CONNECTOR_1);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testConnectorExport15_ChangedSourceFolder() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("fConnector", null, "ourSrc", JavaEEFacetConstants.CONNECTOR_15);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testConnectorExport10_ChangedSourceFolder_WithEAR() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("gConnector", "coolEAR", "theirSrc", JavaEEFacetConstants.CONNECTOR_1);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testConnectorExport15_ChangedSourceFolder_WithEAR() throws Exception {
        IDataModel dm = JCAProjectCreationOperationTest.getConnectorDataModel("hConnector", "netoEAR", "weSrc", JavaEEFacetConstants.CONNECTOR_15);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    protected String getModuleExtension() {
        return ".rar";
    }

    protected IDataModel getExportDataModel(String projectName, String destination, boolean exportSource, boolean runBuild, boolean overwriteExisting) {
        return JCAExportOperationTest.getRARExportDataModel(projectName, destination, exportSource, runBuild, overwriteExisting);
    }

    public static IDataModel getRARExportDataModel(String projectName, String destination, boolean exportSource, boolean runBuild, boolean overwriteExisting) {
        IDataModel exportModel = DataModelFactory.createDataModel((IDataModelProvider)new ConnectorComponentExportDataModelProvider());
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", (Object)projectName);
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", (Object)destination);
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES", (Object)exportSource);
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", (Object)overwriteExisting);
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.RUN_BUILD", (Object)runBuild);
        return exportModel;
    }

    protected void addJavaFilesToProject(String projectName, String[] classNames, String prackageName) throws Exception {
        JavaFileTestingUtilities.addJavaFilesToConnector(projectName, classNames, prackageName);
    }

    protected void verifyJavaFilesExported(String archiveName, String[] classNames, String packageName, boolean withClassFiles, boolean withSource) throws Exception {
        JavaFileTestingUtilities.verifyJavaFilesInRAR(archiveName, classNames, packageName, withClassFiles, withSource);
    }
}

