/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.web.operations;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.operations.NewServletClassDataModelProvider;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.OperationTestCase;

public class AddServletOperationTest
extends OperationTestCase {
    public static String WEB_PROJECT_NAME = "WebProject";
    public static String SERVLET_NAME = "Servlet1";
    private IDataModel webComponentDataModel;
    private IDataModel servletDataModel;

    public AddServletOperationTest(String name) {
        super(name);
    }

    public AddServletOperationTest() {
    }

    public static Test suite() {
        return new TestSuite(AddServletOperationTest.class);
    }

    public void testAddServlet() throws Exception {
        this.createWebProject(WEB_PROJECT_NAME);
        WebArtifactEdit webEdit = null;
        IProject proj = ProjectUtilities.getProject((String)WEB_PROJECT_NAME);
        try {
            webEdit = new WebArtifactEdit(proj, false, true);
            WebApp webApp = webEdit.getWebApp();
            this.addServlet(WEB_PROJECT_NAME, SERVLET_NAME);
            if (webApp != null) {
                Servlet servlet = webApp.getServletNamed(SERVLET_NAME);
                AddServletOperationTest.assertNotNull((Object)servlet);
            }
        }
        finally {
            if (webEdit != null) {
                webEdit.dispose();
            }
        }
    }

    public void createWebProject(String projectName) throws Exception {
        this.webComponentDataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
        this.webComponentDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
        AddServletOperationTest.runAndVerify((IDataModel)this.webComponentDataModel);
    }

    public void addServlet(String projectName, String servletName) throws Exception {
        this.servletDataModel = DataModelFactory.createDataModel(NewServletClassDataModelProvider.class);
        this.servletDataModel.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)projectName);
        this.servletDataModel.setProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME", (Object)projectName);
        this.servletDataModel.setProperty("NewServletClassDataModel.DISPLAY_NAME", (Object)servletName);
        this.servletDataModel.setProperty("NewJavaClassDataModel.CLASS_NAME", (Object)servletName);
        this.servletDataModel.setBooleanProperty("IAnnotationsDataModel.useAnnotations", false);
        AddServletOperationTest.runAndVerify((IDataModel)this.servletDataModel);
    }
}

