/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.test.EjbEMFTestBase;

public class EntityTest
extends EjbEMFTestBase {
    public EntityTest(String name) {
        super(name);
    }

    private Entity getInstance() {
        return EjbFactory.eINSTANCE.createEntity();
    }

    public void test_Entity() {
        Entity tmpEntity = this.getInstance();
        EntityTest.assertNotNull((Object)tmpEntity);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void test_getPrimaryKeyName() throws Exception {
        this.init();
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        DD.getEJBJar().getAssemblyDescriptor();
        EList enterpriseBeans = DD.getEJBJar().getEnterpriseBeans();
        ContainerManagedEntity entityBean = null;
        EnterpriseBean bean = null;
        int x = 0;
        while (x < enterpriseBeans.size()) {
            bean = (EnterpriseBean)enterpriseBeans.get(x);
            if (bean.isEntity() && bean.isContainerManagedEntity()) {
                entityBean = (ContainerManagedEntity)bean;
                break;
            }
            ++x;
        }
        if (entityBean != null) {
            String name = entityBean.getPrimaryKeyName();
            String primKeyName = entityBean.getPrimaryKey().getQualifiedName();
            EntityTest.assertEquals((String)name, (String)primKeyName);
        }
    }

    public void test_setPrimaryKeyName() throws Exception {
        this.init();
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        DD.getEJBJar().getAssemblyDescriptor();
        EList enterpriseBeans = DD.getEJBJar().getEnterpriseBeans();
        ContainerManagedEntity entityBean = null;
        EnterpriseBean bean = null;
        int x = 0;
        while (x < enterpriseBeans.size()) {
            bean = (EnterpriseBean)enterpriseBeans.get(x);
            if (bean.isEntity() && bean.isContainerManagedEntity()) {
                entityBean = (ContainerManagedEntity)bean;
                break;
            }
            ++x;
        }
        if (entityBean != null) {
            entityBean.getPrimaryKeyName();
            String newName = "NewName";
            entityBean.setPrimaryKeyName(newName);
            EntityTest.assertEquals((String)newName, (String)entityBean.getPrimaryKeyName());
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new EntityTest("test_setPrimaryKeyName"));
        suite.addTest((Test)new EntityTest("test_getPrimaryKeyName"));
        return suite;
    }
}

