/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.tests;

import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.TaglibDomainMetaDataModelContextImpl;
import org.eclipse.jst.jsf.common.metadata.query.EmptyResultSet;
import org.eclipse.jst.jsf.common.metadata.query.IEntityQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.ITraitQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataException;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.HierarchicalSearchControl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SearchControl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleEntityQueryVisitorImpl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleTraitQueryVisitorImpl;
import org.eclipse.jst.jsf.common.metadata.tests.AbstractBaseMetaDataTestCase;

public class MetaDataQueryHelperTests
extends AbstractBaseMetaDataTestCase {
    protected ITaglibDomainMetaDataModelContext baseContext;
    protected ITaglibDomainMetaDataModelContext nullProjectContext;
    protected ITaglibDomainMetaDataModelContext negativeContextBadUri;
    protected ITaglibDomainMetaDataModelContext negativeContextBadDomain;

    public void setUp() throws Exception {
        super.setUp();
        this.baseContext = new TaglibDomainMetaDataModelContextImpl("TagLibraryDomain", this.project, "http://org.eclipse.jsf/test");
        this.nullProjectContext = new TaglibDomainMetaDataModelContextImpl("TagLibraryDomain", null, "http://org.eclipse.jsf/test");
        this.negativeContextBadUri = new TaglibDomainMetaDataModelContextImpl("TagLibraryDomain", this.project, "blah");
        this.negativeContextBadDomain = new TaglibDomainMetaDataModelContextImpl("TagLibDomain", this.project, "http://org.eclipse.jsf/test");
    }

    public void testGetModel() {
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)this.baseContext);
        MetaDataQueryHelperTests.assertNotNull((String)"http://org.eclipse.jsf/test model should not be null.", (Object)model);
        model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)this.nullProjectContext);
        MetaDataQueryHelperTests.assertNotNull((String)"http://org.eclipse.jsf/test model should not be null.", (Object)model);
        MetaDataQueryHelperTests.assertNotNull((Object)model.getId());
        MetaDataQueryHelperTests.assertEquals((String)"http://org.eclipse.jsf/test is not same as model.getId()", (String)"http://org.eclipse.jsf/test", (String)model.getId());
        model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)this.negativeContextBadUri);
        MetaDataQueryHelperTests.assertNull((Object)model);
        model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)this.negativeContextBadDomain);
        MetaDataQueryHelperTests.assertNotNull((Object)model);
    }

    public void testGetEntityIMetaDataModelContextString() {
        Entity entity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)this.baseContext, (String)"loaded");
        MetaDataQueryHelperTests.assertNotNull((Object)entity);
        entity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)this.baseContext, (String)"loaded/att3");
        MetaDataQueryHelperTests.assertNotNull((Object)entity);
        entity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)this.baseContext, (String)"doesnotexist");
        MetaDataQueryHelperTests.assertNull((Object)entity);
    }

    public void testGetEntitiesIMetaDataModelContextStringIEntityQueryVisitor() {
        SimpleEntityQueryVisitorImpl visitor = new SimpleEntityQueryVisitorImpl(new HierarchicalSearchControl(1, 2));
        IResultSet rs = TaglibDomainMetaDataQueryHelper.getEntities((ITaglibDomainMetaDataModelContext)this.baseContext, (String)"loaded", (IEntityQueryVisitor)visitor);
        MetaDataQueryHelperTests.assertNotNull((Object)rs);
        Entity entity = null;
        try {
            MetaDataQueryHelperTests.assertFalse((boolean)(rs instanceof EmptyResultSet));
            MetaDataQueryHelperTests.assertEquals((int)1, (int)rs.getResults().size());
            entity = (Entity)rs.getResults().get(0);
            MetaDataQueryHelperTests.assertNotNull((Object)entity);
            MetaDataQueryHelperTests.assertEquals((String)entity.getId(), (String)"loaded");
            rs.close();
        }
        catch (MetaDataException e) {
            MetaDataQueryHelperTests.fail((String)e.getMessage());
        }
        visitor = new SimpleEntityQueryVisitorImpl(new HierarchicalSearchControl(-1, 2));
        rs = TaglibDomainMetaDataQueryHelper.getEntities((ITaglibDomainMetaDataModelContext)this.baseContext, (String)"loaded", (IEntityQueryVisitor)visitor);
        MetaDataQueryHelperTests.assertNotNull((Object)rs);
        try {
            MetaDataQueryHelperTests.assertFalse((boolean)(rs instanceof EmptyResultSet));
            MetaDataQueryHelperTests.assertEquals((int)2, (int)rs.getResults().size());
            entity = (Entity)rs.getResults().get(0);
            MetaDataQueryHelperTests.assertNotNull((Object)entity);
            MetaDataQueryHelperTests.assertEquals((String)entity.getId(), (String)"loaded");
            Entity secondentity = (Entity)rs.getResults().get(1);
            MetaDataQueryHelperTests.assertNotNull((Object)secondentity);
            MetaDataQueryHelperTests.assertEquals((String)"loaded", (String)secondentity.getId());
            MetaDataQueryHelperTests.assertFalse((secondentity == entity ? 1 : 0) != 0);
            rs.close();
        }
        catch (MetaDataException e) {
            MetaDataQueryHelperTests.fail((String)e.getMessage());
        }
    }

    public void testGetTraitEntityString() {
        Entity entity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)this.baseContext, (String)"loaded/att3");
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)"A3");
        MetaDataQueryHelperTests.assertNotNull((Object)trait);
        trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)"Z3");
        MetaDataQueryHelperTests.assertNull((Object)trait);
    }

    public void testGetTraits() {
        SimpleTraitQueryVisitorImpl visitor = new SimpleTraitQueryVisitorImpl(new SearchControl(1));
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)this.baseContext);
        IResultSet rs = TaglibDomainMetaDataQueryHelper.getTraits((Entity)model, (String)"model-trait", (ITraitQueryVisitor)visitor);
        MetaDataQueryHelperTests.assertNotNull((Object)rs);
        Trait trait = null;
        try {
            MetaDataQueryHelperTests.assertFalse((boolean)(rs instanceof EmptyResultSet));
            MetaDataQueryHelperTests.assertEquals((int)1, (int)rs.getResults().size());
            trait = (Trait)rs.getResults().get(0);
            MetaDataQueryHelperTests.assertNotNull((Object)trait);
            MetaDataQueryHelperTests.assertEquals((String)"model-trait", (String)trait.getId());
            rs.close();
        }
        catch (MetaDataException e) {
            MetaDataQueryHelperTests.fail((String)e.getMessage());
        }
        visitor = new SimpleTraitQueryVisitorImpl(new SearchControl(-1));
        rs = TaglibDomainMetaDataQueryHelper.getTraits((Entity)model, (String)"model-trait", (ITraitQueryVisitor)visitor);
        MetaDataQueryHelperTests.assertNotNull((Object)rs);
        try {
            MetaDataQueryHelperTests.assertFalse((boolean)(rs instanceof EmptyResultSet));
            MetaDataQueryHelperTests.assertEquals((int)2, (int)rs.getResults().size());
            trait = (Trait)rs.getResults().get(0);
            MetaDataQueryHelperTests.assertNotNull((Object)trait);
            MetaDataQueryHelperTests.assertEquals((String)"model-trait", (String)trait.getId());
            Trait secondTrait = (Trait)rs.getResults().get(1);
            MetaDataQueryHelperTests.assertNotNull((Object)secondTrait);
            MetaDataQueryHelperTests.assertEquals((String)"model-trait", (String)secondTrait.getId());
            MetaDataQueryHelperTests.assertFalse((trait == secondTrait ? 1 : 0) != 0);
            rs.close();
        }
        catch (MetaDataException e) {
            MetaDataQueryHelperTests.fail((String)e.getMessage());
        }
    }

    public void testGetEntityEntityString() {
        Entity entity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)this.baseContext, (String)"loaded");
        entity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)entity, (String)"att3");
        MetaDataQueryHelperTests.assertNotNull((Object)entity);
        entity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)entity, (String)"zzz");
        MetaDataQueryHelperTests.assertNull((Object)entity);
    }

    public void testGetEntitiesEntityStringIEntityQueryVisitor() {
        IResultSet rs = TaglibDomainMetaDataQueryHelper.getEntities((ITaglibDomainMetaDataModelContext)this.negativeContextBadUri, (String)"foo", (IEntityQueryVisitor)new SimpleEntityQueryVisitorImpl());
        MetaDataQueryHelperTests.assertNotNull((Object)rs);
        try {
            MetaDataQueryHelperTests.assertEquals((int)0, (int)rs.getResults().size());
        }
        catch (MetaDataException e) {
            MetaDataQueryHelperTests.fail((String)e.getMessage());
        }
    }

    public void testGetTraitIMetaDataModelContextStringString() {
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)this.baseContext, (String)"loaded/att3", (String)"A3");
        MetaDataQueryHelperTests.assertNotNull((Object)trait);
        trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)this.baseContext, (String)"loaded/att3", (String)"zzz");
        MetaDataQueryHelperTests.assertNull((Object)trait);
        trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)this.baseContext, (String)"doesnotexist", (String)"A3");
        MetaDataQueryHelperTests.assertNull((Object)trait);
        trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)this.negativeContextBadDomain, (String)"doesnotexist", (String)"A3");
        MetaDataQueryHelperTests.assertNull((Object)trait);
    }

    public void testResultSets() {
        IResultSet rs = TaglibDomainMetaDataQueryHelper.getEntities((ITaglibDomainMetaDataModelContext)this.baseContext, (String)"loaded", (IEntityQueryVisitor)new SimpleEntityQueryVisitorImpl());
        MetaDataQueryHelperTests.assertNotNull((Object)rs);
        try {
            MetaDataQueryHelperTests.assertEquals((int)2, (int)rs.getResults().size());
            MetaDataQueryHelperTests.assertFalse((boolean)rs.isClosed());
            rs.close();
            MetaDataQueryHelperTests.assertTrue((boolean)rs.isClosed());
        }
        catch (MetaDataException e1) {
            MetaDataQueryHelperTests.fail((String)e1.getMessage());
        }
        try {
            rs.getResults();
            MetaDataQueryHelperTests.fail((String)"Expected MetaDataException ");
        }
        catch (MetaDataException metaDataException) {}
    }
}

