/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.tests;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.jst.server.generic.tests.ServerRuntimeUtils;
import org.eclipse.jst.server.generic.tests.TestConstants;

public class GenericServerTest
extends TestCase
implements TestConstants {
    public void testServerAndRuntimeInfoForServerDefAndRuntimeDef() throws Exception {
        GenericServerRuntime runtime = ServerRuntimeUtils.getGenericServerRuntime("bar.runtime.id");
        GenericServer server = ServerRuntimeUtils.getGenericServer("bar.server.id", runtime.getRuntime());
        GenericServerTest.assertNotNull((Object)server);
        ServerRuntime serverRuntime = server.getServerDefinition();
        ServerRuntimeUtils.verifyProperty((List)serverRuntime.getProperty(), "foo.prop.a", "a runtime property value");
        ServerRuntimeUtils.verifyProperty((List)serverRuntime.getProperty(), "foo.prop.b", "a server property value");
        ServerRuntimeUtils.verifyClasspath((List)serverRuntime.getClasspath(), "foo.runtime.classpath");
        ServerRuntimeUtils.verifyClasspath((List)serverRuntime.getClasspath(), "foo.server.classpath");
    }

    public void testServerAndRuntimeInfoForServerDefOnly() throws Exception {
        GenericServerRuntime runtime = ServerRuntimeUtils.getGenericServerRuntime("foo.serverdefonly.runtime.id");
        GenericServer server = ServerRuntimeUtils.getGenericServer("foo.serverdefonly.server.id", runtime.getRuntime());
        GenericServerTest.assertNotNull((Object)server);
        ServerRuntime serverRuntime = server.getServerDefinition();
        ServerRuntimeUtils.verifyProperty((List)serverRuntime.getProperty(), "foo.prop.a", "a runtime property value");
        ServerRuntimeUtils.verifyProperty((List)serverRuntime.getProperty(), "foo.prop.b", "a server property value");
        ServerRuntimeUtils.verifyClasspath((List)serverRuntime.getClasspath(), "foo.classpath");
    }
}

