/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.jsflibraryconfiguration;

import java.util.Collection;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.PluginProvidedJSFLibrary;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryConfigurationHelper;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryReference;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFVersion;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.internal.JSFLibraryReferenceFacadeFactory;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class JSFLibraryReferenceTestCases
extends TestCase {
    WebProjectTestEnvironment projectTestEnvironment;
    JDTTestEnvironment jdtTestEnv;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        this.projectTestEnvironment = new WebProjectTestEnvironment("JSFLibraryReferenceTestCases");
        boolean created = this.projectTestEnvironment.createProject(true);
        JSFLibraryReferenceTestCases.assertNotNull((Object)this.projectTestEnvironment);
        JSFLibraryReferenceTestCases.assertNotNull((Object)this.projectTestEnvironment.getTestProject());
        JSFLibraryReferenceTestCases.assertTrue((boolean)this.projectTestEnvironment.getTestProject().isAccessible());
        if (created) {
            JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this.projectTestEnvironment);
            jsfFacedEnv.initialize("1.1");
            this.createRegistryAndAddReferences(this.projectTestEnvironment, jsfFacedEnv);
        }
    }

    private void createRegistryAndAddReferences(WebProjectTestEnvironment projectTestEnvironment, JSFFacetedTestEnvironment jsfFacedEnv) throws CoreException {
        JSFLibraryRegistry jsfLibRegistry = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry();
        String[] archivefiles1 = new String[]{"faces-all-bogu.jar", "faces-api-bogus.jar", "faces-impl-bogus.jar", "tomahawk-bogus.jar"};
        String[] archivefiles2 = new String[]{"faces-all-bogu2.jar", "faces-api-bogus2.jar", "faces-impl-bogus2.jar"};
        JSFLibrary implJSFLib = JSFCoreUtilHelper.constructJSFLib("JSFLIBIMPL_NAME", "JSFLIBIMPL_NAME", archivefiles1, true);
        implJSFLib.setJSFVersion(org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFVersion.V1_1_LITERAL);
        JSFLibrary nonimplJSFLib = JSFCoreUtilHelper.constructJSFLib("JSFLIBNONIMPL_NAME", "JSFLIBNONIMPL_NAME", archivefiles2, false);
        nonimplJSFLib.setJSFVersion(org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFVersion.V1_2_LITERAL);
        PluginProvidedJSFLibrary ppJSFLib = (PluginProvidedJSFLibrary)JSFCoreUtilHelper.constructJSFLib("PP-JSFLIBNONIMPL_NAME", "testfiles/JSFLib", false, true);
        ppJSFLib.setPluginID("PluginProvidedLib");
        ppJSFLib.setLabel("PluginProvidedLib");
        ppJSFLib.setJSFVersion(org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFVersion.V1_1_LITERAL);
        jsfLibRegistry.addJSFLibrary(implJSFLib);
        jsfFacedEnv.addJSFLibraryReference(implJSFLib, false);
        jsfLibRegistry.addJSFLibrary(nonimplJSFLib);
        jsfFacedEnv.addJSFLibraryReference(nonimplJSFLib, false);
        jsfLibRegistry.addJSFLibrary((JSFLibrary)ppJSFLib);
        jsfFacedEnv.addJSFLibraryReference((JSFLibrary)ppJSFLib, true);
    }

    public void testGetJSFLibraryReferences() {
        Collection results = JSFLibraryConfigurationHelper.getJSFLibraryReferences((IProject)this.projectTestEnvironment.getTestProject());
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((results.size() >= 3 ? 1 : 0) != 0);
    }

    public void testIsJSFLibraryContainer() throws JavaModelException, CoreException {
        IClasspathEntry[] entries = null;
        entries = this.getJDTTestEnv().getJavaProject().getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry cpEntry = entries[i];
            boolean isJsfLib = JSFLibraryConfigurationHelper.isJSFLibraryContainer((IClasspathEntry)cpEntry);
            if (cpEntry.getEntryKind() == 5 && cpEntry.getPath().segment(0).equals("org.eclipse.jst.jsf.core.internal.jsflibrarycontainer")) {
                Assert.assertTrue((String)("Is a JSF LIB: " + cpEntry.toString()), (boolean)isJsfLib);
            } else {
                Assert.assertFalse((String)("Is NOT a JSF LIB: " + cpEntry.toString()), (boolean)isJsfLib);
            }
            ++i;
        }
    }

    public void testJSFLibraryReferenceFacadeFactoryCreate() throws CoreException {
        IClasspathEntry[] entries = null;
        try {
            entries = this.getJDTTestEnv().getJavaProject().getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry cpEntry = entries[i];
                boolean isJsfLib = JSFLibraryConfigurationHelper.isJSFLibraryContainer((IClasspathEntry)cpEntry);
                JSFLibraryReference ref = JSFLibraryReferenceFacadeFactory.create((IClasspathEntry)cpEntry);
                if (isJsfLib) {
                    String libID = this.getLibId(cpEntry);
                    Assert.assertNotNull((String)(String.valueOf(libID) + ": ref"), (Object)ref);
                    if (libID.equals("JSFLIBIMPL_NAME")) {
                        this.doAsserts(ref, "JSFLibraryReferenceUserDefinedImpl", "JSFLIBIMPL_NAME", "JSFLIBIMPL_NAME", "JSFLIBIMPL_NAME", false, true, JSFVersion.V1_1, 4);
                    } else if (libID.equals("JSFLIBNONIMPL_NAME")) {
                        this.doAsserts(ref, "JSFLibraryReferenceUserDefinedImpl", "JSFLIBNONIMPL_NAME", "JSFLIBNONIMPL_NAME", "JSFLIBNONIMPL_NAME", false, false, JSFVersion.V1_2, 3);
                    } else if (libID.equals("PluginProvidedLib$$PP-JSFLIBNONIMPL_NAME")) {
                        this.doAsserts(ref, "JSFLibraryReferencePluginProvidedImpl", "PluginProvidedLib$$PP-JSFLIBNONIMPL_NAME", "PP-JSFLIBNONIMPL_NAME", "PluginProvidedLib", true, false, JSFVersion.V1_1, 8);
                    }
                    ref.toString();
                } else {
                    Assert.assertNull((Object)ref);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private JDTTestEnvironment getJDTTestEnv() throws CoreException {
        if (this.jdtTestEnv == null) {
            this.jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this.projectTestEnvironment);
        }
        return this.jdtTestEnv;
    }

    private void doAsserts(JSFLibraryReference ref, String instanceName, String id, String name, String label, boolean isDeployed, boolean isImpl, JSFVersion version, int jarCount) {
        Assert.assertTrue((String)(String.valueOf(id) + ":instanceName"), (boolean)ref.getClass().getSimpleName().equals(instanceName));
        Assert.assertEquals((String)(String.valueOf(id) + ": id"), (String)id, (String)ref.getId());
        Assert.assertEquals((String)(String.valueOf(id) + ": name"), (String)name, (String)ref.getName());
        Assert.assertEquals((String)(String.valueOf(id) + ": label"), (String)label, (String)ref.getLabel());
        Assert.assertEquals((String)(String.valueOf(id) + ": isDeployed"), (boolean)isDeployed, (boolean)ref.isDeployed());
        Assert.assertEquals((String)(String.valueOf(id) + ": isImpl"), (boolean)isImpl, (boolean)ref.isJSFImplementation());
        Assert.assertEquals((String)(String.valueOf(id) + ": version"), (Object)version, (Object)ref.getMaxSupportedVersion());
        Assert.assertEquals((String)(String.valueOf(id) + ": jarCount"), (int)jarCount, (int)ref.getJars().size());
    }

    private String getLibId(IClasspathEntry cpEntry) {
        return cpEntry.getPath().segment(1);
    }
}

