/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.types;

import junit.framework.TestCase;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.common.internal.types.TypeComparator;

public class TypeComparatorTests
extends TestCase {
    private final CompositeType simpleString = new CompositeType("Ljava.lang.String;", 2);
    private final CompositeType simpleInteger = new CompositeType("I", 2);
    private final CompositeType simpleLong = new CompositeType("J", 2);
    private final CompositeType simpleBoolean = new CompositeType("Z", 2);
    private final CompositeType simpleDouble = new CompositeType("D", 2);
    private final CompositeType boxedInteger = new CompositeType("Ljava.lang.Integer;", 2);
    private final CompositeType boxedLong = new CompositeType("Ljava.lang.Long;", 2);
    private final CompositeType boxedBoolean = new CompositeType("Ljava.lang.Boolean;", 2);
    private final CompositeType boxedDouble = new CompositeType("Ljava.lang.Double;", 2);
    private final CompositeType comparableType = new CompositeType("Ljava.lang.Comparable;", 2);
    private final CompositeType mapType = new CompositeType("Ljava.util.Map;", 2);
    private final CompositeType objectAndComparable = new CompositeType(new String[]{"Ljava.lang.Object;", "Ljava.lang.Comparable;"}, 2);
    private final CompositeType objectAndMap = new CompositeType(new String[]{"Ljava.lang.Object;", "Ljava.util.Map;"}, 2);
    private final CompositeType objectAndCollection = new CompositeType(new String[]{"Ljava.lang.Object;", "Ljava.util.Collection;"}, 2);
    private final CompositeType readWritePrimitiveLong = new CompositeType("J", 3);
    private final CompositeType readWriteString = new CompositeType("Ljava.lang.String;", 3);
    private final CompositeType readWriteObject = new CompositeType("Ljava.lang.Object;", 3);

    public void testSimpleTypes() {
        Diagnostic result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleInteger, (CompositeType)this.simpleInteger);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleLong, (CompositeType)this.simpleLong);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleDouble, (CompositeType)this.simpleDouble);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleBoolean, (CompositeType)this.simpleBoolean);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleString, (CompositeType)this.simpleString);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testIntegerCoercions() {
        Diagnostic result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleInteger, (CompositeType)this.simpleLong);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleInteger, (CompositeType)this.simpleDouble);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleInteger, (CompositeType)this.simpleString);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleInteger, (CompositeType)this.simpleBoolean);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testLongCoercions() {
        Diagnostic result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleLong, (CompositeType)this.simpleInteger);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleLong, (CompositeType)this.simpleDouble);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleLong, (CompositeType)this.simpleString);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleLong, (CompositeType)this.simpleBoolean);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testDoubleCoercions() {
        Diagnostic result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleDouble, (CompositeType)this.simpleLong);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleDouble, (CompositeType)this.simpleInteger);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleDouble, (CompositeType)this.simpleString);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleDouble, (CompositeType)this.simpleBoolean);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testStringCoercions() {
        Diagnostic result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleString, (CompositeType)this.simpleLong);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleString, (CompositeType)this.simpleDouble);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleString, (CompositeType)this.simpleInteger);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleString, (CompositeType)this.simpleBoolean);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testSimpleToBoxConversions() {
        Diagnostic result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleInteger, (CompositeType)this.boxedInteger);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleLong, (CompositeType)this.boxedLong);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleDouble, (CompositeType)this.boxedDouble);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleBoolean, (CompositeType)this.boxedBoolean);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testBoxToSimpleConversions() {
        Diagnostic result = TypeComparator.calculateTypeCompatibility((CompositeType)this.boxedInteger, (CompositeType)this.simpleInteger);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.boxedLong, (CompositeType)this.simpleLong);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.boxedDouble, (CompositeType)this.simpleDouble);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.boxedBoolean, (CompositeType)this.simpleBoolean);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testObjectLists() {
        Diagnostic result = TypeComparator.calculateTypeCompatibility((CompositeType)this.comparableType, (CompositeType)this.objectAndComparable);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.comparableType, (CompositeType)this.objectAndCollection);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.mapType, (CompositeType)this.objectAndMap);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.mapType, (CompositeType)this.objectAndCollection);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testAssignability() {
        Diagnostic result = TypeComparator.calculateTypeCompatibility((CompositeType)this.simpleLong, (CompositeType)this.readWritePrimitiveLong);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.readWritePrimitiveLong, (CompositeType)this.simpleLong);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = TypeComparator.calculateTypeCompatibility((CompositeType)this.readWriteString, (CompositeType)this.readWriteObject);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
    }
}

