/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.actions.link.AbstractLinkCreator;
import org.eclipse.jst.pagedesigner.actions.link.LinkUtil;
import org.eclipse.jst.pagedesigner.parts.TextEditPart;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class JSFOutputLinkCreator
extends AbstractLinkCreator {
    public Element makeLinkElement(EditPart part, DesignRange range) {
        if (part instanceof TextEditPart) {
            Text middleNode = LinkUtil.splitDomText((EditPart)part, (DesignRange)range);
            EditPart parent = part.getParent();
            Node parentNode = (Node)parent.getModel();
            Document doc = parentNode instanceof Document ? (Document)parentNode : parentNode.getOwnerDocument();
            IDOMModel model = ((IDOMNode)parentNode).getModel();
            String prefix = JSPUtil.getOrCreatePrefix((IDOMModel)model, (String)"http://java.sun.com/jsf/html", (String)"h");
            String fPrefix = JSPUtil.getOrCreatePrefix((IDOMModel)model, (String)"http://java.sun.com/jsf/core", (String)"f");
            Element outputLink = doc.createElement("outputLink");
            outputLink.setPrefix(prefix);
            Element verbatim = doc.createElement("verbatim");
            verbatim.setPrefix(fPrefix);
            Text value = doc.createTextNode(middleNode.getNodeValue());
            verbatim.appendChild(value);
            outputLink.appendChild(verbatim);
            parentNode.replaceChild(outputLink, middleNode);
            return outputLink;
        }
        return null;
    }

    public boolean canExecute(DesignRange range) {
        DesignPosition startPosition = range.getStartPosition();
        EditPart part = startPosition.getContainerPart();
        IDOMNode node = (IDOMNode)part.getModel();
        IDOMModel model = node.getModel();
        IFile openedFile = StructuredModelUtil.getFileFor((IStructuredModel)model);
        if (openedFile == null) {
            return false;
        }
        boolean canSupportJSF = JSPUtil.supportTaglib((String)"http://java.sun.com/jsf/html", (IFile)openedFile);
        if (!canSupportJSF) {
            return false;
        }
        return super.canExecute(range);
    }

    public String getSourcePreview(EditPart part, DesignRange range) {
        if (part instanceof TextEditPart) {
            TextEditPart textPart = (TextEditPart)part;
            int[] offsets = textPart.getSelectedRange();
            String displayData = textPart.getTextData();
            String linkExp = displayData.substring(offsets[0], offsets[1]);
            StringBuffer sb = new StringBuffer();
            sb.append("<h:outputLink>\n<f:verbatim>");
            sb.append(linkExp);
            sb.append("</f:verbatim>\n</h:outputLink>");
            return sb.toString();
        }
        return null;
    }
}

