/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPluginImageHelper;
import org.eclipse.wst.javascript.ui.internal.editor.JavaScriptUIMessages;
import org.eclipse.wst.javascript.ui.internal.editor.Logger;
import org.eclipse.wst.javascript.ui.internal.wizard.NewJSFileWizardPage;

public class NewJSWizard
extends Wizard
implements INewWizard {
    private NewJSFileWizardPage fNewFilePage;
    private IStructuredSelection fSelection;

    public void addPages() {
        this.fNewFilePage = new NewJSFileWizardPage("JSWizardNewFileCreationPage", (IStructuredSelection)new StructuredSelection(IDE.computeSelectedResources((IStructuredSelection)this.fSelection)));
        this.fNewFilePage.setTitle(JavaScriptUIMessages._UI_WIZARD_NEW_HEADING);
        this.fNewFilePage.setDescription(JavaScriptUIMessages._UI_WIZARD_NEW_DESCRIPTION);
        this.addPage((IWizardPage)this.fNewFilePage);
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
        this.fSelection = aSelection;
        this.setWindowTitle(JavaScriptUIMessages._UI_WIZARD_NEW_TITLE);
        ImageDescriptor descriptor = JSEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/wizban/newjscriptfile_wiz.png");
        this.setDefaultPageImageDescriptor(descriptor);
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        Logger.log(202, e.getMessage(), e);
                    }
                }
            });
        }
    }

    public boolean performFinish() {
        IFile file;
        boolean performedOK = false;
        String fileName = this.fNewFilePage.getFileName();
        if (fileName.lastIndexOf(46) == -1) {
            String newFileName = this.fNewFilePage.addDefaultExtension(fileName);
            this.fNewFilePage.setFileName(newFileName);
        }
        if ((file = this.fNewFilePage.createNewFile()) != null) {
            this.openEditor(file);
            performedOK = true;
        }
        return performedOK;
    }
}

