/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.IASDAddCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddXSDSchemaCommand;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;

public class W11AddSchemaCommand
extends W11TopLevelElementCommand
implements IASDAddCommand {
    private Object schema;

    public W11AddSchemaCommand(Definition definition) {
        super(Messages._UI_ACTION_ADD_SCHEMA, definition);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            this.beginRecording(this.definition.getElement());
            super.execute();
            String tns = this.definition.getTargetNamespace();
            ArrayList<String> existingNamespaces = new ArrayList<String>();
            Types types = this.definition.getETypes();
            if (types != null) {
                Iterator eeIt = types.getEExtensibilityElements().iterator();
                while (eeIt.hasNext()) {
                    XSDSchemaExtensibilityElement eeElement;
                    Object item = eeIt.next();
                    if (!(item instanceof XSDSchemaExtensibilityElement) || (eeElement = (XSDSchemaExtensibilityElement)item).getSchema() == null) continue;
                    String ns = eeElement.getSchema().getTargetNamespace();
                    existingNamespaces.add(ns);
                }
            }
            tns = NameUtil.getUniqueNameHelper(tns, existingNamespaces);
            AddXSDSchemaCommand command = new AddXSDSchemaCommand(this.definition, tns);
            command.run();
            this.formatChild(command.getWSDLElement().getElement());
            this.schema = command.getWSDLElement();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.endRecording(this.definition.getElement());
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        this.endRecording(this.definition.getElement());
    }

    public Object getNewlyAddedComponent() {
        return this.schema;
    }
}

