/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.AbstractJavaTable;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaUniqueConstraint;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.mappings.IAbstractJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.mappings.ISecondaryTable;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.utility.internal.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSecondaryTable
extends AbstractJavaTable
implements ISecondaryTable {
    protected EList<IPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns;
    protected EList<IPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns;
    private final IndexedAnnotationAdapter annotationAdapter;

    protected JavaSecondaryTable() {
        throw new UnsupportedOperationException("Use JavaSecondaryTable(Owner, Member, int) instead");
    }

    public JavaSecondaryTable(ITable.Owner owner, Member member, IndexedDeclarationAnnotationAdapter idaa) {
        super(owner, member, idaa);
        this.annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        this.getDefaultPrimaryKeyJoinColumns().add((Object)this.createPrimaryKeyJoinColumn(0));
    }

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(ISecondaryTable.class)) {
            case 11: {
                this.specifiedPKJoinColumnsChanged(notification);
                break;
            }
        }
    }

    void specifiedPKJoinColumnsChanged(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                this.specifiedPKJoinColumnAdded(notification.getPosition(), (IPrimaryKeyJoinColumn)notification.getNewValue());
                break;
            }
            case 5: {
                this.specifiedPKJoinColumnsAdded(notification.getPosition(), (List)notification.getNewValue());
                break;
            }
            case 4: {
                this.specifiedPKJoinColumnRemoved(notification.getPosition(), (IPrimaryKeyJoinColumn)notification.getOldValue());
                break;
            }
            case 6: {
                if (notification.getPosition() == -1) {
                    this.specifiedPKJoinColumnsCleared((List)notification.getOldValue());
                    break;
                }
                this.specifiedPKJoinColumnsRemoved((int[])notification.getNewValue(), (List)notification.getOldValue());
                break;
            }
            case 1: {
                if (notification.isTouch()) break;
                this.specifiedPKJoinColumnSet(notification.getPosition(), (IPrimaryKeyJoinColumn)notification.getOldValue(), (IPrimaryKeyJoinColumn)notification.getNewValue());
                break;
            }
            case 7: {
                this.specifiedPKJoinColumnMoved(notification.getOldIntValue(), notification.getPosition(), (IPrimaryKeyJoinColumn)notification.getNewValue());
                break;
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_SECONDARY_TABLE;
    }

    @Override
    public EList<IPrimaryKeyJoinColumn> getPrimaryKeyJoinColumns() {
        return this.getSpecifiedPrimaryKeyJoinColumns().isEmpty() ? this.getDefaultPrimaryKeyJoinColumns() : this.getSpecifiedPrimaryKeyJoinColumns();
    }

    @Override
    public EList<IPrimaryKeyJoinColumn> getSpecifiedPrimaryKeyJoinColumns() {
        if (this.specifiedPrimaryKeyJoinColumns == null) {
            this.specifiedPrimaryKeyJoinColumns = new EObjectContainmentEList(IPrimaryKeyJoinColumn.class, (InternalEObject)this, 11);
        }
        return this.specifiedPrimaryKeyJoinColumns;
    }

    @Override
    public EList<IPrimaryKeyJoinColumn> getDefaultPrimaryKeyJoinColumns() {
        if (this.defaultPrimaryKeyJoinColumns == null) {
            this.defaultPrimaryKeyJoinColumns = new EObjectContainmentEList(IPrimaryKeyJoinColumn.class, (InternalEObject)this, 12);
        }
        return this.defaultPrimaryKeyJoinColumns;
    }

    @Override
    public ITypeMapping typeMapping() {
        return (ITypeMapping)this.eContainer();
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 10: {
                return ((InternalEList)this.getPrimaryKeyJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return ((InternalEList)this.getSpecifiedPrimaryKeyJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getDefaultPrimaryKeyJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getPrimaryKeyJoinColumns();
            }
            case 11: {
                return this.getSpecifiedPrimaryKeyJoinColumns();
            }
            case 12: {
                return this.getDefaultPrimaryKeyJoinColumns();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.getSpecifiedPrimaryKeyJoinColumns().clear();
                this.getSpecifiedPrimaryKeyJoinColumns().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getDefaultPrimaryKeyJoinColumns().clear();
                this.getDefaultPrimaryKeyJoinColumns().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.getSpecifiedPrimaryKeyJoinColumns().clear();
                return;
            }
            case 12: {
                this.getDefaultPrimaryKeyJoinColumns().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return !this.getPrimaryKeyJoinColumns().isEmpty();
            }
            case 11: {
                return this.specifiedPrimaryKeyJoinColumns != null && !this.specifiedPrimaryKeyJoinColumns.isEmpty();
            }
            case 12: {
                return this.defaultPrimaryKeyJoinColumns != null && !this.defaultPrimaryKeyJoinColumns.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == ISecondaryTable.class) {
            switch (derivedFeatureID) {
                case 10: {
                    return 10;
                }
                case 11: {
                    return 11;
                }
                case 12: {
                    return 12;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == ISecondaryTable.class) {
            switch (baseFeatureID) {
                case 10: {
                    return 10;
                }
                case 11: {
                    return 11;
                }
                case 12: {
                    return 12;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    protected void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.updateSpecifiedPrimaryKeyJoinColumnsFromJava(astRoot);
    }

    /*
     * Unable to fully structure code
     */
    private void updateSpecifiedPrimaryKeyJoinColumnsFromJava(CompilationUnit astRoot) {
        block5: {
            joinColumns = this.getSpecifiedPrimaryKeyJoinColumns();
            persSize = joinColumns.size();
            javaSize = 0;
            allJavaAnnotationsFound = false;
            i = 0;
            while (i < persSize) {
                joinColumn = (JavaPrimaryKeyJoinColumn)joinColumns.get(i);
                if (joinColumn.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    break;
                }
                joinColumn.updateFromJava(astRoot);
                ++javaSize;
                ++i;
            }
            if (!allJavaAnnotationsFound) ** GOTO lbl29
            while (persSize > javaSize) {
                joinColumns.remove(--persSize);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                joinColumn = this.createJavaPrimaryKeyJoinColumn(javaSize);
                if (joinColumn.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    continue;
                }
                this.getSpecifiedPrimaryKeyJoinColumns().add((Object)joinColumn);
                joinColumn.updateFromJava(astRoot);
                ++javaSize;
lbl29:
                // 3 sources

                ** while (!allJavaAnnotationsFound)
            }
        }
    }

    public Annotation annotation(CompilationUnit astRoot) {
        return this.annotationAdapter.getAnnotation(astRoot);
    }

    @Override
    protected void setDefaultName(String newDefaultName) {
        throw new UnsupportedOperationException("No default name for a secondary table");
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> nameAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daa, "name");
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> schemaAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daa, "schema");
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> catalogAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daa, "catalog");
    }

    @Override
    public IPrimaryKeyJoinColumn createPrimaryKeyJoinColumn(int index) {
        return this.createJavaPrimaryKeyJoinColumn(index);
    }

    private JavaPrimaryKeyJoinColumn createJavaPrimaryKeyJoinColumn(int index) {
        return JavaPrimaryKeyJoinColumn.createSecondaryTableJoinColumn(this.getDeclarationAnnotationAdapter(), this.buildPkJoinColumnOwner(), this.getMember(), index);
    }

    protected IAbstractJoinColumn.Owner buildPkJoinColumnOwner() {
        return new ISecondaryTable.PrimaryKeyJoinColumnOwner(this);
    }

    @Override
    public boolean containsSpecifiedPrimaryKeyJoinColumns() {
        return !this.getSpecifiedPrimaryKeyJoinColumns().isEmpty();
    }

    @Override
    protected JavaUniqueConstraint createJavaUniqueConstraint(int index) {
        return JavaUniqueConstraint.createSecondaryTableUniqueConstraint(new ITable.UniqueConstraintOwner(this), this.getDeclarationAnnotationAdapter(), this.getMember(), index);
    }

    void moveAnnotation(int newIndex) {
        this.annotationAdapter.moveAnnotation(newIndex);
    }

    void newAnnotation() {
        this.annotationAdapter.newMarkerAnnotation();
    }

    void removeAnnotation() {
        this.annotationAdapter.removeAnnotation();
    }

    public void specifiedPKJoinColumnAdded(int index, IPrimaryKeyJoinColumn joinColumn) {
        if (((JavaPrimaryKeyJoinColumn)joinColumn).annotation(this.getMember().astRoot()) == null) {
            this.synchPKJoinColumnAnnotationsAfterAdd(index + 1);
            ((JavaPrimaryKeyJoinColumn)joinColumn).newAnnotation();
        }
    }

    public void specifiedPKJoinColumnsAdded(int index, List<IPrimaryKeyJoinColumn> joinColumns) {
        if (!joinColumns.isEmpty() && ((JavaPrimaryKeyJoinColumn)joinColumns.get(0)).annotation(this.getMember().astRoot()) == null) {
            this.synchPKJoinColumnAnnotationsAfterAdd(index + joinColumns.size());
            for (IPrimaryKeyJoinColumn joinColumn : joinColumns) {
                ((JavaPrimaryKeyJoinColumn)joinColumn).newAnnotation();
            }
        }
    }

    public void specifiedPKJoinColumnRemoved(int index, IPrimaryKeyJoinColumn joinColumn) {
        ((JavaPrimaryKeyJoinColumn)joinColumn).removeAnnotation();
        this.synchPKJoinColumnAnnotationsAfterRemove(index);
    }

    public void specifiedPKJoinColumnsRemoved(int[] indexes, List<IPrimaryKeyJoinColumn> joinColumns) {
        for (IPrimaryKeyJoinColumn joinColumn : joinColumns) {
            ((JavaPrimaryKeyJoinColumn)joinColumn).removeAnnotation();
        }
        this.synchPKJoinColumnAnnotationsAfterRemove(indexes[0]);
    }

    public void specifiedPKJoinColumnsCleared(List<IPrimaryKeyJoinColumn> joinColumns) {
        for (IPrimaryKeyJoinColumn joinColumn : joinColumns) {
            ((JavaPrimaryKeyJoinColumn)joinColumn).removeAnnotation();
        }
    }

    public void specifiedPKJoinColumnSet(int index, IPrimaryKeyJoinColumn oldJoinColumn, IPrimaryKeyJoinColumn newJoinColumn) {
        ((JavaPrimaryKeyJoinColumn)newJoinColumn).newAnnotation();
    }

    public void specifiedPKJoinColumnMoved(int sourceIndex, int targetIndex, IPrimaryKeyJoinColumn joinColumn) {
        EList<IPrimaryKeyJoinColumn> joinColumns = this.getSpecifiedPrimaryKeyJoinColumns();
        int begin = Math.min(sourceIndex, targetIndex);
        int end = Math.max(sourceIndex, targetIndex);
        int i = begin;
        while (i-- > end) {
            this.synch((IPrimaryKeyJoinColumn)joinColumns.get(i), i);
        }
    }

    private void synchPKJoinColumnAnnotationsAfterAdd(int index) {
        EList<IPrimaryKeyJoinColumn> joinColumns = this.getSpecifiedPrimaryKeyJoinColumns();
        int i = joinColumns.size();
        while (i-- > index) {
            this.synch((IPrimaryKeyJoinColumn)joinColumns.get(i), i);
        }
    }

    private void synchPKJoinColumnAnnotationsAfterRemove(int index) {
        EList<IPrimaryKeyJoinColumn> joinColumns = this.getSpecifiedPrimaryKeyJoinColumns();
        int i = index;
        while (i < joinColumns.size()) {
            this.synch((IPrimaryKeyJoinColumn)joinColumns.get(i), i);
            ++i;
        }
    }

    private void synch(IPrimaryKeyJoinColumn joinColumn, int index) {
        ((JavaPrimaryKeyJoinColumn)joinColumn).moveAnnotation(index);
    }

    @Override
    public Iterator<String> candidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (IPrimaryKeyJoinColumn column : this.getPrimaryKeyJoinColumns()) {
            result = ((JavaPrimaryKeyJoinColumn)column).candidateValuesFor(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    static JavaSecondaryTable createJavaSecondaryTable(ITable.Owner owner, Member member, int index) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaSecondaryTable(owner, member, JavaSecondaryTable.buildDeclarationAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildDeclarationAnnotationAdapter(int index) {
        return new CombinationIndexedDeclarationAnnotationAdapter("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables", index);
    }
}

