/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.mappings;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.mappings.IAbstractJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IOverride;
import org.eclipse.jpt.core.internal.mappings.IRelationshipMapping;
import org.eclipse.jpt.db.internal.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IAssociationOverride
extends IOverride {
    public EList<IJoinColumn> getJoinColumns();

    public EList<IJoinColumn> getSpecifiedJoinColumns();

    public EList<IJoinColumn> getDefaultJoinColumns();

    public IJoinColumn createJoinColumn(int var1);

    public boolean containsSpecifiedJoinColumns();

    public ITypeMapping typeMapping();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JoinColumnOwner
    implements IJoinColumn.Owner {
        private IAssociationOverride associationOverride;

        public JoinColumnOwner(IAssociationOverride associationOverride) {
            this.associationOverride = associationOverride;
        }

        public String defaultTableName() {
            return this.associationOverride.getOwner().getTypeMapping().getTableName();
        }

        public List<IJoinColumn> joinColumns() {
            return this.associationOverride.getJoinColumns();
        }

        @Override
        public int indexOf(IAbstractJoinColumn joinColumn) {
            return this.joinColumns().indexOf(joinColumn);
        }

        @Override
        public IEntity targetEntity() {
            return this.getRelationshipMapping().getResolvedTargetEntity();
        }

        @Override
        public String attributeName() {
            return this.associationOverride.getName();
        }

        @Override
        public IRelationshipMapping getRelationshipMapping() {
            return (IRelationshipMapping)this.associationOverride.getOwner().attributeMapping(this.associationOverride.getName());
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        @Override
        public boolean tableIsAllowed() {
            return true;
        }

        @Override
        public ITextRange validationTextRange() {
            return this.associationOverride.validationTextRange();
        }

        @Override
        public ITypeMapping getTypeMapping() {
            return this.associationOverride.getOwner().getTypeMapping();
        }

        @Override
        public Table dbTable(String tableName) {
            return this.getTypeMapping().dbTable(tableName);
        }

        @Override
        public Table dbReferencedColumnTable() {
            IEntity targetEntity = this.targetEntity();
            return targetEntity == null ? null : this.targetEntity().primaryDbTable();
        }

        @Override
        public boolean isVirtual(IAbstractJoinColumn joinColumn) {
            return this.associationOverride.getDefaultJoinColumns().contains((Object)joinColumn);
        }
    }
}

