/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.internal.deployables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.jee.internal.deployables.JEEFlexProjDeployable;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;

public class JEEDeployableFactory
extends ProjectModuleFactoryDelegate {
    protected Map moduleDelegates = new HashMap(5);
    public static final String ID = "org.eclipse.jst.jee.server";

    protected IModule[] createModules(IProject project) {
        try {
            ModuleCoreNature nature = (ModuleCoreNature)project.getNature("org.eclipse.wst.common.modulecore.ModuleCoreNature");
            if (nature != null) {
                return this.createModules(nature);
            }
        }
        catch (CoreException e) {
            Logger.getLogger().write((Throwable)e);
        }
        return null;
    }

    protected IModule[] createModules(ModuleCoreNature nature) {
        IProject project = nature.getProject();
        try {
            IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
            return this.createModuleDelegates(comp);
        }
        catch (Exception e) {
            Logger.getLogger().write((Throwable)e);
            return null;
        }
    }

    public ModuleDelegate getModuleDelegate(IModule module) {
        return (ModuleDelegate)this.moduleDelegates.get(module);
    }

    protected IModule[] createModuleDelegates(IVirtualComponent component) {
        ArrayList<IModule> projectModules;
        block5: {
            projectModules = new ArrayList<IModule>();
            try {
                if (J2EEProjectUtilities.isJEEProject((IProject)component.getProject())) {
                    IModule module = null;
                    String type = J2EEProjectUtilities.getJ2EEProjectType((IProject)component.getProject());
                    if (type != null && !type.equals("")) {
                        String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)component.getProject());
                        module = this.createModule(component.getDeployedName(), component.getDeployedName(), type, version, component.getProject());
                        JEEFlexProjDeployable moduleDelegate = new JEEFlexProjDeployable(component.getProject(), component);
                        this.moduleDelegates.put(module, moduleDelegate);
                        projectModules.add(module);
                    }
                    if ("jst.ear".equals(type)) {
                        projectModules.addAll((Collection)Arrays.asList(this.createBinaryModules(component)));
                    }
                    break block5;
                }
                return null;
            }
            catch (Exception e) {
                Logger.getLogger().write((Throwable)e);
            }
        }
        return projectModules.toArray(new IModule[projectModules.size()]);
    }

    /*
     * Unable to fully structure code
     */
    protected IModule[] createBinaryModules(IVirtualComponent component) {
        projectModules = new ArrayList<IModule>();
        earEdit = null;
        try {
            app = null;
            references = component.getReferences();
            i = 0;
            while (i < references.length) {
                moduleComponent = references[i].getReferencedComponent();
                if (moduleComponent.isBinary()) {
                    if (earEdit == null) {
                        earEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)component.getProject());
                        app = earEdit.getApplication();
                    }
                    if (app != null && ((j2eeModule = app.getFirstModule(references[i].getArchiveName())) != null || moduleComponent.getProject() != component.getProject())) {
                        moduleVersion = null;
                        moduleType = null;
                        if (j2eeModule != null) {
                            moduleEdit = null;
                            try {
                                if (j2eeModule.isEjbModule()) {
                                    try {
                                        moduleEdit = ComponentUtilities.getArtifactEditForRead((IVirtualComponent)moduleComponent, (String)"jst.ejb");
                                        ejbJar = (EJBJar)moduleEdit.getContentModelRoot();
                                        moduleType = "jst.ejb";
                                        moduleVersion = ejbJar.getVersion();
                                    }
                                    catch (NullPointerException v0) {
                                        moduleType = "jst.ejb";
                                        moduleVersion = IJ2EEFacetConstants.EJB_30.getVersionString();
                                    }
                                }
                                if (j2eeModule.isWebModule()) {
                                    try {
                                        moduleEdit = ComponentUtilities.getArtifactEditForRead((IVirtualComponent)moduleComponent, (String)"jst.web");
                                        webApp = (WebApp)moduleEdit.getContentModelRoot();
                                        moduleType = "jst.web";
                                        moduleVersion = webApp.getVersion();
                                    }
                                    catch (NullPointerException v1) {
                                        moduleType = "jst.web";
                                        moduleVersion = IJ2EEFacetConstants.DYNAMIC_WEB_24.getVersionString();
                                    }
                                }
                                if (j2eeModule.isConnectorModule()) {
                                    try {
                                        moduleEdit = ComponentUtilities.getArtifactEditForRead((IVirtualComponent)moduleComponent, (String)"jst.connector");
                                        connector = (Connector)moduleEdit.getContentModelRoot();
                                        moduleType = "jst.connector";
                                        moduleVersion = connector.getVersion();
                                    }
                                    catch (NullPointerException v2) {
                                        moduleType = "jst.connector";
                                        moduleVersion = "1.5";
                                    }
                                }
                                if (!j2eeModule.isJavaModule()) ** GOTO lbl69
                                try {
                                    moduleEdit = ComponentUtilities.getArtifactEditForRead((IVirtualComponent)moduleComponent, (String)"jst.appclient");
                                    appClient = (ApplicationClient)moduleEdit.getContentModelRoot();
                                    moduleType = "jst.appclient";
                                    moduleVersion = appClient.getVersion();
                                }
                                catch (NullPointerException v3) {
                                    moduleType = "jst.appclient";
                                    moduleVersion = IJ2EEFacetConstants.APPLICATION_CLIENT_50.getVersionString();
                                }
                            }
                            finally {
                                if (moduleEdit != null) {
                                    moduleEdit.dispose();
                                }
                            }
                        } else {
                            moduleVersion = "jst.utility";
                            moduleType = "1.0";
                        }
lbl69:
                        // 10 sources

                        if ((nestedModule = this.createModule(moduleComponent.getDeployedName(), moduleComponent.getDeployedName(), moduleType, moduleVersion, moduleComponent.getProject())) != null) {
                            moduleDelegate = new J2EEFlexProjDeployable(moduleComponent.getProject(), moduleComponent);
                            this.moduleDelegates.put(nestedModule, moduleDelegate);
                            projectModules.add(nestedModule);
                            moduleDelegate.getURI(nestedModule);
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            if (earEdit != null) {
                earEdit.dispose();
            }
        }
        return projectModules.toArray(new IModule[projectModules.size()]);
    }

    protected IPath[] getListenerPaths() {
        return new IPath[]{new Path(".project"), new Path(StructureEdit.MODULE_META_FILE_NAME), new Path(".settings/org.eclipse.wst.common.project.facet.core.xml")};
    }

    protected void clearCache() {
        this.moduleDelegates = new HashMap(5);
    }
}

