/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.extension;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.wst.server.core.internal.IInstallableServer;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.InstallableServer;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.XMLMemento;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ProgressUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.extension.ExtensionSite;
import org.eclipse.wst.server.ui.internal.wizard.ExtensionWizard;

public class ExtensionUtility {
    public static boolean launchExtensionWizard(Shell shell, String title, String message) {
        ExtensionWizard wizard2 = new ExtensionWizard(title, message);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard2);
        return dialog.open() != 1;
    }

    public static ExtensionSite[] getExtensionItems(URL url) throws CoreException {
        InputStream in = null;
        try {
            in = url.openStream();
        }
        catch (Exception exception) {
            Trace.trace((byte)3, "Could not load URL " + url);
        }
        if (in == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.ui", 0, "Could not load extensions", null));
        }
        try {
            IMemento memento = XMLMemento.loadMemento((InputStream)in);
            IMemento[] children = memento.getChildren("site");
            int size = children.length;
            ArrayList<ExtensionSite> list = new ArrayList<ExtensionSite>(size);
            int i = 0;
            while (i < size) {
                ExtensionSite item = new ExtensionSite(children[i]);
                list.add(item);
                ++i;
            }
            ExtensionSite[] items = new ExtensionSite[list.size()];
            list.toArray(items);
            return items;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.ui", 0, e.getMessage(), (Throwable)e));
        }
    }

    public static ExtensionSite[] getExtensionItems() {
        URL url = ServerUIPlugin.getInstance().getBundle().getEntry("serverAdapterSites.xml");
        try {
            return ExtensionUtility.getExtensionItems(url);
        }
        catch (CoreException coreException) {
            Trace.trace((byte)3, "Could not get extension items");
            return null;
        }
    }

    public static void addFeature(List list, List existing, IFeature newFeature, FeatureListener listener) {
        if (existing.contains(newFeature)) {
            return;
        }
        VersionedIdentifier newVi = newFeature.getVersionedIdentifier();
        IFeature remove = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IFeature feature = (IFeature)iterator.next();
            VersionedIdentifier vi = feature.getVersionedIdentifier();
            if (!vi.getIdentifier().equals(newVi.getIdentifier())) continue;
            if (newVi.getVersion().isGreaterOrEqualTo(vi.getVersion())) {
                remove = feature;
                continue;
            }
            return;
        }
        if (remove != null) {
            list.remove(remove);
            listener.featureRemoved(remove);
        }
        list.add(newFeature);
        listener.featureFound(newFeature);
        try {
            Thread.sleep(800L);
        }
        catch (Exception exception) {}
    }

    public static void addFeatures(List list, List existing, List newFeatures, FeatureListener listener) {
        Iterator iterator = newFeatures.iterator();
        while (iterator.hasNext()) {
            ExtensionUtility.addFeature(list, existing, (IFeature)iterator.next(), listener);
        }
    }

    protected static List getExistingFeatures(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.installableServerLocal, 100);
        ILocalSite site = SiteManager.getLocalSite();
        IConfiguredSite[] sites = site.getCurrentConfiguration().getConfiguredSites();
        int size = sites.length;
        ArrayList<IFeature> list = new ArrayList<IFeature>(200);
        int i = 0;
        while (i < size) {
            IFeatureReference[] refs = sites[i].getFeatureReferences();
            int size2 = refs.length;
            int j = 0;
            while (j < size2) {
                IFeature f = refs[j].getFeature(ProgressUtil.getSubMonitorFor(monitor, 5));
                if (!list.contains(f)) {
                    list.add(f);
                }
                ++j;
            }
            ++i;
        }
        monitor.done();
        return list;
    }

    public static IFeature[] getAllFeatures(String id, FeatureListener listener, IProgressMonitor monitor) throws CoreException {
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.beginTask("", 1100);
        monitor.subTask(Messages.installableServerLocal);
        List existing = ExtensionUtility.getExistingFeatures(ProgressUtil.getSubMonitorFor(monitor, 100));
        ExtensionSite[] items = ExtensionUtility.getExtensionItems();
        IInstallableServer[] servers = ServerPlugin.getInstallableServers();
        int x = 1000 / (items.length + servers.length);
        monitor.worked(50);
        ArrayList list = new ArrayList();
        int size = items.length;
        int i = 0;
        while (i < size) {
            block7: {
                if (!monitor.isCanceled()) break block7;
                return null;
            }
            try {
                monitor.subTask(NLS.bind((String)Messages.installableServerSearching, (Object)items[i].getUrl()));
                List list2 = items[i].getFeatures(id, ProgressUtil.getSubMonitorFor(monitor, x));
                ExtensionUtility.addFeatures(list, existing, list2, listener);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            ++i;
        }
        size = servers.length;
        i = 0;
        while (i < size) {
            if (monitor.isCanceled()) {
                return null;
            }
            InstallableServer is = (InstallableServer)servers[i];
            monitor.subTask(NLS.bind((String)Messages.installableServerSearching, (Object)is.getFromSite()));
            IFeature feature = is.getFeature(ProgressUtil.getSubMonitorFor(monitor, x));
            if (feature != null) {
                ExtensionUtility.addFeature(list, existing, feature, listener);
            }
            ++i;
        }
        IFeature[] ef = new IFeature[list.size()];
        list.toArray(ef);
        monitor.done();
        return ef;
    }

    public static String getLicense(IFeature feature) {
        IURLEntry license = feature.getLicense();
        if (license != null) {
            return license.getAnnotation();
        }
        return null;
    }

    public static String getDescription(IFeature feature) {
        IURLEntry license = feature.getDescription();
        if (license != null) {
            return license.getAnnotation();
        }
        return null;
    }

    public static void install(IFeature feature, IProgressMonitor monitor) throws CoreException {
        try {
            IVerificationListener verificationListener = new IVerificationListener(){

                public int prompt(IVerificationResult result) {
                    return 2;
                }
            };
            SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites()[0].install(feature, verificationListener, monitor);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
    }

    public static interface FeatureListener {
        public void featureFound(IFeature var1);

        public void featureRemoved(IFeature var1);

        public void siteFailure(ISite var1, CoreException var2);
    }
}

