/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.validation.tests.internal;

import org.eclipse.wst.xml.core.internal.validation.XMLValidationReport;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.validation.tests.internal.BaseTestCase;

public class LineNumberAdjustmentsTest
extends BaseTestCase {
    private static final String LINE_NUMBER_ADJUSTMENTS_DIR = "LineNumberAdjustments/";

    public void runTest(String testfile, String key, int numErrors, int numWarnings, int lineno, int columnno) {
        XMLValidationReport valreport = this.validator.validate(testfile, null, this.configuration);
        ValidationMessage[] valmessages = valreport.getValidationMessages();
        int nummessages = valmessages.length;
        int errorCount = 0;
        int warningCount = 0;
        int i = 0;
        while (i < nummessages) {
            ValidationMessage valmes = valmessages[i];
            String messkey = valmes.getKey();
            LineNumberAdjustmentsTest.assertTrue((String)("The message key " + key + " is not correct."), (boolean)key.equals(messkey));
            LineNumberAdjustmentsTest.assertEquals((String)"The line number is incorrect.", (int)lineno, (int)valmes.getLineNumber());
            LineNumberAdjustmentsTest.assertEquals((String)"The column number is incorrect.", (int)columnno, (int)valmes.getColumnNumber());
            if (valmes.getSeverity() == ValidationMessage.SEV_LOW) {
                ++warningCount;
            } else {
                ++errorCount;
            }
            ++i;
        }
        LineNumberAdjustmentsTest.assertEquals((String)(String.valueOf(errorCount) + " errors were reported but " + numErrors + " errors were expected."), (int)numErrors, (int)errorCount);
        LineNumberAdjustmentsTest.assertEquals((String)(String.valueOf(warningCount) + " warnings were reported but " + numWarnings + " warnings were expected."), (int)numWarnings, (int)warningCount);
    }

    public void testcvccomplextype23() {
        String testname = "cvc-complex-type.2.3";
        String testfile = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + LINE_NUMBER_ADJUSTMENTS_DIR + "cvc-complex-type.2.3/" + testname + ".xml";
        String key = "cvc-complex-type.2.3";
        int lineno = 2;
        int columnno = 187;
        int numErrors = 1;
        int numWarnings = 0;
        this.runTest(testfile, key, numErrors, numWarnings, lineno, columnno);
    }

    public void testcvccomplextype24b() {
        String testname = "cvc-complex-type.2.4.b";
        String testfile = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + LINE_NUMBER_ADJUSTMENTS_DIR + "cvc-complex-type.2.4.b/" + testname + ".xml";
        String key = "cvc-complex-type.2.4.b";
        int lineno = 2;
        int columnno = 187;
        int numErrors = 1;
        int numWarnings = 0;
        this.runTest(testfile, key, numErrors, numWarnings, lineno, columnno);
    }

    public void testMsgContentIncomplete() {
        String testname = "MSG_CONTENT_INCOMPLETE";
        String testfile = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + LINE_NUMBER_ADJUSTMENTS_DIR + "MSG_CONTENT_INCOMPLETE/" + testname + ".xml";
        String key = "MSG_CONTENT_INCOMPLETE";
        int lineno = 6;
        int columnno = 7;
        int numErrors = 1;
        int numWarnings = 0;
        this.runTest(testfile, key, numErrors, numWarnings, lineno, columnno);
    }

    public void testMsgContentInvalid() {
        String testname = "MSG_CONTENT_INVALID";
        String testfile = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + LINE_NUMBER_ADJUSTMENTS_DIR + "MSG_CONTENT_INVALID/" + testname + ".xml";
        String key = "MSG_CONTENT_INVALID";
        int lineno = 6;
        int columnno = 7;
        int numErrors = 1;
        int numWarnings = 0;
        this.runTest(testfile, key, numErrors, numWarnings, lineno, columnno);
    }
}

