/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests.util;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.tests.util.WSDLModelLocatorAdapterFactory;
import org.eclipse.wst.wsdl.tests.util.XSDSchemaLocationResolverAdapterFactory;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;

public final class DefinitionLoader {
    private DefinitionLoader() {
    }

    public static Definition load(String filename) throws IOException {
        return DefinitionLoader.load(filename, false);
    }

    public static Definition load(String filename, boolean useExtensionFactories) throws IOException {
        return DefinitionLoader.load(filename, useExtensionFactories, false);
    }

    public static Definition load(String filename, boolean useExtensionFactories, boolean trackLocation) throws IOException {
        URI uri = null;
        uri = URI.createFileURI((String)filename);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getAdapterFactories().add((Object)new WSDLModelLocatorAdapterFactory());
        resourceSet.getAdapterFactories().add((Object)new XSDSchemaLocationResolverAdapterFactory());
        WSDLResourceImpl wsdlMainResource = (WSDLResourceImpl)resourceSet.createResource(URI.createURI((String)"*.wsdl"));
        wsdlMainResource.setURI(uri);
        Hashtable<String, Boolean> map = new Hashtable<String, Boolean>();
        map.put("CONTINUE_ON_LOAD_ERROR", true);
        map.put("USE_EXTENSION_FACTORIES", useExtensionFactories);
        map.put("TRACK_LOCATION", trackLocation);
        wsdlMainResource.load(map);
        Definition definition = null;
        Iterator resources = resourceSet.getResources().iterator();
        while (resources.hasNext()) {
            Object resource = resources.next();
            if (!(resource instanceof WSDLResourceImpl)) continue;
            WSDLResourceImpl wsdlResource = (WSDLResourceImpl)resource;
            definition = wsdlResource.getDefinition();
            return definition;
        }
        return null;
    }

    public static void store(Definition definition, String filename) throws IOException {
        Resource resource = definition.eResource();
        resource.setURI(URI.createFileURI((String)filename));
        resource.save(null);
    }
}

