/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests.performance;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorTestHelper {
    public static IEditorPart openInEditor(IFile file, boolean runEventLoop) throws PartInitException {
        IEditorPart part = IDE.openEditor((IWorkbenchPage)EditorTestHelper.getActivePage(), (IFile)file);
        if (runEventLoop) {
            EditorTestHelper.runEventQueue((IWorkbenchPart)part);
        }
        return part;
    }

    public static IEditorPart openInEditor(IFile file, String editorId, boolean runEventLoop) throws PartInitException {
        IEditorPart part = IDE.openEditor((IWorkbenchPage)EditorTestHelper.getActivePage(), (IFile)file, (String)editorId);
        if (runEventLoop) {
            EditorTestHelper.runEventQueue((IWorkbenchPart)part);
        }
        return part;
    }

    public static IDocument getDocument(ITextEditor editor) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        return provider.getDocument((Object)input);
    }

    public static void revertEditor(ITextEditor editor, boolean runEventQueue) {
        editor.doRevertToSaved();
        if (runEventQueue) {
            EditorTestHelper.runEventQueue((IWorkbenchPart)editor);
        }
    }

    public static void closeAllEditors() {
        IWorkbenchPage page = EditorTestHelper.getActivePage();
        if (page != null) {
            page.closeAllEditors(false);
        }
    }

    public static void runEventQueue() {
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        if (window != null) {
            EditorTestHelper.runEventQueue(window.getShell());
        }
    }

    public static void runEventQueue(IWorkbenchPart part) {
        EditorTestHelper.runEventQueue(part.getSite().getShell());
    }

    public static void runEventQueue(Shell shell) {
        while (shell.getDisplay().readAndDispatch()) {
        }
    }

    public static void runEventQueue(long minTime) {
        long nextCheck = System.currentTimeMillis() + minTime;
        while (System.currentTimeMillis() < nextCheck) {
            EditorTestHelper.runEventQueue();
            EditorTestHelper.sleep(1);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        return window != null ? window.getActivePage() : null;
    }

    public static Display getActiveDisplay() {
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        return window != null ? window.getShell().getDisplay() : null;
    }

    public static boolean calmDown(long minTime, long maxTime, long intervalTime) {
        long startTime = System.currentTimeMillis() + minTime;
        EditorTestHelper.runEventQueue();
        while (System.currentTimeMillis() < startTime) {
            EditorTestHelper.runEventQueue(intervalTime);
        }
        long endTime = maxTime > 0L ? System.currentTimeMillis() + maxTime : Long.MAX_VALUE;
        boolean calm = EditorTestHelper.isCalm();
        while (!calm && System.currentTimeMillis() < endTime) {
            EditorTestHelper.runEventQueue(intervalTime);
            calm = EditorTestHelper.isCalm();
        }
        return calm;
    }

    public static void sleep(int intervalTime) {
        try {
            Thread.sleep(intervalTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean isCalm() {
        IJobManager jobManager = Platform.getJobManager();
        Job[] jobs = jobManager.find(null);
        int i = 0;
        while (i < jobs.length) {
            Job job = jobs[i];
            int state = job.getState();
            if (state == 4 || state == 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void bringToTop() {
        EditorTestHelper.getActiveWorkbenchWindow().getShell().forceActive();
    }
}

