/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.model;

import junit.framework.TestCase;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.core.tests.util.FileUtil;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class AbstractModelTest
extends TestCase {
    protected ICSSModel fModel = null;

    protected void setUp() throws Exception {
        super.setUp();
        Preferences prefs = CSSCorePlugin.getDefault().getPluginPreferences();
        prefs.setValue("identifierCase", 1);
        prefs.setValue("propNameCase", 1);
        prefs.setValue("propValueCase", 1);
        this.fModel = FileUtil.createModel();
    }

    protected void tearDown() throws Exception {
        if (this.fModel != null) {
            this.fModel.releaseFromEdit();
            this.fModel = null;
        }
        super.tearDown();
    }

    protected ICSSModel getModel() {
        return this.fModel;
    }

    protected ICSSStyleSheet getStyleSheet() {
        return (ICSSStyleSheet)this.fModel.getDocument();
    }

    protected void checkPrimitiveNumber(CSSValue actual, PrimitiveNumber expected) {
        AbstractModelTest.assertTrue((boolean)(actual instanceof CSSPrimitiveValue));
        AbstractModelTest.assertEquals((short)expected.type, (short)((CSSPrimitiveValue)actual).getPrimitiveType());
        AbstractModelTest.assertEquals((float)expected.value, (float)((CSSPrimitiveValue)actual).getFloatValue(expected.type), (float)0.0f);
    }

    protected void checkPrimitiveString(CSSValue actual, PrimitiveString expected) {
        AbstractModelTest.assertTrue((boolean)(actual instanceof CSSPrimitiveValue));
        AbstractModelTest.assertEquals((short)expected.type, (short)((CSSPrimitiveValue)actual).getPrimitiveType());
        AbstractModelTest.assertEquals((String)expected.value, (String)((CSSPrimitiveValue)actual).getStringValue());
    }

    protected void checkPrimitiveCounter(CSSValue actual, String identifier, String listStyle, String separator) {
        AbstractModelTest.assertTrue((boolean)(actual instanceof CSSPrimitiveValue));
        AbstractModelTest.assertEquals((short)23, (short)((CSSPrimitiveValue)actual).getPrimitiveType());
        Counter counter = ((CSSPrimitiveValue)actual).getCounterValue();
        AbstractModelTest.assertEquals((String)identifier, (String)counter.getIdentifier());
        AbstractModelTest.assertEquals((String)listStyle, (String)counter.getListStyle());
        AbstractModelTest.assertEquals((String)separator, (String)counter.getSeparator());
    }

    protected void checkPrimitiveRect(CSSValue actual, Object[] expectedArray) {
        AbstractModelTest.assertTrue((boolean)(actual instanceof CSSPrimitiveValue));
        AbstractModelTest.assertEquals((short)24, (short)((CSSPrimitiveValue)actual).getPrimitiveType());
        Rect rect = ((CSSPrimitiveValue)actual).getRectValue();
        CSSPrimitiveValue value = rect.getTop();
        Object expected = expectedArray[0];
        if (expected instanceof PrimitiveNumber) {
            this.checkPrimitiveNumber(value, (PrimitiveNumber)expected);
        } else {
            this.checkPrimitiveString(value, (PrimitiveString)expected);
        }
        value = rect.getRight();
        expected = expectedArray[1];
        if (expected instanceof PrimitiveNumber) {
            this.checkPrimitiveNumber(value, (PrimitiveNumber)expected);
        } else {
            this.checkPrimitiveString(value, (PrimitiveString)expected);
        }
        value = rect.getBottom();
        expected = expectedArray[2];
        if (expected instanceof PrimitiveNumber) {
            this.checkPrimitiveNumber(value, (PrimitiveNumber)expected);
        } else {
            this.checkPrimitiveString(value, (PrimitiveString)expected);
        }
        value = rect.getLeft();
        expected = expectedArray[3];
        if (expected instanceof PrimitiveNumber) {
            this.checkPrimitiveNumber(value, (PrimitiveNumber)expected);
        } else {
            this.checkPrimitiveString(value, (PrimitiveString)expected);
        }
    }

    protected void checkPrimitiveRgb(CSSValue actual, Object[] expectedArray) {
        AbstractModelTest.assertTrue((boolean)(actual instanceof CSSPrimitiveValue));
        AbstractModelTest.assertEquals((short)25, (short)((CSSPrimitiveValue)actual).getPrimitiveType());
        RGBColor color = ((CSSPrimitiveValue)actual).getRGBColorValue();
        CSSPrimitiveValue value = color.getRed();
        Object expected = expectedArray[0];
        if (expected instanceof PrimitiveNumber) {
            this.checkPrimitiveNumber(value, (PrimitiveNumber)expected);
        } else {
            this.checkPrimitiveString(value, (PrimitiveString)expected);
        }
        value = color.getGreen();
        expected = expectedArray[1];
        if (expected instanceof PrimitiveNumber) {
            this.checkPrimitiveNumber(value, (PrimitiveNumber)expected);
        } else {
            this.checkPrimitiveString(value, (PrimitiveString)expected);
        }
        value = color.getBlue();
        expected = expectedArray[2];
        if (expected instanceof PrimitiveNumber) {
            this.checkPrimitiveNumber(value, (PrimitiveNumber)expected);
        } else {
            this.checkPrimitiveString(value, (PrimitiveString)expected);
        }
    }

    class PrimitiveNumber {
        short type;
        float value;

        PrimitiveNumber(short newType, float newValue) {
            this.type = newType;
            this.value = newValue;
        }
    }

    class PrimitiveString {
        short type;
        String value;

        PrimitiveString(short newType, String newValue) {
            this.type = newType;
            this.value = newValue;
        }
    }
}

