/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.tests.internal;

import java.util.Collection;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import org.eclipse.wst.wsi.internal.WSIPreferences;
import org.eclipse.wst.wsi.internal.analyzer.WSDLAnalyzer;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLReaderImpl;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.eclipse.wst.wsi.tests.internal.CoreConformanceTest;
import org.w3c.dom.Document;

public class CoreWSDLConformanceTest
extends CoreConformanceTest {
    public static final String WSDL_BASE_DIRECTORY = "testResources/samples/wsdl";
    public static final String WSDL_EXTENSION = ".wsdl";

    public CoreWSDLConformanceTest(String name) {
        super(name);
    }

    protected void runTest(String category, String testName, String tadID) {
        this.tadID = tadID;
        CoreWSDLConformanceTest.assertNotNull((String)"Problems determining base url", (Object)this.pluginURI);
        String testDirectory = String.valueOf(this.pluginURI) + WSDL_BASE_DIRECTORY + "/" + category + "/" + testName;
        String wsdlFile = "file://" + testDirectory + "/" + testName + WSDL_EXTENSION;
        String testcaseFile = String.valueOf(testDirectory) + "/" + "testcase.xml";
        WSDLAnalyzer analyzer = this.validateConformance(wsdlFile, tadID);
        CoreWSDLConformanceTest.assertNotNull((String)"Unknown problems during validation", (Object)analyzer);
        List expectedErrors = this.getExpectedAssertionFailures(testcaseFile);
        CoreWSDLConformanceTest.assertNotNull((String)"Problems retrieving expected failures", (Object)expectedErrors);
        this.analyzeResults(analyzer.getAssertionErrors(), expectedErrors);
    }

    protected WSDLAnalyzer validateConformance(String filename, String tadID) {
        WSDLAnalyzer analyzer = null;
        try {
            WSIPreferences preferences = new WSIPreferences();
            preferences.setComplianceLevel("0");
            preferences.setTADFile(this.getTADURI(tadID));
            analyzer = new WSDLAnalyzer(filename, preferences);
            this.setConfigurations(filename, analyzer);
            analyzer.validateConformance();
        }
        catch (Exception exception) {
            return null;
        }
        return analyzer;
    }

    protected void setConfigurations(String filename, WSDLAnalyzer analyzer) {
        block10: {
            try {
                WSDLReaderImpl wsdlReader = new WSDLReaderImpl();
                wsdlReader.setFeature("javax.wsdl.verbose", false);
                wsdlReader.setFeature("javax.wsdl.importDocuments", true);
                Document document = XMLUtils.parseXMLDocument((String)filename);
                Definition definition = wsdlReader.readWSDL(filename, document);
                String namespace = definition.getTargetNamespace();
                Collection services = definition.getServices().values();
                Collection bindings = definition.getBindings().values();
                Collection portTypes = definition.getPortTypes().values();
                Collection messages = definition.getMessages().values();
                if (services == null || services.isEmpty()) break block10;
                for (Service service : services) {
                    String servicename = service.getQName().getLocalPart();
                    Collection ports = service.getPorts().values();
                    if (ports != null && !ports.isEmpty()) {
                        for (Port port : ports) {
                            analyzer.addConfigurationToTest(servicename, namespace, port.getName(), "port");
                        }
                        continue;
                    }
                    if (bindings != null && !bindings.isEmpty()) {
                        for (Binding binding : bindings) {
                            String bindingname = binding.getQName().getLocalPart();
                            analyzer.addConfigurationToTest(null, namespace, bindingname, "binding");
                        }
                        continue;
                    }
                    if (portTypes != null && !portTypes.isEmpty()) {
                        for (PortType portType : portTypes) {
                            String portTypename = portType.getQName().getLocalPart();
                            analyzer.addConfigurationToTest(null, namespace, portTypename, "portType");
                        }
                        continue;
                    }
                    if (messages == null || messages.isEmpty()) continue;
                    for (Message message : messages) {
                        String messagename = message.getQName().getLocalPart();
                        analyzer.addConfigurationToTest(null, namespace, messagename, "message");
                    }
                }
            }
            catch (Exception exception) {
                CoreWSDLConformanceTest.fail((String)"Unexpected problems setting configurations");
            }
        }
    }
}

