/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.DiscriminatorColumn;
import org.eclipse.jpt.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.core.resource.java.DiscriminatorType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaDiscriminatorColumnTests
extends ContextModelTestCase {
    private static final String DISCRIMINATOR_COLUMN_NAME = "MY_DISCRIMINATOR_COLUMN";
    private static final String COLUMN_DEFINITION = "MY_COLUMN_DEFINITION";

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithDiscriminatorColumn() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.DiscriminatorColumn"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@DiscriminatorColumn(name=\"MY_DISCRIMINATOR_COLUMN\")");
            }
        });
    }

    public JavaDiscriminatorColumnTests(String name) {
        super(name);
    }

    public void testGetSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedName());
    }

    public void testGetSpecifiedName() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((String)DISCRIMINATOR_COLUMN_NAME, (String)this.javaEntity().getDiscriminatorColumn().getSpecifiedName());
    }

    public void testGetDefaultNameSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)this.javaEntity().getDiscriminatorColumn().getDefaultName());
    }

    public void testGetDefaultName() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)this.javaEntity().getDiscriminatorColumn().getDefaultName());
        this.javaEntity().getDiscriminatorColumn().setSpecifiedName("foo");
        JavaDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)this.javaEntity().getDiscriminatorColumn().getDefaultName());
    }

    public void testGetNameSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)this.javaEntity().getDiscriminatorColumn().getName());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((String)DISCRIMINATOR_COLUMN_NAME, (String)this.javaEntity().getDiscriminatorColumn().getName());
    }

    public void testSetSpecifiedName() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaEntity().getDiscriminatorColumn().setSpecifiedName("foo");
        JavaDiscriminatorColumnTests.assertEquals((String)"foo", (String)this.javaEntity().getDiscriminatorColumn().getSpecifiedName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation discriminatorColumn = (DiscriminatorColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.DiscriminatorColumn");
        JavaDiscriminatorColumnTests.assertEquals((String)"foo", (String)discriminatorColumn.getName());
    }

    public void testSetSpecifiedNameNull() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaEntity().getDiscriminatorColumn().setSpecifiedName(null);
        JavaDiscriminatorColumnTests.assertNull((Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation discriminatorColumn = (DiscriminatorColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.DiscriminatorColumn");
        JavaDiscriminatorColumnTests.assertNull((Object)discriminatorColumn);
    }

    public void testGetDefaultDiscriminatorType() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.STRING, (Object)this.javaEntity().getDiscriminatorColumn().getDefaultDiscriminatorType());
    }

    public void testGetDiscriminatorType() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.STRING, (Object)this.javaEntity().getDiscriminatorColumn().getDiscriminatorType());
        this.javaEntity().getDiscriminatorColumn().setSpecifiedDiscriminatorType(org.eclipse.jpt.core.context.DiscriminatorType.CHAR);
        JavaDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.CHAR, (Object)this.javaEntity().getDiscriminatorColumn().getDiscriminatorType());
    }

    public void testGetSpecifiedDiscriminatorType() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation discriminatorColumn = (DiscriminatorColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.DiscriminatorColumn");
        discriminatorColumn.setDiscriminatorType(DiscriminatorType.CHAR);
        JavaDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.CHAR, (Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType());
    }

    public void testSetSpecifiedDiscriminatorType() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType());
        this.javaEntity().getDiscriminatorColumn().setSpecifiedDiscriminatorType(org.eclipse.jpt.core.context.DiscriminatorType.CHAR);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation discriminatorColumn = (DiscriminatorColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.DiscriminatorColumn");
        JavaDiscriminatorColumnTests.assertEquals((Object)DiscriminatorType.CHAR, (Object)discriminatorColumn.getDiscriminatorType());
        this.javaEntity().getDiscriminatorColumn().setSpecifiedName(null);
        this.javaEntity().getDiscriminatorColumn().setSpecifiedDiscriminatorType(null);
        JavaDiscriminatorColumnTests.assertNull((Object)typeResource.getSupportingAnnotation("javax.persistence.DiscriminatorColumn"));
    }

    public void testGetDiscriminatorTypeUpdatesFromResourceChange() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.addSupportingAnnotation("javax.persistence.DiscriminatorColumn");
        column.setDiscriminatorType(DiscriminatorType.INTEGER);
        JavaDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.INTEGER, (Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType());
        JavaDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.INTEGER, (Object)this.javaEntity().getDiscriminatorColumn().getDiscriminatorType());
        column.setDiscriminatorType(null);
        JavaDiscriminatorColumnTests.assertNull((Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType());
        JavaDiscriminatorColumnTests.assertEquals((Object)DiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE, (Object)this.javaEntity().getDiscriminatorColumn().getDiscriminatorType());
    }

    public void testGetLength() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((Object)DiscriminatorColumn.DEFAULT_LENGTH, (Object)this.javaEntity().getDiscriminatorColumn().getLength());
        this.javaEntity().getDiscriminatorColumn().setSpecifiedLength(Integer.valueOf(55));
        JavaDiscriminatorColumnTests.assertEquals((Object)55, (Object)this.javaEntity().getDiscriminatorColumn().getLength());
    }

    public void testGetDefaultLength() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((Object)DiscriminatorColumn.DEFAULT_LENGTH, (Object)this.javaEntity().getDiscriminatorColumn().getDefaultLength());
        this.javaEntity().getDiscriminatorColumn().setSpecifiedLength(Integer.valueOf(55));
        JavaDiscriminatorColumnTests.assertEquals((Object)DiscriminatorColumn.DEFAULT_LENGTH, (Object)this.javaEntity().getDiscriminatorColumn().getDefaultLength());
    }

    public void testGetSpecifiedLength() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedLength());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation discriminatorColumn = (DiscriminatorColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.DiscriminatorColumn");
        discriminatorColumn.setLength(Integer.valueOf(66));
        JavaDiscriminatorColumnTests.assertEquals((Object)66, (Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedLength());
        JavaDiscriminatorColumnTests.assertEquals((Object)66, (Object)this.javaEntity().getDiscriminatorColumn().getLength());
        discriminatorColumn.setName(null);
        discriminatorColumn.setLength(null);
        JavaDiscriminatorColumnTests.assertNull((Object)typeResource.getSupportingAnnotation("javax.persistence.DiscriminatorColumn"));
        JavaDiscriminatorColumnTests.assertNull((Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedLength());
    }

    public void testSetSpecifiedLength() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedLength());
        this.javaEntity().getDiscriminatorColumn().setSpecifiedLength(Integer.valueOf(100));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation discriminatorColumn = (DiscriminatorColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.DiscriminatorColumn");
        JavaDiscriminatorColumnTests.assertEquals((Object)100, (Object)discriminatorColumn.getLength());
        this.javaEntity().getDiscriminatorColumn().setSpecifiedName(null);
        this.javaEntity().getDiscriminatorColumn().setSpecifiedLength(null);
        JavaDiscriminatorColumnTests.assertNull((Object)typeResource.getSupportingAnnotation("javax.persistence.DiscriminatorColumn"));
    }

    public void testGetLengthUpdatesFromResourceChange() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedLength());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.addSupportingAnnotation("javax.persistence.DiscriminatorColumn");
        column.setLength(Integer.valueOf(78));
        JavaDiscriminatorColumnTests.assertEquals((Object)78, (Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedLength());
        JavaDiscriminatorColumnTests.assertEquals((Object)78, (Object)this.javaEntity().getDiscriminatorColumn().getLength());
        column.setLength(null);
        JavaDiscriminatorColumnTests.assertNull((Object)this.javaEntity().getDiscriminatorColumn().getSpecifiedLength());
        JavaDiscriminatorColumnTests.assertEquals((Object)DiscriminatorColumn.DEFAULT_LENGTH, (Object)this.javaEntity().getDiscriminatorColumn().getLength());
    }

    public void testGetColumnDefinition() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.javaEntity().getDiscriminatorColumn().getColumnDefinition());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.DiscriminatorColumn");
        column.setColumnDefinition(COLUMN_DEFINITION);
        JavaDiscriminatorColumnTests.assertEquals((String)COLUMN_DEFINITION, (String)this.javaEntity().getDiscriminatorColumn().getColumnDefinition());
        column.setColumnDefinition(null);
        JavaDiscriminatorColumnTests.assertNull((Object)this.javaEntity().getDiscriminatorColumn().getColumnDefinition());
        typeResource.removeSupportingAnnotation("javax.persistence.DiscriminatorColumn");
    }

    public void testSetColumnDefinition() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        this.javaEntity().getDiscriminatorColumn().setColumnDefinition("foo");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.DiscriminatorColumn");
        JavaDiscriminatorColumnTests.assertEquals((String)"foo", (String)column.getColumnDefinition());
        this.javaEntity().getDiscriminatorColumn().setColumnDefinition(null);
        column = (DiscriminatorColumnAnnotation)typeResource.getSupportingAnnotation("javax.persistence.DiscriminatorColumn");
        JavaDiscriminatorColumnTests.assertNull((Object)column.getColumnDefinition());
    }
}

