/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.java.JavaJoinTable;
import org.eclipse.jpt.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaJoinTableTests
extends ContextModelTestCase {
    public JavaJoinTableTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithManyToMany() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidManyToMany() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "java.util.Collection"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany").append(CR);
                sb.append("    private Collection<Project> projects;").append(CR);
            }
        });
    }

    private void createTargetEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Project {").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int proj_id;").append(CR);
                sb.append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Project.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation javaJoinTable = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertNull((Object)javaJoinTable);
        attributeResource.addSupportingAnnotation("javax.persistence.JoinTable");
        javaJoinTable = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        javaJoinTable.setName("FOO");
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getName());
        javaJoinTable.setName(null);
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertNull((Object)javaJoinTable.getName());
        javaJoinTable.setName("FOO");
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getName());
        attributeResource.removeSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable"));
    }

    public void testModifySpecifiedName() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation javaJoinTable = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertNull((Object)javaJoinTable);
        joinTable.setSpecifiedName("foo");
        javaJoinTable = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertEquals((String)"foo", (String)javaJoinTable.getName());
        joinTable.setSpecifiedName(null);
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable"));
    }

    public void testDefaultName() throws Exception {
        this.createTestEntityWithValidManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaJoinTableTests.assertNull((Object)joinTable.getDefaultName());
        this.createTargetEntity();
        this.addXmlClassRef("test.Project");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)joinTable.getDefaultName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaJoinTableTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable"));
        manyToManyMapping.setSpecifiedTargetEntity("Foo");
        JavaJoinTableTests.assertNull((Object)joinTable.getDefaultName());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)joinTable.getDefaultName());
        attributeResource.addSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)joinTable.getDefaultName());
        JavaJoinTableTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable"));
        manyToManyMapping.getResolvedTargetEntity().getTable().setSpecifiedName("FOO");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_FOO", (String)joinTable.getDefaultName());
        this.javaEntity().getTable().setSpecifiedName("BAR");
        JavaJoinTableTests.assertEquals((String)"BAR_FOO", (String)joinTable.getDefaultName());
    }

    public void testUpdateSpecifiedSchema() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation javaJoinTable = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertNull((Object)javaJoinTable);
        attributeResource.addSupportingAnnotation("javax.persistence.JoinTable");
        javaJoinTable = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        javaJoinTable.setSchema("FOO");
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getSchema());
        javaJoinTable.setSchema(null);
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertNull((Object)javaJoinTable.getSchema());
        javaJoinTable.setSchema("FOO");
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getSchema());
        attributeResource.removeSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable"));
    }

    public void testModifySpecifiedSchema() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation javaJoinTable = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertNull((Object)javaJoinTable);
        joinTable.setSpecifiedSchema("foo");
        javaJoinTable = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertEquals((String)"foo", (String)javaJoinTable.getSchema());
        joinTable.setSpecifiedSchema(null);
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable"));
    }

    public void testUpdateSpecifiedCatalog() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation javaJoinTable = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertNull((Object)javaJoinTable);
        attributeResource.addSupportingAnnotation("javax.persistence.JoinTable");
        javaJoinTable = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        javaJoinTable.setCatalog("FOO");
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getCatalog());
        javaJoinTable.setCatalog(null);
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertNull((Object)javaJoinTable.getCatalog());
        javaJoinTable.setCatalog("FOO");
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getCatalog());
        attributeResource.removeSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable"));
    }

    public void testModifySpecifiedCatalog() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation javaJoinTable = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertNull((Object)javaJoinTable);
        joinTable.setSpecifiedCatalog("foo");
        javaJoinTable = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertEquals((String)"foo", (String)javaJoinTable.getCatalog());
        joinTable.setSpecifiedCatalog(null);
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable"));
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinColumn joinColumn = joinTable.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(0).getName());
        JoinColumn joinColumn2 = joinTable.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(1).getName());
        JoinColumn joinColumn3 = joinTable.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
        ListIterator joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((Object)joinColumn2, joinColumns.next());
        JavaJoinTableTests.assertEquals((Object)joinColumn3, joinColumns.next());
        JavaJoinTableTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        joinTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableResource.joinColumnsSize());
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)2, (int)joinTableResource.joinColumnsSize());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(1).getName());
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTableResource.joinColumnsSize());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(0).getName());
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)0, (int)joinTableResource.joinColumnsSize());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        joinTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableResource.joinColumnsSize());
        joinTable.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
        joinTable.moveSpecifiedJoinColumn(0, 1);
        joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.addSupportingAnnotation("javax.persistence.JoinTable");
        joinTableResource.addJoinColumn(0);
        joinTableResource.addJoinColumn(1);
        joinTableResource.addJoinColumn(2);
        joinTableResource.joinColumnAt(0).setName("FOO");
        joinTableResource.joinColumnAt(1).setName("BAR");
        joinTableResource.joinColumnAt(2).setName("BAZ");
        ListIterator joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.moveJoinColumn(2, 0);
        joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.moveJoinColumn(0, 1);
        joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(1);
        joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(1);
        joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(0);
        JavaJoinTableTests.assertFalse((boolean)joinTable.specifiedJoinColumns().hasNext());
    }

    public void testGetDefaultJoinColumn() {
    }

    public void testSpecifiedJoinColumnsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.specifiedJoinColumnsSize());
        joinTable.addSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.specifiedJoinColumnsSize());
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.specifiedJoinColumnsSize());
    }

    public void testJoinColumnsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.joinColumnsSize());
        joinTable.addSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.joinColumnsSize());
        joinTable.addSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)2, (int)joinTable.joinColumnsSize());
        joinTable.removeSpecifiedJoinColumn(0);
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.joinColumnsSize());
        manyToManyMapping.setMappedBy("foo");
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.joinColumnsSize());
    }

    public void testAddSpecifiedInverseJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinColumn inverseJoinColumn = joinTable.addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("FOO");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JoinColumn inverseJoinColumn2 = joinTable.addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn2.setSpecifiedName("BAR");
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        JoinColumn inverseJoinColumn3 = joinTable.addSpecifiedInverseJoinColumn(1);
        inverseJoinColumn3.setSpecifiedName("BAZ");
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(2).getName());
        ListIterator inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((Object)inverseJoinColumn2, inverseJoinColumns.next());
        JavaJoinTableTests.assertEquals((Object)inverseJoinColumn3, inverseJoinColumns.next());
        JavaJoinTableTests.assertEquals((Object)inverseJoinColumn, inverseJoinColumns.next());
        inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JoinColumn)inverseJoinColumns.next()).getName());
    }

    public void testRemoveSpecifiedInverseJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        joinTable.addSpecifiedInverseJoinColumn(0).setSpecifiedName("FOO");
        joinTable.addSpecifiedInverseJoinColumn(1).setSpecifiedName("BAR");
        joinTable.addSpecifiedInverseJoinColumn(2).setSpecifiedName("BAZ");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableResource.inverseJoinColumnsSize());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)2, (int)joinTableResource.inverseJoinColumnsSize());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTableResource.inverseJoinColumnsSize());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)0, (int)joinTableResource.inverseJoinColumnsSize());
    }

    public void testMoveSpecifiedInverseJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        joinTable.addSpecifiedInverseJoinColumn(0).setSpecifiedName("FOO");
        joinTable.addSpecifiedInverseJoinColumn(1).setSpecifiedName("BAR");
        joinTable.addSpecifiedInverseJoinColumn(2).setSpecifiedName("BAZ");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableResource.inverseJoinColumnsSize());
        joinTable.moveSpecifiedInverseJoinColumn(2, 0);
        ListIterator inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(2).getName());
        joinTable.moveSpecifiedInverseJoinColumn(0, 1);
        inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(2).getName());
    }

    public void testUpdateInverseJoinColumns() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.addSupportingAnnotation("javax.persistence.JoinTable");
        joinTableResource.addInverseJoinColumn(0);
        joinTableResource.addInverseJoinColumn(1);
        joinTableResource.addInverseJoinColumn(2);
        joinTableResource.inverseJoinColumnAt(0).setName("FOO");
        joinTableResource.inverseJoinColumnAt(1).setName("BAR");
        joinTableResource.inverseJoinColumnAt(2).setName("BAZ");
        ListIterator inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.moveInverseJoinColumn(2, 0);
        inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.moveInverseJoinColumn(0, 1);
        inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.removeInverseJoinColumn(1);
        inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.removeInverseJoinColumn(1);
        inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.removeInverseJoinColumn(0);
        JavaJoinTableTests.assertFalse((boolean)joinTable.specifiedInverseJoinColumns().hasNext());
    }

    public void testGetDefaultInverseJoinColumn() {
    }

    public void testSpecifiedInverseJoinColumnsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.specifiedInverseJoinColumnsSize());
        joinTable.addSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.specifiedInverseJoinColumnsSize());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.specifiedInverseJoinColumnsSize());
    }

    public void testInverseJoinColumnsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getJoinTable();
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.inverseJoinColumnsSize());
        joinTable.addSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.inverseJoinColumnsSize());
        joinTable.addSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)2, (int)joinTable.inverseJoinColumnsSize());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.inverseJoinColumnsSize());
        manyToManyMapping.setMappedBy("foo");
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.inverseJoinColumnsSize());
    }

    public void testUniqueConstraints() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaJoinTable joinTable = ((JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping()).getJoinTable();
        ListIterator uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.addSupportingAnnotation("javax.persistence.JoinTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "bar");
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        JavaJoinTableTests.assertEquals((String)"bar", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"foo", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaJoinTable joinTable = ((JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping()).getJoinTable();
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.uniqueConstraintsSize());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.addSupportingAnnotation("javax.persistence.JoinTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        joinTableAnnotation.addUniqueConstraint(1).addColumnName(0, "bar");
        JavaJoinTableTests.assertEquals((int)2, (int)joinTable.uniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaJoinTable joinTable = ((JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping()).getJoinTable();
        joinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        joinTable.addUniqueConstraint(0).addColumnName(0, "BAR");
        joinTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        ListIterator uniqueConstraints = joinTableAnnotation.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaJoinTable joinTable = ((JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping()).getJoinTable();
        joinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        joinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        joinTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        ListIterator uniqueConstraints = joinTableAnnotation.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaJoinTable joinTable = ((JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping()).getJoinTable();
        joinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        joinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        joinTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableAnnotation.uniqueConstraintsSize());
        joinTable.removeUniqueConstraint(1);
        ListIterator uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        ListIterator uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTable.removeUniqueConstraint(1);
        uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTable.removeUniqueConstraint(0);
        uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaJoinTable joinTable = ((JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping()).getJoinTable();
        joinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        joinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        joinTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableAnnotation.uniqueConstraintsSize());
        joinTable.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        ListIterator uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        joinTable.moveUniqueConstraint(0, 1);
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaJoinTable joinTable = ((JavaManyToManyMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping()).getJoinTable();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.addSupportingAnnotation("javax.persistence.JoinTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName("FOO");
        joinTableAnnotation.addUniqueConstraint(1).addColumnName("BAR");
        joinTableAnnotation.addUniqueConstraint(2).addColumnName("BAZ");
        ListIterator uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.moveUniqueConstraint(2, 0);
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.moveUniqueConstraint(0, 1);
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(1);
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(1);
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(0);
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }
}

