/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TemporalConverter;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.resource.java.TemporalType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaVersionMappingTests
extends ContextModelTestCase {
    private ICompilationUnit createTestEntityWithVersionMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithTemporal() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "javax.persistence.Temporal", "javax.persistence.TemporalType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
                sb.append("@Temporal(TemporalType.TIMESTAMP)").append(CR);
            }
        });
    }

    public JavaVersionMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)versionMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("basic");
        JavaVersionMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaVersionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((TemporalConverter)((BasicMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaVersionMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)versionMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaVersionMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaVersionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((TemporalConverter)((BasicMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaVersionMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)versionMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("id");
        JavaVersionMappingTests.assertEquals((String)"FOO", (String)((IdMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaVersionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((TemporalConverter)((IdMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaVersionMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)versionMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaVersionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaVersionMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)versionMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("transient");
        JavaVersionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaVersionMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)versionMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embeddedId");
        JavaVersionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaVersionMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)versionMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToOne");
        JavaVersionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaVersionMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToOne"));
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)versionMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToMany");
        JavaVersionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaVersionMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToMany"));
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)versionMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToOne");
        JavaVersionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaVersionMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)versionMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToMany");
        JavaVersionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaVersionMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testGetTemporal() throws Exception {
        this.createTestEntityWithTemporal();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getSpecifiedMapping();
        JavaVersionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIMESTAMP, (Object)((TemporalConverter)versionMapping.getConverter()).getTemporalType());
    }

    public void testSetTemporal() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getSpecifiedMapping();
        JavaVersionMappingTests.assertEquals((String)"noConverter", (String)versionMapping.getConverter().getType());
        versionMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.Temporal");
        JavaVersionMappingTests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        versionMapping.setSpecifiedConverter(null);
        JavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testGetTemporalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getSpecifiedMapping();
        JavaVersionMappingTests.assertEquals((String)"noConverter", (String)versionMapping.getConverter().getType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.addSupportingAnnotation("javax.persistence.Temporal");
        temporal.setValue(TemporalType.DATE);
        JavaVersionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.DATE, (Object)((TemporalConverter)versionMapping.getConverter()).getTemporalType());
        attributeResource.removeSupportingAnnotation("javax.persistence.Temporal");
        JavaVersionMappingTests.assertEquals((String)"noConverter", (String)versionMapping.getConverter().getType());
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        JavaVersionMappingTests.assertSame((Object)versionMapping, (Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetColumn() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getSpecifiedMapping();
        JavaVersionMappingTests.assertNull((Object)versionMapping.getColumn().getSpecifiedName());
        JavaVersionMappingTests.assertEquals((String)"id", (String)versionMapping.getColumn().getName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addSupportingAnnotation("javax.persistence.Column");
        column.setName("foo");
        JavaVersionMappingTests.assertEquals((String)"foo", (String)versionMapping.getColumn().getSpecifiedName());
        JavaVersionMappingTests.assertEquals((String)"foo", (String)versionMapping.getColumn().getName());
        JavaVersionMappingTests.assertEquals((String)"id", (String)versionMapping.getColumn().getDefaultName());
    }
}

