/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.orm.OrmDiscriminatorColumn;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.DiscriminatorType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmDiscriminatorColumnTests
extends ContextModelTestCase {
    public OrmDiscriminatorColumnTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        entityResource.setDiscriminatorColumn(OrmFactory.eINSTANCE.createXmlDiscriminatorColumn());
        entityResource.getDiscriminatorColumn().setName("FOO");
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)entityResource.getDiscriminatorColumn().getName());
        entityResource.getDiscriminatorColumn().setName(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn().getName());
        entityResource.getDiscriminatorColumn().setName("FOO");
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)entityResource.getDiscriminatorColumn().getName());
        entityResource.setDiscriminatorColumn(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        ormColumn.setSpecifiedName("foo");
        OrmDiscriminatorColumnTests.assertEquals((String)"foo", (String)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertEquals((String)"foo", (String)entityResource.getDiscriminatorColumn().getName());
        ormColumn.setSpecifiedName(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testUpdateSpecifiedLength() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        entityResource.setDiscriminatorColumn(OrmFactory.eINSTANCE.createXmlDiscriminatorColumn());
        entityResource.getDiscriminatorColumn().setLength(Integer.valueOf(8));
        OrmDiscriminatorColumnTests.assertEquals((Object)8, (Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)8, (Object)entityResource.getDiscriminatorColumn().getLength());
        entityResource.getDiscriminatorColumn().setLength(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn().getLength());
        entityResource.getDiscriminatorColumn().setLength(Integer.valueOf(11));
        OrmDiscriminatorColumnTests.assertEquals((Object)11, (Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)11, (Object)entityResource.getDiscriminatorColumn().getLength());
        entityResource.setDiscriminatorColumn(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testModifySpecifiedLength() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        ormColumn.setSpecifiedLength(Integer.valueOf(7));
        OrmDiscriminatorColumnTests.assertEquals((Object)7, (Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)7, (Object)entityResource.getDiscriminatorColumn().getLength());
        ormColumn.setSpecifiedLength(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testUpdateSpecifiedColumnDefinition() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        entityResource.setDiscriminatorColumn(OrmFactory.eINSTANCE.createXmlDiscriminatorColumn());
        entityResource.getDiscriminatorColumn().setColumnDefinition("FOO");
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)entityResource.getDiscriminatorColumn().getColumnDefinition());
        entityResource.getDiscriminatorColumn().setColumnDefinition(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn().getColumnDefinition());
        entityResource.getDiscriminatorColumn().setColumnDefinition("FOO");
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)entityResource.getDiscriminatorColumn().getColumnDefinition());
        entityResource.setDiscriminatorColumn(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testModifySpecifiedColumnDefinition() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        ormColumn.setColumnDefinition("foo");
        OrmDiscriminatorColumnTests.assertEquals((String)"foo", (String)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertEquals((String)"foo", (String)entityResource.getDiscriminatorColumn().getColumnDefinition());
        ormColumn.setColumnDefinition(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testUpdateSpecifiedDiscriminatorType() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        entityResource.setDiscriminatorColumn(OrmFactory.eINSTANCE.createXmlDiscriminatorColumn());
        entityResource.getDiscriminatorColumn().setDiscriminatorType(DiscriminatorType.STRING);
        OrmDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.STRING, (Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertEquals((Object)DiscriminatorType.STRING, (Object)entityResource.getDiscriminatorColumn().getDiscriminatorType());
        entityResource.getDiscriminatorColumn().setDiscriminatorType(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn().getDiscriminatorType());
        entityResource.getDiscriminatorColumn().setDiscriminatorType(DiscriminatorType.CHAR);
        OrmDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.CHAR, (Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertEquals((Object)DiscriminatorType.CHAR, (Object)entityResource.getDiscriminatorColumn().getDiscriminatorType());
        entityResource.setDiscriminatorColumn(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testModifySpecifiedDiscriminatorType() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        ormColumn.setSpecifiedDiscriminatorType(org.eclipse.jpt.core.context.DiscriminatorType.STRING);
        OrmDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.STRING, (Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertEquals((Object)DiscriminatorType.STRING, (Object)entityResource.getDiscriminatorColumn().getDiscriminatorType());
        ormColumn.setSpecifiedDiscriminatorType(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }
}

