/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.java.JavaEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlEmbedded;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmEmbeddedMappingTests
extends ContextModelTestCase {
    private static final String ATTRIBUTE_OVERRIDE_NAME = "city";
    private static final String ATTRIBUTE_OVERRIDE_COLUMN_NAME = "E_CITY";

    public OrmEmbeddedMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    private ICompilationUnit createTestEntityEmbeddedMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Embedded", "javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @Embedded");
                sb.append(CR);
                sb.append("    @AttributeOverride(name=\"city\", column=@Column(name=\"E_CITY\"))");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Column");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Column(name=\"A_STATE\")").append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("embedded", "embeddedMapping");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        OrmEmbeddedMappingTests.assertEquals((String)"embeddedMapping", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"embeddedMapping", (String)embeddedResource.getName());
        embeddedResource.setName("newName");
        OrmEmbeddedMappingTests.assertEquals((String)"newName", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"newName", (String)embeddedResource.getName());
        embeddedResource.setName(null);
        OrmEmbeddedMappingTests.assertNull((Object)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertNull((Object)embeddedResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("embedded", "embeddedMapping");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        OrmEmbeddedMappingTests.assertEquals((String)"embeddedMapping", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"embeddedMapping", (String)embeddedResource.getName());
        ormEmbeddedMapping.setName("newName");
        OrmEmbeddedMappingTests.assertEquals((String)"newName", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"newName", (String)embeddedResource.getName());
        ormEmbeddedMapping.setName(null);
        OrmEmbeddedMappingTests.assertNull((Object)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertNull((Object)embeddedResource.getName());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("embedded", "embeddedMapping");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).setName("BAZ");
        OrmEmbeddedMappingTests.assertEquals((int)3, (int)embeddedResource.getAttributeOverrides().size());
        ormEmbeddedMapping.moveSpecifiedAttributeOverride(2, 0);
        ListIterator attributeOverrides = ormEmbeddedMapping.specifiedAttributeOverrides();
        OrmEmbeddedMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).getName());
        ormEmbeddedMapping.moveSpecifiedAttributeOverride(0, 1);
        attributeOverrides = ormEmbeddedMapping.specifiedAttributeOverrides();
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).getName());
    }

    public void testUpdateAttributeOverrides() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("embedded", "embeddedMapping");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).setName("BAZ");
        ListIterator attributeOverrides = ormEmbeddedMapping.specifiedAttributeOverrides();
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().move(2, 0);
        attributeOverrides = ormEmbeddedMapping.specifiedAttributeOverrides();
        OrmEmbeddedMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().move(0, 1);
        attributeOverrides = ormEmbeddedMapping.specifiedAttributeOverrides();
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().remove(1);
        attributeOverrides = ormEmbeddedMapping.specifiedAttributeOverrides();
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().remove(1);
        attributeOverrides = ormEmbeddedMapping.specifiedAttributeOverrides();
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().remove(0);
        OrmEmbeddedMappingTests.assertFalse((boolean)ormEmbeddedMapping.specifiedAttributeOverrides().hasNext());
    }

    public void testEmbeddedMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityEmbeddedMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        this.entityMappings().addOrmPersistentType("embeddable", "test.Address");
        ormPersistentType.addSpecifiedPersistentAttribute("embedded", "foo");
        OrmEmbeddedMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertEquals((String)"foo", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertFalse((boolean)ormEmbeddedMapping.specifiedAttributeOverrides().hasNext());
        OrmEmbeddedMappingTests.assertFalse((boolean)ormEmbeddedMapping.virtualAttributeOverrides().hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityEmbeddedMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType persistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType persistentType2 = this.entityMappings().addOrmPersistentType("embeddable", "test.Address");
        OrmEmbeddedMapping embeddedMapping = (OrmEmbeddedMapping)persistentType.getAttributeNamed("address").getMapping();
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)embeddedMapping.attributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)0, (int)embeddedMapping.virtualAttributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)embeddedMapping.specifiedAttributeOverridesSize());
        ListIterator specifiedAttributeOverrides = embeddedMapping.specifiedAttributeOverrides();
        OrmAttributeOverride attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"state", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
        JavaEmbeddedMapping javaEmbeddedMapping = (JavaEmbeddedMapping)embeddedMapping.getJavaPersistentAttribute().getMapping();
        ((JavaAttributeOverride)javaEmbeddedMapping.specifiedAttributeOverrides().next()).getColumn().setSpecifiedName("FOO_COLUMN");
        ((JavaAttributeOverride)javaEmbeddedMapping.specifiedAttributeOverrides().next()).getColumn().setSpecifiedTable("FOO_TABLE");
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)persistentType2.getJavaPersistentType().getAttributeNamed("state").getMapping();
        javaBasicMapping.getColumn().setSpecifiedName("MY_STATE_COLUMN");
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)embeddedMapping.attributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)0, (int)embeddedMapping.virtualAttributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)embeddedMapping.specifiedAttributeOverridesSize());
        specifiedAttributeOverrides = embeddedMapping.specifiedAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO_TABLE", (String)attributeOverride.getColumn().getSpecifiedTable());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"state", (String)attributeOverride.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"MY_STATE_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
        persistentType.getAttributeNamed("address").makeSpecified();
        this.ormResource().save(null);
        embeddedMapping = (OrmEmbeddedMapping)persistentType.getAttributeNamed("address").getMapping();
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)embeddedMapping.attributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)embeddedMapping.virtualAttributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)0, (int)embeddedMapping.specifiedAttributeOverridesSize());
        ListIterator virtualAttributeOverrides = embeddedMapping.virtualAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getColumn().getDefaultName());
        OrmEmbeddedMappingTests.assertEquals((String)"AnnotationTestType", (String)attributeOverride.getColumn().getDefaultTable());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"state", (String)attributeOverride.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"MY_STATE_COLUMN", (String)attributeOverride.getColumn().getDefaultName());
        OrmEmbeddedMappingTests.assertEquals((String)"AnnotationTestType", (String)attributeOverride.getColumn().getDefaultTable());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
        ((OrmAttributeOverride)embeddedMapping.virtualAttributeOverrides().next()).setVirtual(false);
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)embeddedMapping.attributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)embeddedMapping.specifiedAttributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)3, (int)embeddedMapping.virtualAttributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((String)"id", (String)((OrmAttributeOverride)embeddedMapping.specifiedAttributeOverrides().next()).getName());
        virtualAttributeOverrides = embeddedMapping.virtualAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"state", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityEmbeddedMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        this.entityMappings().addOrmPersistentType("embeddable", "test.Address");
        OrmEmbeddedMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertEquals((String)"address", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)ormEmbeddedMapping.specifiedAttributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)0, (int)ormEmbeddedMapping.virtualAttributeOverridesSize());
        ListIterator ormAttributeOverrides = ormEmbeddedMapping.specifiedAttributeOverrides();
        OrmAttributeOverride ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)ormAttributeOverride.getName());
        OrmColumn ormColumn = ormAttributeOverride.getColumn();
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_COLUMN_NAME, (String)ormColumn.getSpecifiedName());
        ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"id", (String)ormAttributeOverride.getName());
        ormColumn = ormAttributeOverride.getColumn();
        OrmEmbeddedMappingTests.assertEquals((String)"id", (String)ormColumn.getSpecifiedName());
        ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"state", (String)ormAttributeOverride.getName());
        ormColumn = ormAttributeOverride.getColumn();
        OrmEmbeddedMappingTests.assertEquals((String)"A_STATE", (String)ormColumn.getSpecifiedName());
        ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"zip", (String)ormAttributeOverride.getName());
        ormColumn = ormAttributeOverride.getColumn();
        OrmEmbeddedMappingTests.assertEquals((String)"zip", (String)ormColumn.getSpecifiedName());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityEmbeddedMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        this.entityMappings().addOrmPersistentType("embeddable", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmEmbeddedMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertEquals((String)"address", (String)ormEmbeddedMapping.getName());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        this.entityMappings().addOrmPersistentType("embeddable", "test.Address");
        ormPersistentType.addSpecifiedPersistentAttribute("embedded", "address");
        OrmEmbeddedMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertEquals((String)"address", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertEquals((int)0, (int)ormEmbeddedMapping.specifiedAttributeOverridesSize());
    }

    public void testEmbeddedMorphToIdMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("id");
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToVersionMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("version");
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToTransientMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("transient");
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToBasicMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("basic");
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embeddedId");
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
        attributeOverride = (AttributeOverride)((EmbeddedIdMapping)ormPersistentAttribute.getMapping()).specifiedAttributeOverrides().next();
        OrmEmbeddedMappingTests.assertEquals((String)"override", (String)attributeOverride.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"OVERRIDE_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
    }

    public void testEmbeddedMorphToOneToOneMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToOne");
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToOneToManyMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToMany");
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToManyToOneMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToOne");
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToManyToManyMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToMany");
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }
}

