/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJoinTable;
import org.eclipse.jpt.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.core.resource.orm.XmlManyToMany;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraintImpl;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmJoinTableTests
extends ContextModelTestCase {
    public OrmJoinTableTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    private ICompilationUnit createTestEntityWithValidManyToMany() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany").append(CR);
                sb.append("    private Collection<Project> projects;").append(CR);
                sb.append("@Id").append(CR);
            }
        });
    }

    private void createTargetEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Project {").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int proj_id;").append(CR);
                sb.append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Project.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        manyToMany.setJoinTable((XmlJoinTable)OrmFactory.eINSTANCE.createXmlJoinTableImpl());
        manyToMany.getJoinTable().setName("FOO");
        OrmJoinTableTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)manyToMany.getJoinTable().getName());
        manyToMany.getJoinTable().setName(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable().getName());
        manyToMany.getJoinTable().setName("FOO");
        OrmJoinTableTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)manyToMany.getJoinTable().getName());
        manyToMany.setJoinTable(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        ormJoinTable.setSpecifiedName("foo");
        OrmJoinTableTests.assertEquals((String)"foo", (String)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertEquals((String)"foo", (String)manyToMany.getJoinTable().getName());
        ormJoinTable.setSpecifiedName(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
    }

    public void testVirtualJoinTable() throws Exception {
        this.createTestEntityWithValidManyToMany();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("projects");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinTableTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        OrmJoinTableTests.assertEquals(null, (String)ormJoinTable.getSpecifiedName());
        this.createTargetEntity();
        this.entityMappings().addOrmPersistentType("entity", "test.Project");
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertEquals((int)0, (int)ormJoinTable.specifiedJoinColumnsSize());
        OrmJoinTableTests.assertEquals((int)0, (int)ormJoinTable.specifiedInverseJoinColumnsSize());
        OrmJoinColumn ormJoinColumn = ormJoinTable.getDefaultJoinColumn();
        OrmJoinColumn inverseOrmJoinColumn = ormJoinTable.getDefaultInverseJoinColumn();
        JavaPersistentAttribute javaPersistentAttribute = ormManyToManyMapping.getJavaPersistentAttribute();
        JavaManyToManyMapping javaManyToManyMapping = (JavaManyToManyMapping)javaPersistentAttribute.getMapping();
        JavaJoinTable javaJoinTable = javaManyToManyMapping.getJoinTable();
        javaJoinTable.setSpecifiedName("FOO");
        javaJoinTable.setSpecifiedCatalog("CATALOG");
        javaJoinTable.setSpecifiedSchema("SCHEMA");
        JavaJoinColumn javaJoinColumn = javaJoinTable.addSpecifiedJoinColumn(0);
        javaJoinColumn.setSpecifiedName("NAME");
        javaJoinColumn.setSpecifiedReferencedColumnName("REFERENCED_NAME");
        JavaJoinColumn inverseJavaJoinColumn = javaJoinTable.addSpecifiedInverseJoinColumn(0);
        inverseJavaJoinColumn.setSpecifiedName("INVERSE_NAME");
        inverseJavaJoinColumn.setSpecifiedReferencedColumnName("INVERSE_REFERENCED_NAME");
        OrmJoinTableTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertEquals((String)"CATALOG", (String)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertEquals((String)"SCHEMA", (String)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertEquals((int)1, (int)ormJoinTable.specifiedJoinColumnsSize());
        OrmJoinTableTests.assertEquals((int)1, (int)ormJoinTable.specifiedInverseJoinColumnsSize());
        ormJoinColumn = (OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next();
        OrmJoinTableTests.assertEquals((String)"NAME", (String)ormJoinColumn.getSpecifiedName());
        OrmJoinTableTests.assertEquals((String)"REFERENCED_NAME", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        inverseOrmJoinColumn = (OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next();
        OrmJoinTableTests.assertEquals((String)"INVERSE_NAME", (String)inverseOrmJoinColumn.getSpecifiedName());
        OrmJoinTableTests.assertEquals((String)"INVERSE_REFERENCED_NAME", (String)inverseOrmJoinColumn.getSpecifiedReferencedColumnName());
    }

    public void testUpdateDefaultNameFromJavaTable() throws Exception {
        this.createTestEntityWithValidManyToMany();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "projects");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinTableTests.assertEquals(null, (String)ormJoinTable.getDefaultName());
        this.createTargetEntity();
        OrmPersistentType targetPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.Project");
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)targetPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("FOO");
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_FOO", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)ormPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("BAR");
        OrmJoinTableTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        ormPersistentType.getJavaPersistentType().getAttributeNamed("projects").setSpecifiedMappingKey("manyToMany");
        JavaManyToManyMapping javaManyMapping = (JavaManyToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("projects").getMapping();
        javaManyMapping.getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        OrmJoinTableTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        this.entityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)ormJoinTable.getDefaultName());
        this.entityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        ormPersistentAttribute.makeVirtual();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("projects");
        ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinTableTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        OrmJoinTableTests.assertEquals((String)"JAVA_JOIN_TABLE", (String)ormManyToManyMapping.getJoinTable().getSpecifiedName());
        javaManyMapping.getJoinTable().setSpecifiedName(null);
        OrmJoinTableTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE_NAME");
        OrmJoinTableTests.assertEquals((String)"ORM_TABLE_NAME_FOO", (String)ormJoinTable.getDefaultName());
        ((OrmEntity)targetPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TARGET");
        OrmJoinTableTests.assertEquals((String)"ORM_TABLE_NAME_ORM_TARGET", (String)ormJoinTable.getDefaultName());
    }

    public void testUpdateSpecifiedSchema() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        manyToMany.setJoinTable((XmlJoinTable)OrmFactory.eINSTANCE.createXmlJoinTableImpl());
        manyToMany.getJoinTable().setSchema("FOO");
        OrmJoinTableTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)manyToMany.getJoinTable().getSchema());
        manyToMany.getJoinTable().setSchema(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable().getSchema());
        manyToMany.getJoinTable().setSchema("FOO");
        OrmJoinTableTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)manyToMany.getJoinTable().getSchema());
        manyToMany.setJoinTable(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
    }

    public void testModifySpecifiedSchema() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        ormJoinTable.setSpecifiedSchema("foo");
        OrmJoinTableTests.assertEquals((String)"foo", (String)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertEquals((String)"foo", (String)manyToMany.getJoinTable().getSchema());
        ormJoinTable.setSpecifiedSchema(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
    }

    public void testUpdateSpecifiedCatalog() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        manyToMany.setJoinTable((XmlJoinTable)OrmFactory.eINSTANCE.createXmlJoinTableImpl());
        manyToMany.getJoinTable().setCatalog("FOO");
        OrmJoinTableTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)manyToMany.getJoinTable().getCatalog());
        manyToMany.getJoinTable().setCatalog(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable().getCatalog());
        manyToMany.getJoinTable().setCatalog("FOO");
        OrmJoinTableTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)manyToMany.getJoinTable().getCatalog());
        manyToMany.setJoinTable(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
    }

    public void testModifySpecifiedCatalog() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        ormJoinTable.setSpecifiedCatalog("foo");
        OrmJoinTableTests.assertEquals((String)"foo", (String)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertEquals((String)"foo", (String)manyToMany.getJoinTable().getCatalog());
        ormJoinTable.setSpecifiedCatalog(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn joinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
        OrmJoinColumn joinColumn2 = ormJoinTable.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(1)).getName());
        OrmJoinColumn joinColumn3 = ormJoinTable.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(1)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(2)).getName());
        ListIterator joinColumns = ormJoinTable.specifiedJoinColumns();
        OrmJoinTableTests.assertEquals((Object)joinColumn2, joinColumns.next());
        OrmJoinTableTests.assertEquals((Object)joinColumn3, joinColumns.next());
        OrmJoinTableTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = ormJoinTable.specifiedJoinColumns();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        ormJoinTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        ormJoinTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        ormJoinTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        OrmJoinTableTests.assertEquals((int)3, (int)joinTableResource.getJoinColumns().size());
        ormJoinTable.removeSpecifiedJoinColumn(0);
        OrmJoinTableTests.assertEquals((int)2, (int)joinTableResource.getJoinColumns().size());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(1)).getName());
        ormJoinTable.removeSpecifiedJoinColumn(0);
        OrmJoinTableTests.assertEquals((int)1, (int)joinTableResource.getJoinColumns().size());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
        ormJoinTable.removeSpecifiedJoinColumn(0);
        OrmJoinTableTests.assertEquals((int)0, (int)joinTableResource.getJoinColumns().size());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        ormJoinTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        ormJoinTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        ormJoinTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        OrmJoinTableTests.assertEquals((int)3, (int)joinTableResource.getJoinColumns().size());
        ormJoinTable.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = ormJoinTable.specifiedJoinColumns();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(1)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(2)).getName());
        ormJoinTable.moveSpecifiedJoinColumn(0, 1);
        joinColumns = ormJoinTable.specifiedJoinColumns();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(1)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(2)).getName());
    }

    public void testUpdateInverseJoinColumns() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        manyToMany.setJoinTable((XmlJoinTable)OrmFactory.eINSTANCE.createXmlJoinTableImpl());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        joinTableResource.getInverseJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumnImpl());
        joinTableResource.getInverseJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumnImpl());
        joinTableResource.getInverseJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumnImpl());
        ((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).setName("FOO");
        ((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(1)).setName("BAR");
        ((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(2)).setName("BAZ");
        ListIterator joinColumns = ormJoinTable.specifiedInverseJoinColumns();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getInverseJoinColumns().move(2, 0);
        joinColumns = ormJoinTable.specifiedInverseJoinColumns();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getInverseJoinColumns().move(0, 1);
        joinColumns = ormJoinTable.specifiedInverseJoinColumns();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getInverseJoinColumns().remove(1);
        joinColumns = ormJoinTable.specifiedInverseJoinColumns();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getInverseJoinColumns().remove(1);
        joinColumns = ormJoinTable.specifiedInverseJoinColumns();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getInverseJoinColumns().remove(0);
        OrmJoinTableTests.assertFalse((boolean)ormJoinTable.specifiedInverseJoinColumns().hasNext());
    }

    public void testAddSpecifiedInverseJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn joinColumn = ormJoinTable.addSpecifiedInverseJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).getName());
        OrmJoinColumn joinColumn2 = ormJoinTable.addSpecifiedInverseJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(1)).getName());
        OrmJoinColumn joinColumn3 = ormJoinTable.addSpecifiedInverseJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(1)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(2)).getName());
        ListIterator joinColumns = ormJoinTable.specifiedInverseJoinColumns();
        OrmJoinTableTests.assertEquals((Object)joinColumn2, joinColumns.next());
        OrmJoinTableTests.assertEquals((Object)joinColumn3, joinColumns.next());
        OrmJoinTableTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = ormJoinTable.specifiedInverseJoinColumns();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedInverseJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        ormJoinTable.addSpecifiedInverseJoinColumn(0).setSpecifiedName("FOO");
        ormJoinTable.addSpecifiedInverseJoinColumn(1).setSpecifiedName("BAR");
        ormJoinTable.addSpecifiedInverseJoinColumn(2).setSpecifiedName("BAZ");
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        OrmJoinTableTests.assertEquals((int)3, (int)joinTableResource.getInverseJoinColumns().size());
        ormJoinTable.removeSpecifiedInverseJoinColumn(0);
        OrmJoinTableTests.assertEquals((int)2, (int)joinTableResource.getInverseJoinColumns().size());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(1)).getName());
        ormJoinTable.removeSpecifiedInverseJoinColumn(0);
        OrmJoinTableTests.assertEquals((int)1, (int)joinTableResource.getInverseJoinColumns().size());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).getName());
        ormJoinTable.removeSpecifiedInverseJoinColumn(0);
        OrmJoinTableTests.assertEquals((int)0, (int)joinTableResource.getInverseJoinColumns().size());
    }

    public void testMoveSpecifiedInverseJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        ormJoinTable.addSpecifiedInverseJoinColumn(0).setSpecifiedName("FOO");
        ormJoinTable.addSpecifiedInverseJoinColumn(1).setSpecifiedName("BAR");
        ormJoinTable.addSpecifiedInverseJoinColumn(2).setSpecifiedName("BAZ");
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        OrmJoinTableTests.assertEquals((int)3, (int)joinTableResource.getInverseJoinColumns().size());
        ormJoinTable.moveSpecifiedInverseJoinColumn(2, 0);
        ListIterator joinColumns = ormJoinTable.specifiedInverseJoinColumns();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(1)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(2)).getName());
        ormJoinTable.moveSpecifiedInverseJoinColumn(0, 1);
        joinColumns = ormJoinTable.specifiedInverseJoinColumns();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(1)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(2)).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        manyToMany.setJoinTable((XmlJoinTable)OrmFactory.eINSTANCE.createXmlJoinTableImpl());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        joinTableResource.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumnImpl());
        joinTableResource.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumnImpl());
        joinTableResource.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumnImpl());
        ((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).setName("FOO");
        ((XmlJoinColumn)joinTableResource.getJoinColumns().get(1)).setName("BAR");
        ((XmlJoinColumn)joinTableResource.getJoinColumns().get(2)).setName("BAZ");
        ListIterator joinColumns = ormJoinTable.specifiedJoinColumns();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getJoinColumns().move(2, 0);
        joinColumns = ormJoinTable.specifiedJoinColumns();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getJoinColumns().move(0, 1);
        joinColumns = ormJoinTable.specifiedJoinColumns();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getJoinColumns().remove(1);
        joinColumns = ormJoinTable.specifiedJoinColumns();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getJoinColumns().remove(1);
        joinColumns = ormJoinTable.specifiedJoinColumns();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getJoinColumns().remove(0);
        OrmJoinTableTests.assertFalse((boolean)ormJoinTable.specifiedJoinColumns().hasNext());
    }

    public void testUniqueConstraints() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        manyToMany.setJoinTable((XmlJoinTable)OrmFactory.eINSTANCE.createXmlJoinTableImpl());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        ListIterator uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        XmlUniqueConstraintImpl uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        joinTableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"foo");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        joinTableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"bar");
        uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        OrmJoinTableTests.assertEquals((String)"bar", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"foo", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        manyToMany.setJoinTable((XmlJoinTable)OrmFactory.eINSTANCE.createXmlJoinTableImpl());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        OrmJoinTableTests.assertEquals((int)0, (int)ormJoinTable.uniqueConstraintsSize());
        XmlUniqueConstraintImpl uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        joinTableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"foo");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        joinTableResource.getUniqueConstraints().add(1, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"bar");
        OrmJoinTableTests.assertEquals((int)2, (int)ormJoinTable.uniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        manyToMany.setJoinTable((XmlJoinTable)OrmFactory.eINSTANCE.createXmlJoinTableImpl());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        ormJoinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormJoinTable.addUniqueConstraint(0).addColumnName(0, "BAR");
        ormJoinTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        ListIterator uniqueConstraints = joinTableResource.getUniqueConstraints().listIterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        manyToMany.setJoinTable((XmlJoinTable)OrmFactory.eINSTANCE.createXmlJoinTableImpl());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        ormJoinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormJoinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        ormJoinTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        ListIterator uniqueConstraints = joinTableResource.getUniqueConstraints().listIterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        manyToMany.setJoinTable((XmlJoinTable)OrmFactory.eINSTANCE.createXmlJoinTableImpl());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        ormJoinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormJoinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        ormJoinTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        OrmJoinTableTests.assertEquals((int)3, (int)joinTableResource.getUniqueConstraints().size());
        ormJoinTable.removeUniqueConstraint(1);
        ListIterator uniqueConstraintResources = joinTableResource.getUniqueConstraints().listIterator();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        ListIterator uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        ormJoinTable.removeUniqueConstraint(1);
        uniqueConstraintResources = joinTableResource.getUniqueConstraints().listIterator();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        ormJoinTable.removeUniqueConstraint(0);
        uniqueConstraintResources = joinTableResource.getUniqueConstraints().listIterator();
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        manyToMany.setJoinTable((XmlJoinTable)OrmFactory.eINSTANCE.createXmlJoinTableImpl());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        ormJoinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormJoinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        ormJoinTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        OrmJoinTableTests.assertEquals((int)3, (int)joinTableResource.getUniqueConstraints().size());
        ormJoinTable.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        ListIterator uniqueConstraintResources = joinTableResource.getUniqueConstraints().listIterator();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        ormJoinTable.moveUniqueConstraint(0, 1);
        uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        uniqueConstraintResources = joinTableResource.getUniqueConstraints().listIterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        manyToMany.setJoinTable((XmlJoinTable)OrmFactory.eINSTANCE.createXmlJoinTableImpl());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlUniqueConstraintImpl uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        joinTableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"FOO");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        joinTableResource.getUniqueConstraints().add(1, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"BAR");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        joinTableResource.getUniqueConstraints().add(2, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"BAZ");
        ListIterator uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableResource.getUniqueConstraints().move(2, 0);
        uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableResource.getUniqueConstraints().move(0, 1);
        uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableResource.getUniqueConstraints().remove(1);
        uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableResource.getUniqueConstraints().remove(1);
        uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableResource.getUniqueConstraints().remove(0);
        uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsFromJava() throws Exception {
        this.createTestEntityWithValidManyToMany();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)((OrmPersistentAttribute)ormPersistentType.attributes().next()).getMapping();
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinTableTests.assertTrue((boolean)ormManyToManyMapping.getPersistentAttribute().isVirtual());
        ListIterator uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        JavaManyToManyMapping javaManyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)ormPersistentType.getJavaPersistentType().attributes().next()).getMapping();
        javaManyToManyMapping.getJoinTable().addUniqueConstraint(0).addColumnName(0, "FOO");
        javaManyToManyMapping.getJoinTable().addUniqueConstraint(1).addColumnName(0, "BAR");
        javaManyToManyMapping.getJoinTable().addUniqueConstraint(2).addColumnName(0, "BAZ");
        uniqueConstraints = ormJoinTable.uniqueConstraints();
        OrmJoinTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        ormManyToManyMapping.getPersistentAttribute().makeSpecified();
        ormManyToManyMapping = (OrmManyToManyMapping)((OrmPersistentAttribute)ormPersistentType.attributes().next()).getMapping();
        ormManyToManyMapping.getJoinTable();
        OrmJoinTableTests.assertEquals((int)0, (int)ormManyToManyMapping.getJoinTable().uniqueConstraintsSize());
    }
}

