/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.ListIterator;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlNamedQuery;
import org.eclipse.jpt.core.resource.orm.XmlQueryHint;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class OrmNamedQueryTests
extends ContextModelTestCase {
    public OrmNamedQueryTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedQuery ormNamedQuery = ormEntity.addNamedQuery(0);
        XmlNamedQuery namedQueryResource = (XmlNamedQuery)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getNamedQueries().get(0);
        OrmNamedQueryTests.assertNull((Object)ormNamedQuery.getName());
        OrmNamedQueryTests.assertNull((Object)namedQueryResource.getName());
        namedQueryResource.setName("newName");
        OrmNamedQueryTests.assertEquals((String)"newName", (String)ormNamedQuery.getName());
        OrmNamedQueryTests.assertEquals((String)"newName", (String)namedQueryResource.getName());
        namedQueryResource.setName(null);
        OrmNamedQueryTests.assertNull((Object)ormNamedQuery.getName());
        OrmNamedQueryTests.assertNull((Object)namedQueryResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedQuery ormNamedQuery = ormEntity.addNamedQuery(0);
        XmlNamedQuery namedQueryResource = (XmlNamedQuery)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getNamedQueries().get(0);
        OrmNamedQueryTests.assertNull((Object)ormNamedQuery.getName());
        OrmNamedQueryTests.assertNull((Object)namedQueryResource.getName());
        ormNamedQuery.setName("newName");
        OrmNamedQueryTests.assertEquals((String)"newName", (String)ormNamedQuery.getName());
        OrmNamedQueryTests.assertEquals((String)"newName", (String)namedQueryResource.getName());
        ormNamedQuery.setName(null);
        OrmNamedQueryTests.assertNull((Object)ormNamedQuery.getName());
        OrmNamedQueryTests.assertNull((Object)namedQueryResource.getName());
    }

    public void testUpdateQuery() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedQuery ormNamedQuery = ormEntity.addNamedQuery(0);
        XmlNamedQuery namedQueryResource = (XmlNamedQuery)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getNamedQueries().get(0);
        OrmNamedQueryTests.assertNull((Object)ormNamedQuery.getQuery());
        OrmNamedQueryTests.assertNull((Object)namedQueryResource.getQuery());
        namedQueryResource.setQuery("newName");
        OrmNamedQueryTests.assertEquals((String)"newName", (String)ormNamedQuery.getQuery());
        OrmNamedQueryTests.assertEquals((String)"newName", (String)namedQueryResource.getQuery());
        namedQueryResource.setQuery(null);
        OrmNamedQueryTests.assertNull((Object)ormNamedQuery.getQuery());
        OrmNamedQueryTests.assertNull((Object)namedQueryResource.getQuery());
    }

    public void testModifyQuery() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedQuery ormNamedQuery = ormEntity.addNamedQuery(0);
        XmlNamedQuery namedQueryResource = (XmlNamedQuery)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getNamedQueries().get(0);
        OrmNamedQueryTests.assertNull((Object)ormNamedQuery.getQuery());
        OrmNamedQueryTests.assertNull((Object)namedQueryResource.getQuery());
        ormNamedQuery.setQuery("newName");
        OrmNamedQueryTests.assertEquals((String)"newName", (String)ormNamedQuery.getQuery());
        OrmNamedQueryTests.assertEquals((String)"newName", (String)namedQueryResource.getQuery());
        ormNamedQuery.setQuery(null);
        OrmNamedQueryTests.assertNull((Object)ormNamedQuery.getQuery());
        OrmNamedQueryTests.assertNull((Object)namedQueryResource.getQuery());
    }

    public void testAddHint() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedQuery ormNamedQuery = ormEntity.addNamedQuery(0);
        XmlNamedQuery namedQueryResource = (XmlNamedQuery)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getNamedQueries().get(0);
        OrmQueryHint queryHint = ormNamedQuery.addHint(0);
        queryHint.setName("FOO");
        OrmNamedQueryTests.assertEquals((String)"FOO", (String)((XmlQueryHint)namedQueryResource.getHints().get(0)).getName());
        OrmQueryHint queryHint2 = ormNamedQuery.addHint(0);
        queryHint2.setName("BAR");
        OrmNamedQueryTests.assertEquals((String)"BAR", (String)((XmlQueryHint)namedQueryResource.getHints().get(0)).getName());
        OrmNamedQueryTests.assertEquals((String)"FOO", (String)((XmlQueryHint)namedQueryResource.getHints().get(1)).getName());
        OrmQueryHint queryHint3 = ormNamedQuery.addHint(1);
        queryHint3.setName("BAZ");
        OrmNamedQueryTests.assertEquals((String)"BAR", (String)((XmlQueryHint)namedQueryResource.getHints().get(0)).getName());
        OrmNamedQueryTests.assertEquals((String)"BAZ", (String)((XmlQueryHint)namedQueryResource.getHints().get(1)).getName());
        OrmNamedQueryTests.assertEquals((String)"FOO", (String)((XmlQueryHint)namedQueryResource.getHints().get(2)).getName());
        ListIterator queryHints = ormNamedQuery.hints();
        OrmNamedQueryTests.assertEquals((Object)queryHint2, queryHints.next());
        OrmNamedQueryTests.assertEquals((Object)queryHint3, queryHints.next());
        OrmNamedQueryTests.assertEquals((Object)queryHint, queryHints.next());
        queryHints = ormNamedQuery.hints();
        OrmNamedQueryTests.assertEquals((String)"BAR", (String)((OrmQueryHint)queryHints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)queryHints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"FOO", (String)((OrmQueryHint)queryHints.next()).getName());
    }

    public void testRemoveHint() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedQuery ormNamedQuery = ormEntity.addNamedQuery(0);
        XmlNamedQuery namedQueryResource = (XmlNamedQuery)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getNamedQueries().get(0);
        ormNamedQuery.addHint(0).setName("FOO");
        ormNamedQuery.addHint(1).setName("BAR");
        ormNamedQuery.addHint(2).setName("BAZ");
        OrmNamedQueryTests.assertEquals((int)3, (int)namedQueryResource.getHints().size());
        ormNamedQuery.removeHint(0);
        OrmNamedQueryTests.assertEquals((int)2, (int)namedQueryResource.getHints().size());
        OrmNamedQueryTests.assertEquals((String)"BAR", (String)((XmlQueryHint)namedQueryResource.getHints().get(0)).getName());
        OrmNamedQueryTests.assertEquals((String)"BAZ", (String)((XmlQueryHint)namedQueryResource.getHints().get(1)).getName());
        ormNamedQuery.removeHint(0);
        OrmNamedQueryTests.assertEquals((int)1, (int)namedQueryResource.getHints().size());
        OrmNamedQueryTests.assertEquals((String)"BAZ", (String)((XmlQueryHint)namedQueryResource.getHints().get(0)).getName());
        ormNamedQuery.removeHint(0);
        OrmNamedQueryTests.assertEquals((int)0, (int)namedQueryResource.getHints().size());
    }

    public void testMoveHint() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedQuery ormNamedQuery = ormEntity.addNamedQuery(0);
        XmlNamedQuery namedQueryResource = (XmlNamedQuery)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getNamedQueries().get(0);
        ormNamedQuery.addHint(0).setName("FOO");
        ormNamedQuery.addHint(1).setName("BAR");
        ormNamedQuery.addHint(2).setName("BAZ");
        OrmNamedQueryTests.assertEquals((int)3, (int)namedQueryResource.getHints().size());
        ormNamedQuery.moveHint(2, 0);
        ListIterator hints = ormNamedQuery.hints();
        OrmNamedQueryTests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"BAR", (String)((XmlQueryHint)namedQueryResource.getHints().get(0)).getName());
        OrmNamedQueryTests.assertEquals((String)"BAZ", (String)((XmlQueryHint)namedQueryResource.getHints().get(1)).getName());
        OrmNamedQueryTests.assertEquals((String)"FOO", (String)((XmlQueryHint)namedQueryResource.getHints().get(2)).getName());
        ormNamedQuery.moveHint(0, 1);
        hints = ormNamedQuery.hints();
        OrmNamedQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"BAZ", (String)((XmlQueryHint)namedQueryResource.getHints().get(0)).getName());
        OrmNamedQueryTests.assertEquals((String)"BAR", (String)((XmlQueryHint)namedQueryResource.getHints().get(1)).getName());
        OrmNamedQueryTests.assertEquals((String)"FOO", (String)((XmlQueryHint)namedQueryResource.getHints().get(2)).getName());
    }

    public void testUpdateHints() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedQuery ormNamedQuery = ormEntity.addNamedQuery(0);
        XmlNamedQuery namedQueryResource = (XmlNamedQuery)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getNamedQueries().get(0);
        namedQueryResource.getHints().add((Object)OrmFactory.eINSTANCE.createXmlQueryHint());
        namedQueryResource.getHints().add((Object)OrmFactory.eINSTANCE.createXmlQueryHint());
        namedQueryResource.getHints().add((Object)OrmFactory.eINSTANCE.createXmlQueryHint());
        ((XmlQueryHint)namedQueryResource.getHints().get(0)).setName("FOO");
        ((XmlQueryHint)namedQueryResource.getHints().get(1)).setName("BAR");
        ((XmlQueryHint)namedQueryResource.getHints().get(2)).setName("BAZ");
        ListIterator hints = ormNamedQuery.hints();
        OrmNamedQueryTests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertFalse((boolean)hints.hasNext());
        namedQueryResource.getHints().move(2, 0);
        hints = ormNamedQuery.hints();
        OrmNamedQueryTests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertFalse((boolean)hints.hasNext());
        namedQueryResource.getHints().move(0, 1);
        hints = ormNamedQuery.hints();
        OrmNamedQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertFalse((boolean)hints.hasNext());
        namedQueryResource.getHints().remove(1);
        hints = ormNamedQuery.hints();
        OrmNamedQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertFalse((boolean)hints.hasNext());
        namedQueryResource.getHints().remove(1);
        hints = ormNamedQuery.hints();
        OrmNamedQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedQueryTests.assertFalse((boolean)hints.hasNext());
        namedQueryResource.getHints().remove(0);
        OrmNamedQueryTests.assertFalse((boolean)ormNamedQuery.hints().hasNext());
    }
}

