/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.orm.OrmPersistenceUnitDefaults;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitDefaults;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitMetadata;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class PersistenceUnitDefaultsTests
extends ContextModelTestCase {
    public PersistenceUnitDefaultsTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    protected OrmPersistenceUnitDefaults persistenceUnitDefaults() {
        return this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults();
    }

    public void testIsAllFeaturesUnset() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        XmlPersistenceUnitMetadata persistenceUnitMetadata = OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata();
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(persistenceUnitMetadata);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitMetadata.isAllFeaturesUnset());
        XmlPersistenceUnitDefaults persistenceUnitDefaultsResource = OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults();
        persistenceUnitMetadata.setPersistenceUnitDefaults(persistenceUnitDefaultsResource);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isAllFeaturesUnset());
        persistenceUnitDefaultsResource.setCascadePersist(true);
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isAllFeaturesUnset());
        persistenceUnitDefaultsResource.setCascadePersist(false);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isAllFeaturesUnset());
        persistenceUnitDefaultsResource.setSchema("asdf");
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isAllFeaturesUnset());
        persistenceUnitDefaultsResource.setSchema(null);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isAllFeaturesUnset());
        persistenceUnitDefaultsResource.setCatalog("asdf");
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isAllFeaturesUnset());
        persistenceUnitDefaultsResource.setCatalog(null);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isAllFeaturesUnset());
        persistenceUnitDefaultsResource.setAccess(org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY);
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isAllFeaturesUnset());
        persistenceUnitDefaultsResource.setAccess(org.eclipse.jpt.core.resource.orm.AccessType.FIELD);
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isAllFeaturesUnset());
        persistenceUnitDefaultsResource.setAccess(null);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isAllFeaturesUnset());
    }

    public void testUpdateSchema() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSchema("MY_SCHEMA");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSchema(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
    }

    public void testModifySchema() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setSpecifiedSchema("MY_SCHEMA");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
        persistenceUnitDefaults.setSpecifiedSchema(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
    }

    public void testModifySchema2() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setSpecifiedSchema("MY_SCHEMA");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCatalog("MY_CATALOG");
        persistenceUnitDefaults.setSpecifiedSchema(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
    }

    public void testModifySchema3() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        persistenceUnitDefaults.setSpecifiedSchema("MY_SCHEMA");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
        persistenceUnitDefaults.setSpecifiedSchema(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults());
    }

    public void testUpdateCatalog() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCatalog("MY_CATALOG");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCatalog(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
    }

    public void testModifyCatalog() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setSpecifiedCatalog("MY_CATALOG");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
        persistenceUnitDefaults.setSpecifiedCatalog(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
    }

    public void testModifyCatalog2() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setSpecifiedCatalog("MY_CATALOG");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSchema("MY_SCHEMA");
        persistenceUnitDefaults.setSpecifiedCatalog(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
    }

    public void testModifyCatalog3() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        persistenceUnitDefaults.setSpecifiedCatalog("MY_CATALOG");
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
        persistenceUnitDefaults.setSpecifiedCatalog(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults());
    }

    public void testUpdateCascadePersist() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCascadePersist(true);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCascadePersist(false);
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
    }

    public void testModifyCascadePersist() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setCascadePersist(true);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
        persistenceUnitDefaults.setCascadePersist(false);
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
    }

    public void testModifyCascadePersist2() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setCascadePersist(true);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCatalog("MY_CATALOG");
        persistenceUnitDefaults.setCascadePersist(false);
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
    }

    public void testModifyCascadePersist3() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        persistenceUnitDefaults.setCascadePersist(true);
        PersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
        persistenceUnitDefaults.setCascadePersist(false);
        PersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults());
    }

    public void testUpdateAccess() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(org.eclipse.jpt.core.resource.orm.AccessType.FIELD);
        PersistenceUnitDefaultsTests.assertEquals((Object)AccessType.FIELD, (Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.FIELD, (Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
    }

    public void testModifyAccess() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setAccess(AccessType.PROPERTY);
        PersistenceUnitDefaultsTests.assertEquals((Object)AccessType.PROPERTY, (Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
        persistenceUnitDefaults.setAccess(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
    }

    public void testModifyAccess2() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setAccess(AccessType.FIELD);
        PersistenceUnitDefaultsTests.assertEquals((Object)AccessType.FIELD, (Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.FIELD, (Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCascadePersist(true);
        persistenceUnitDefaults.setAccess(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
    }

    public void testModifyAccess3() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        persistenceUnitDefaults.setAccess(AccessType.FIELD);
        PersistenceUnitDefaultsTests.assertEquals((Object)AccessType.FIELD, (Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.FIELD, (Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
        persistenceUnitDefaults.setAccess(null);
        PersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        PersistenceUnitDefaultsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults());
    }
}

