/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.orm.PersistenceUnitMetadata;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitMetadata;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class PersistenceUnitMetadataTests
extends ContextModelTestCase {
    public PersistenceUnitMetadataTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    protected PersistenceUnitMetadata persistenceUnitMetadata() {
        return this.entityMappings().getPersistenceUnitMetadata();
    }

    public void testIsAllFeaturesUnset() throws Exception {
        XmlPersistenceUnitMetadata persistenceUnitMetadata = OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata();
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(persistenceUnitMetadata);
        PersistenceUnitMetadataTests.assertTrue((boolean)persistenceUnitMetadata.isAllFeaturesUnset());
        persistenceUnitMetadata.setXmlMappingMetadataComplete(true);
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isAllFeaturesUnset());
        persistenceUnitMetadata.setXmlMappingMetadataComplete(false);
        PersistenceUnitMetadataTests.assertTrue((boolean)persistenceUnitMetadata.isAllFeaturesUnset());
        persistenceUnitMetadata.setPersistenceUnitDefaults(OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isAllFeaturesUnset());
    }

    public void testUpdateXmlMappingMetadataComplete() throws Exception {
        PersistenceUnitMetadata persistenceUnitMetadata = this.entityMappings().getPersistenceUnitMetadata();
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        PersistenceUnitMetadataTests.assertTrue((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertTrue((boolean)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().isXmlMappingMetadataComplete());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertFalse((boolean)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().isXmlMappingMetadataComplete());
    }

    public void testModifyXmlMappingMetadataComplete() throws Exception {
        PersistenceUnitMetadata persistenceUnitMetadata = this.entityMappings().getPersistenceUnitMetadata();
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitMetadata.setXmlMappingMetadataComplete(true);
        PersistenceUnitMetadataTests.assertTrue((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertTrue((boolean)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().isXmlMappingMetadataComplete());
        persistenceUnitMetadata.setXmlMappingMetadataComplete(false);
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
    }

    public void testModifyXmlMappingMetadataComplete2() throws Exception {
        PersistenceUnitMetadata persistenceUnitMetadata = this.entityMappings().getPersistenceUnitMetadata();
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitMetadata.setXmlMappingMetadataComplete(true);
        PersistenceUnitMetadataTests.assertTrue((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertTrue((boolean)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().isXmlMappingMetadataComplete());
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        persistenceUnitMetadata.setXmlMappingMetadataComplete(false);
        PersistenceUnitMetadataTests.assertFalse((boolean)persistenceUnitMetadata.isXmlMappingMetadataComplete());
        PersistenceUnitMetadataTests.assertFalse((boolean)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().isXmlMappingMetadataComplete());
    }
}

