/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.persistence;

import java.io.IOException;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceUnitTransactionType;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.core.resource.orm.OrmResource;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnitTransactionType;
import org.eclipse.jpt.core.resource.persistence.XmlProperties;
import org.eclipse.jpt.core.resource.persistence.XmlProperty;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class PersistenceUnitTests
extends ContextModelTestCase {
    protected static final String INNER_CLASS_NAME = "InnerAnnotationTestType";
    protected static final String FULLY_QUALIFIED_INNER_CLASS_NAME = "test.AnnotationTestType.InnerAnnotationTestType";
    public static final String OTHER_TYPE_NAME = "OtherTestType";
    public static final String FULLY_QUALIFIED_OTHER_TYPE_NAME = "test.OtherTestType";

    public PersistenceUnitTests(String name) {
        super(name);
    }

    public void testUpdateName() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        xmlPersistenceUnit.setName("newName");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        xmlPersistenceUnit.setName("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        xmlPersistenceUnit.setName(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        xmlPersistenceUnit.setName("newName");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
    }

    public void testModifyName() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        persistenceUnit.setName("newName");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        persistenceUnit.setName("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        persistenceUnit.setName(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        persistenceUnit.setName("newName");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
    }

    public void testUpdateTransactionType() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getTransactionType());
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedTransactionType());
        xmlPersistenceUnit.setTransactionType(XmlPersistenceUnitTransactionType.JTA);
        PersistenceUnitTests.assertEquals((Object)PersistenceUnitTransactionType.JTA, (Object)persistenceUnit.getSpecifiedTransactionType());
        xmlPersistenceUnit.setTransactionType(XmlPersistenceUnitTransactionType.RESOURCE_LOCAL);
        PersistenceUnitTests.assertEquals((Object)PersistenceUnitTransactionType.RESOURCE_LOCAL, (Object)persistenceUnit.getSpecifiedTransactionType());
        xmlPersistenceUnit.setTransactionType(null);
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedTransactionType());
    }

    public void testModifyTransactionType() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getTransactionType());
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedTransactionType());
        persistenceUnit.setSpecifiedTransactionType(PersistenceUnitTransactionType.JTA);
        PersistenceUnitTests.assertEquals((Object)XmlPersistenceUnitTransactionType.JTA, (Object)xmlPersistenceUnit.getTransactionType());
        persistenceUnit.setSpecifiedTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
        PersistenceUnitTests.assertEquals((Object)XmlPersistenceUnitTransactionType.RESOURCE_LOCAL, (Object)xmlPersistenceUnit.getTransactionType());
        persistenceUnit.setSpecifiedTransactionType(null);
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedTransactionType());
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getTransactionType());
    }

    public void testUpdateDescription() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        xmlPersistenceUnit.setDescription("newDescription");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        xmlPersistenceUnit.setDescription("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        xmlPersistenceUnit.setDescription(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        xmlPersistenceUnit.setDescription("newDescription");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
    }

    public void testModifyDescription() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        persistenceUnit.setDescription("newDescription");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        persistenceUnit.setDescription("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        persistenceUnit.setDescription(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        persistenceUnit.setDescription("newDescription");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
    }

    public void testUpdateProvider() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        xmlPersistenceUnit.setProvider("newProvider");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        xmlPersistenceUnit.setProvider("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        xmlPersistenceUnit.setProvider(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        xmlPersistenceUnit.setProvider("newProvider");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
    }

    public void testModifyProvider() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        persistenceUnit.setProvider("newProvider");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        persistenceUnit.setProvider("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        persistenceUnit.setProvider(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        persistenceUnit.setProvider("newProvider");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
    }

    public void testUpdateJtaDataSource() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        xmlPersistenceUnit.setJtaDataSource("newJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        xmlPersistenceUnit.setJtaDataSource("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        xmlPersistenceUnit.setJtaDataSource(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        xmlPersistenceUnit.setJtaDataSource("newJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
    }

    public void testModifyJtaDataSource() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        persistenceUnit.setJtaDataSource("newJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        persistenceUnit.setJtaDataSource("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        persistenceUnit.setJtaDataSource(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        persistenceUnit.setJtaDataSource("newJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
    }

    public void testUpdateNonJtaDataSource() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        xmlPersistenceUnit.setNonJtaDataSource("newNonJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        xmlPersistenceUnit.setNonJtaDataSource("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        xmlPersistenceUnit.setNonJtaDataSource(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        xmlPersistenceUnit.setNonJtaDataSource("newNonJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
    }

    public void testModifyNonJtaDataSource() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        persistenceUnit.setNonJtaDataSource("newNonJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        persistenceUnit.setNonJtaDataSource("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        persistenceUnit.setNonJtaDataSource(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        persistenceUnit.setNonJtaDataSource("newNonJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
    }

    public void testUpdateJarFileRefs1() {
    }

    public void testUpdateJarFileRefs2() {
    }

    public void testUpdateImpliedMappingFileRef1() throws Exception {
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        OrmResource ormResource = this.ormResource();
        PersistenceUnitTests.assertTrue((boolean)ormResource.exists());
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        this.deleteResource((Resource)ormResource);
        PersistenceUnitTests.assertFalse((boolean)ormResource.exists());
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getImpliedMappingFileRef());
    }

    public void testUpdateImpliedMappingFileRef2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        OrmResource ormResource = this.ormResource();
        PersistenceUnitTests.assertTrue((boolean)ormResource.exists());
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("META-INF/orm.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        PersistenceUnitTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.specifiedMappingFileRefs()));
        PersistenceUnitTests.assertTrue((boolean)ormResource.exists());
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getImpliedMappingFileRef());
    }

    public void testUpdateSpecifiedMappingFileRefs1() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertEquals((int)0, (int)xmlPersistenceUnit.getMappingFiles().size());
        PersistenceUnitTests.assertEquals((int)0, (int)persistenceUnit.specifiedMappingFileRefsSize());
        XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("orm.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        PersistenceUnitTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.specifiedMappingFileRefs()));
        xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("orm2.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        PersistenceUnitTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.specifiedMappingFileRefs()));
    }

    public void testUpdateSpecifiedMappingFileRefs2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("orm.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("orm2.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        PersistenceUnitTests.assertEquals((int)xmlPersistenceUnit.getMappingFiles().size(), (int)2);
        PersistenceUnitTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.specifiedMappingFileRefs()));
        xmlMappingFileRef = (XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(0);
        xmlPersistenceUnit.getMappingFiles().remove((Object)xmlMappingFileRef);
        PersistenceUnitTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.specifiedMappingFileRefs()));
        xmlMappingFileRef = (XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(0);
        xmlPersistenceUnit.getMappingFiles().remove((Object)xmlMappingFileRef);
        PersistenceUnitTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.specifiedMappingFileRefs()));
    }

    public void testModifySpecifiedMappingFileRefs1() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertEquals((int)0, (int)xmlPersistenceUnit.getMappingFiles().size());
        PersistenceUnitTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.specifiedMappingFileRefs()));
        persistenceUnit.addSpecifiedMappingFileRef().setFileName("foo");
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getMappingFiles().size());
        PersistenceUnitTests.assertEquals((String)"foo", (String)((XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(0)).getFileName());
        persistenceUnit.addSpecifiedMappingFileRef().setFileName("bar");
        PersistenceUnitTests.assertEquals((String)"foo", (String)((XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(0)).getFileName());
        PersistenceUnitTests.assertEquals((String)"bar", (String)((XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(1)).getFileName());
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getMappingFiles().size());
        persistenceUnit.addSpecifiedMappingFileRef(0).setFileName("baz");
        PersistenceUnitTests.assertEquals((int)3, (int)xmlPersistenceUnit.getMappingFiles().size());
        PersistenceUnitTests.assertEquals((String)"baz", (String)((XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(0)).getFileName());
        PersistenceUnitTests.assertEquals((String)"foo", (String)((XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(1)).getFileName());
        PersistenceUnitTests.assertEquals((String)"bar", (String)((XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(2)).getFileName());
    }

    public void testModifySpecifiedMappingFileRefs2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("orm.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("orm2.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getMappingFiles().size());
        PersistenceUnitTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.specifiedMappingFileRefs()));
        persistenceUnit.removeSpecifiedMappingFileRef(0);
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getMappingFiles().size());
        persistenceUnit.removeSpecifiedMappingFileRef(0);
        PersistenceUnitTests.assertEquals((int)0, (int)xmlPersistenceUnit.getMappingFiles().size());
    }

    public void testUpdateClassRefs1() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertEquals((int)0, (int)xmlPersistenceUnit.getClasses().size());
        PersistenceUnitTests.assertEquals((int)0, (int)persistenceUnit.specifiedClassRefsSize());
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Bar");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        PersistenceUnitTests.assertEquals((int)1, (int)persistenceUnit.specifiedClassRefsSize());
        xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Baz");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        PersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.specifiedClassRefsSize());
    }

    public void testUpdateClassRefs2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Bar");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Baz");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getClasses().size());
        PersistenceUnitTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.specifiedClassRefs()));
        xmlClassRef = (XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(0);
        xmlPersistenceUnit.getClasses().remove((Object)xmlClassRef);
        PersistenceUnitTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.specifiedClassRefs()));
        xmlClassRef = (XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(0);
        xmlPersistenceUnit.getClasses().remove((Object)xmlClassRef);
        PersistenceUnitTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.specifiedClassRefs()));
    }

    public void testModifyClassRefs1() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertEquals((int)0, (int)xmlPersistenceUnit.getClasses().size());
        PersistenceUnitTests.assertEquals((int)0, (int)persistenceUnit.specifiedClassRefsSize());
        persistenceUnit.addSpecifiedClassRef().setClassName("Foo");
        try {
            this.persistenceResource().save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getClasses().size());
        PersistenceUnitTests.assertEquals((String)"Foo", (String)((XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(0)).getJavaClass());
        persistenceUnit.addSpecifiedClassRef().setClassName("Bar");
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getClasses().size());
        PersistenceUnitTests.assertEquals((String)"Foo", (String)((XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(0)).getJavaClass());
        PersistenceUnitTests.assertEquals((String)"Bar", (String)((XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(1)).getJavaClass());
        persistenceUnit.addSpecifiedClassRef(0).setClassName("Baz");
        PersistenceUnitTests.assertEquals((int)3, (int)xmlPersistenceUnit.getClasses().size());
        PersistenceUnitTests.assertEquals((String)"Baz", (String)((XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(0)).getJavaClass());
        PersistenceUnitTests.assertEquals((String)"Foo", (String)((XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(1)).getJavaClass());
        PersistenceUnitTests.assertEquals((String)"Bar", (String)((XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(2)).getJavaClass());
    }

    public void testModifyClassRefs2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Bar");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Baz");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getClasses().size());
        PersistenceUnitTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.specifiedClassRefs()));
        persistenceUnit.removeSpecifiedClassRef(0);
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getClasses().size());
        persistenceUnit.removeSpecifiedClassRef(0);
        PersistenceUnitTests.assertEquals((int)0, (int)xmlPersistenceUnit.getClasses().size());
    }

    public void testImpliedClassRefs() throws Exception {
        this.createTestEntityWithPersistentInnerClass();
        ListIterator classRefs = this.persistenceUnit().impliedClassRefs();
        PersistenceUnitTests.assertEquals((String)"test.AnnotationTestType", (String)((ClassRef)classRefs.next()).getClassName());
        PersistenceUnitTests.assertEquals((String)FULLY_QUALIFIED_INNER_CLASS_NAME, (String)((ClassRef)classRefs.next()).getClassName());
        this.jpaProject().setDiscoversAnnotatedClasses(true);
        classRefs = this.persistenceUnit().impliedClassRefs();
        PersistenceUnitTests.assertEquals((String)"test.AnnotationTestType", (String)((ClassRef)classRefs.next()).getClassName());
        PersistenceUnitTests.assertEquals((String)FULLY_QUALIFIED_INNER_CLASS_NAME, (String)((ClassRef)classRefs.next()).getClassName());
        this.addXmlClassRef("test.AnnotationTestType");
        classRefs = this.persistenceUnit().impliedClassRefs();
        PersistenceUnitTests.assertEquals((String)FULLY_QUALIFIED_INNER_CLASS_NAME, (String)((ClassRef)classRefs.next()).getClassName());
        PersistenceUnitTests.assertFalse((boolean)classRefs.hasNext());
        this.removeXmlClassRef("test.AnnotationTestType");
        classRefs = this.persistenceUnit().impliedClassRefs();
        PersistenceUnitTests.assertEquals((String)FULLY_QUALIFIED_INNER_CLASS_NAME, (String)((ClassRef)classRefs.next()).getClassName());
        PersistenceUnitTests.assertEquals((String)"test.AnnotationTestType", (String)((ClassRef)classRefs.next()).getClassName());
        this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        classRefs = this.persistenceUnit().impliedClassRefs();
        PersistenceUnitTests.assertEquals((String)FULLY_QUALIFIED_INNER_CLASS_NAME, (String)((ClassRef)classRefs.next()).getClassName());
        PersistenceUnitTests.assertFalse((boolean)classRefs.hasNext());
        this.addXmlClassRef(FULLY_QUALIFIED_INNER_CLASS_NAME);
        classRefs = this.persistenceUnit().impliedClassRefs();
        PersistenceUnitTests.assertFalse((boolean)classRefs.hasNext());
        this.removeXmlClassRef(FULLY_QUALIFIED_INNER_CLASS_NAME);
        classRefs = this.persistenceUnit().impliedClassRefs();
        PersistenceUnitTests.assertEquals((String)FULLY_QUALIFIED_INNER_CLASS_NAME, (String)((ClassRef)classRefs.next()).getClassName());
        PersistenceUnitTests.assertFalse((boolean)classRefs.hasNext());
        this.entityMappings().addOrmPersistentType("entity", FULLY_QUALIFIED_INNER_CLASS_NAME);
        classRefs = this.persistenceUnit().impliedClassRefs();
        PersistenceUnitTests.assertFalse((boolean)classRefs.hasNext());
    }

    public void testRenamePersistentTypeImpliedClassRefs() throws Exception {
        this.getJavaProject().getJpaProject().setDiscoversAnnotatedClasses(true);
        ICompilationUnit testType = this.createTestEntity();
        this.createTestOtherTypeEntity();
        ListIterator classRefs = this.persistenceUnit().impliedClassRefs();
        ClassRef testTypeClassRef = (ClassRef)classRefs.next();
        ClassRef otherTestTypeClassRef = (ClassRef)classRefs.next();
        PersistenceUnitTests.assertEquals((String)"test.AnnotationTestType", (String)testTypeClassRef.getClassName());
        PersistenceUnitTests.assertEquals((String)FULLY_QUALIFIED_OTHER_TYPE_NAME, (String)otherTestTypeClassRef.getClassName());
        JavaPersistentType testJavaPersistentType = testTypeClassRef.getJavaPersistentType();
        JavaPersistentType otherTestJavaPersistentType = otherTestTypeClassRef.getJavaPersistentType();
        testType.findPrimaryType().rename("TestType2", false, null);
        classRefs = this.persistenceUnit().impliedClassRefs();
        otherTestTypeClassRef = (ClassRef)classRefs.next();
        testTypeClassRef = (ClassRef)classRefs.next();
        PersistenceUnitTests.assertEquals((String)FULLY_QUALIFIED_OTHER_TYPE_NAME, (String)otherTestTypeClassRef.getClassName());
        PersistenceUnitTests.assertEquals((String)"test.TestType2", (String)testTypeClassRef.getClassName());
        PersistenceUnitTests.assertEquals((Object)otherTestJavaPersistentType, (Object)otherTestTypeClassRef.getJavaPersistentType());
        PersistenceUnitTests.assertNotSame((Object)testJavaPersistentType, (Object)testTypeClassRef.getJavaPersistentType());
    }

    public void testUpdateExcludeUnlistedClasses() throws Exception {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertFalse((boolean)persistenceUnit.isExcludeUnlistedClasses());
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
        xmlPersistenceUnit.setExcludeUnlistedClasses(Boolean.TRUE);
        PersistenceUnitTests.assertEquals((Object)Boolean.TRUE, (Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertTrue((boolean)persistenceUnit.isExcludeUnlistedClasses());
        PersistenceUnitTests.assertEquals((Object)Boolean.TRUE, (Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
        xmlPersistenceUnit.setExcludeUnlistedClasses(Boolean.FALSE);
        PersistenceUnitTests.assertEquals((Object)Boolean.FALSE, (Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertFalse((boolean)persistenceUnit.isExcludeUnlistedClasses());
        PersistenceUnitTests.assertEquals((Object)Boolean.FALSE, (Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
        xmlPersistenceUnit.setExcludeUnlistedClasses(null);
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertFalse((boolean)persistenceUnit.isExcludeUnlistedClasses());
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
    }

    public void testModifyExcludeUnlistedClasses() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertFalse((boolean)persistenceUnit.isExcludeUnlistedClasses());
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
        persistenceUnit.setSpecifiedExcludeUnlistedClasses(Boolean.TRUE);
        PersistenceUnitTests.assertEquals((Object)Boolean.TRUE, (Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertTrue((boolean)persistenceUnit.isExcludeUnlistedClasses());
        PersistenceUnitTests.assertEquals((Object)Boolean.TRUE, (Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
        persistenceUnit.setSpecifiedExcludeUnlistedClasses(Boolean.FALSE);
        PersistenceUnitTests.assertEquals((Object)Boolean.FALSE, (Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertFalse((boolean)persistenceUnit.isExcludeUnlistedClasses());
        PersistenceUnitTests.assertEquals((Object)Boolean.FALSE, (Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
        persistenceUnit.setSpecifiedExcludeUnlistedClasses(null);
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertFalse((boolean)persistenceUnit.isExcludeUnlistedClasses());
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
    }

    public void testUpdateProperties1() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getProperties());
        PersistenceUnitTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.properties()));
        XmlProperties xmlProperties = PersistenceFactory.eINSTANCE.createXmlProperties();
        xmlPersistenceUnit.setProperties(xmlProperties);
        PersistenceUnitTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.properties()));
        XmlProperty xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperty.setName("foo");
        xmlProperty.setValue("bar");
        xmlProperties.getProperties().add((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.properties()));
        xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperty.setName("FOO");
        xmlProperty.setValue("BAR");
        xmlProperties.getProperties().add((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.properties()));
    }

    public void testUpdateProperties2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        XmlProperties xmlProperties = PersistenceFactory.eINSTANCE.createXmlProperties();
        xmlPersistenceUnit.setProperties(xmlProperties);
        XmlProperty xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperty.setName("foo");
        xmlProperty.setValue("bar");
        xmlProperties.getProperties().add((Object)xmlProperty);
        xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperty.setName("FOO");
        xmlProperty.setValue("BAR");
        xmlProperties.getProperties().add((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.properties()));
        xmlProperty = (XmlProperty)xmlProperties.getProperties().get(0);
        xmlProperties.getProperties().remove((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.properties()));
        xmlProperty = (XmlProperty)xmlProperties.getProperties().get(0);
        xmlProperties.getProperties().remove((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.properties()));
    }

    public void testModifyProperties1() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getProperties());
        PersistenceUnitTests.assertEquals((int)0, (int)persistenceUnit.propertiesSize());
        persistenceUnit.addProperty().setName("foo");
        PersistenceUnitTests.assertNotNull((Object)xmlPersistenceUnit.getProperties());
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((String)"foo", (String)((XmlProperty)xmlPersistenceUnit.getProperties().getProperties().get(0)).getName());
        persistenceUnit.addProperty().setName("bar");
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((String)"foo", (String)((XmlProperty)xmlPersistenceUnit.getProperties().getProperties().get(0)).getName());
        PersistenceUnitTests.assertEquals((String)"bar", (String)((XmlProperty)xmlPersistenceUnit.getProperties().getProperties().get(1)).getName());
        persistenceUnit.addProperty(0).setName("baz");
        PersistenceUnitTests.assertEquals((int)3, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((String)"baz", (String)((XmlProperty)xmlPersistenceUnit.getProperties().getProperties().get(0)).getName());
        PersistenceUnitTests.assertEquals((String)"foo", (String)((XmlProperty)xmlPersistenceUnit.getProperties().getProperties().get(1)).getName());
        PersistenceUnitTests.assertEquals((String)"bar", (String)((XmlProperty)xmlPersistenceUnit.getProperties().getProperties().get(2)).getName());
    }

    public void testModifyProperties2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        XmlProperties xmlProperties = PersistenceFactory.eINSTANCE.createXmlProperties();
        xmlPersistenceUnit.setProperties(xmlProperties);
        XmlProperty xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperty.setName("foo");
        xmlProperty.setValue("bar");
        xmlProperties.getProperties().add((Object)xmlProperty);
        xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperty.setName("FOO");
        xmlProperty.setValue("BAR");
        xmlProperties.getProperties().add((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.properties()));
        persistenceUnit.removeProperty("foo");
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        persistenceUnit.removeProperty("FOO", "BAR");
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getProperties());
    }

    public void testModifyProperties3() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        persistenceUnit.putProperty("foo", "bar", false);
        persistenceUnit.putProperty("FOO", "BAR", false);
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.properties()));
        persistenceUnit.removeProperty("foo", "bar");
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        persistenceUnit.removeProperty("FOO");
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getProperties());
    }

    public void testModifyProperties4() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        persistenceUnit.putProperty("foo", "bar", false);
        persistenceUnit.putProperty("FOO", "BAR", false);
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.propertiesSize());
        persistenceUnit.putProperty("foo", "", false);
        PersistenceUnitTests.assertEquals((String)"", (String)persistenceUnit.getProperty("foo").getValue());
        persistenceUnit.putProperty("foo", "BAR", false);
        PersistenceUnitTests.assertEquals((String)"BAR", (String)persistenceUnit.getProperty("foo").getValue());
        persistenceUnit.removeProperty("notExist");
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        persistenceUnit.removeProperty("FOO");
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getProperty("FOO"));
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        persistenceUnit.putProperty("notExist", null, false);
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getProperty("notExist"));
        persistenceUnit.putProperty("foo", null, false);
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getProperty("foo"));
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getProperties());
    }

    public void testModifyProperties5() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        persistenceUnit.putProperty("FOO", "BAR", false);
        persistenceUnit.putProperty("foo", "bar 3", true);
        persistenceUnit.putProperty("foo", "bar 2", true);
        persistenceUnit.putProperty("foo", "bar 1", true);
        PersistenceUnitTests.assertEquals((int)4, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((int)4, (int)CollectionTools.size((Iterator)persistenceUnit.properties()));
        persistenceUnit.replacePropertyValue("foo", "bar 2", "bar two");
        Property property = persistenceUnit.getProperty("foo", "bar two");
        PersistenceUnitTests.assertEquals((String)"bar two", (String)property.getValue());
        persistenceUnit.removeProperty("foo", "bar 1");
        PersistenceUnitTests.assertEquals((int)3, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)persistenceUnit.properties()));
    }

    public void testAccessProperty() {
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        persistenceUnit.putProperty("foo", "bar", false);
        persistenceUnit.putProperty("FOO", "BAR", false);
        Property property = persistenceUnit.getProperty("foo");
        PersistenceUnitTests.assertNotNull((Object)property);
        PersistenceUnitTests.assertEquals((String)"bar", (String)property.getValue());
        PersistenceUnitTests.assertTrue((boolean)persistenceUnit.containsProperty("FOO"));
        PersistenceUnitTests.assertEquals((String)"BAR", (String)persistenceUnit.getProperty("FOO").getValue());
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getProperty("notExist"));
    }

    private Property persistenceUnitFirstProperty() {
        return (Property)this.persistenceUnit().properties().next();
    }

    public void testUpdatePropertyName() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        XmlProperties xmlProperties = PersistenceFactory.eINSTANCE.createXmlProperties();
        xmlPersistenceUnit.setProperties(xmlProperties);
        XmlProperty xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperties.getProperties().add((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((String)xmlProperty.getName(), (String)this.persistenceUnitFirstProperty().getName());
        xmlProperty.setName("newName");
        PersistenceUnitTests.assertEquals((String)xmlProperty.getName(), (String)this.persistenceUnitFirstProperty().getName());
        xmlProperty.setName("");
        PersistenceUnitTests.assertEquals((String)xmlProperty.getName(), (String)this.persistenceUnitFirstProperty().getName());
        xmlProperty.setName("newName");
        PersistenceUnitTests.assertEquals((String)xmlProperty.getName(), (String)this.persistenceUnitFirstProperty().getName());
    }

    public void testUpdatePropertyValue() {
        XmlPersistenceUnit xmlPersistenceUnit = this.xmlPersistenceUnit();
        XmlProperties xmlProperties = PersistenceFactory.eINSTANCE.createXmlProperties();
        xmlPersistenceUnit.setProperties(xmlProperties);
        XmlProperty xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperties.getProperties().add((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((String)xmlProperty.getValue(), (String)this.persistenceUnitFirstProperty().getValue());
        xmlProperty.setValue("newValue");
        PersistenceUnitTests.assertEquals((String)xmlProperty.getValue(), (String)this.persistenceUnitFirstProperty().getValue());
        xmlProperty.setValue("");
        PersistenceUnitTests.assertEquals((String)xmlProperty.getValue(), (String)this.persistenceUnitFirstProperty().getValue());
        xmlProperty.setValue(null);
        PersistenceUnitTests.assertEquals((String)xmlProperty.getValue(), (String)this.persistenceUnitFirstProperty().getValue());
        xmlProperty.setValue("newValue");
        PersistenceUnitTests.assertEquals((String)xmlProperty.getValue(), (String)this.persistenceUnitFirstProperty().getValue());
    }

    public void testGetDefaultAccess() throws Exception {
        this.createOrmXmlFile();
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        PersistenceUnitTests.assertEquals((Object)AccessType.PROPERTY, (Object)persistenceUnit.getDefaultAccess());
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.FIELD);
        PersistenceUnitTests.assertEquals((Object)AccessType.FIELD, (Object)persistenceUnit.getDefaultAccess());
    }

    protected void createOrmXmlFile() throws Exception {
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    private ICompilationUnit createTestOtherTypeEntity() throws Exception {
        return this.createTestType("test", "OtherTestType.java", OTHER_TYPE_NAME, new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithPersistentInnerClass() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendMemberTypeTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("     public static class InnerAnnotationTestType {}").append(CR);
            }
        });
    }

    public void testPersistentType() throws Exception {
        PersistenceUnit persistenceUnit = this.persistenceUnit();
        this.createTestEntity();
        PersistenceUnitTests.assertFalse((boolean)this.jpaProject().discoversAnnotatedClasses());
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("test.AnnotationTestType"));
        this.jpaProject().setDiscoversAnnotatedClasses(true);
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("test.AnnotationTestType"));
        this.jpaProject().setDiscoversAnnotatedClasses(false);
        XmlJavaClassRef classRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        classRef.setJavaClass("test.AnnotationTestType");
        this.xmlPersistenceUnit().getClasses().add((Object)classRef);
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("test.AnnotationTestType"));
        this.createOrmXmlFile();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("model.Foo"));
        PersistenceUnitTests.assertEquals((Object)ormPersistentType, (Object)persistenceUnit.getPersistentType("model.Foo"));
        this.xmlPersistenceUnit().getMappingFiles().remove(0);
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("model.Foo"));
    }
}

