/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.persistence;

import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.PersistenceResource;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class PersistenceXmlTests
extends ContextModelTestCase {
    public PersistenceXmlTests(String name) {
        super(name);
    }

    protected PersistenceXml persistenceXml() {
        return this.getRootContextNode().getPersistenceXml();
    }

    public void testUpdateAddPersistence() throws Exception {
        PersistenceResource prm = this.persistenceResource();
        prm.getContents().clear();
        prm.save(null);
        PersistenceXmlTests.assertNull((Object)this.persistenceXml().getPersistence());
        prm.getContents().add((Object)PersistenceFactory.eINSTANCE.createXmlPersistence());
        PersistenceXmlTests.assertNotNull((Object)this.persistenceXml().getPersistence());
    }

    public void testModifyAddPersistence() {
        PersistenceResource prm = this.persistenceResource();
        prm.getContents().remove((Object)prm.getPersistence());
        PersistenceXmlTests.assertNull((Object)prm.getPersistence());
        PersistenceXml persistenceXml = this.persistenceXml();
        persistenceXml.addPersistence();
        PersistenceXmlTests.assertNotNull((Object)persistenceXml.getPersistence());
        boolean exceptionThrown = false;
        try {
            persistenceXml.addPersistence();
        }
        catch (IllegalStateException illegalStateException) {
            exceptionThrown = true;
        }
        PersistenceXmlTests.assertTrue((boolean)exceptionThrown);
    }

    public void testUpdateRemovePersistence() throws Exception {
        PersistenceResource prm = this.persistenceResource();
        PersistenceXmlTests.assertNotNull((Object)this.persistenceXml().getPersistence());
        prm.getContents().clear();
        PersistenceXmlTests.assertNull((Object)this.persistenceXml().getPersistence());
    }

    public void testModifyRemovePersistence() {
        PersistenceXml persistenceXml = this.persistenceXml();
        PersistenceXmlTests.assertNotNull((Object)persistenceXml.getPersistence());
        persistenceXml.removePersistence();
        PersistenceXmlTests.assertNull((Object)persistenceXml.getPersistence());
        boolean exceptionThrown = false;
        try {
            persistenceXml.removePersistence();
        }
        catch (IllegalStateException illegalStateException) {
            exceptionThrown = true;
        }
        PersistenceXmlTests.assertTrue((boolean)exceptionThrown);
    }
}

