/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.platform;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProvider;
import org.eclipse.jpt.core.tests.extension.resource.ExtensionTestPlugin;
import org.eclipse.jpt.core.tests.extension.resource.JavaTestAttributeMapping;
import org.eclipse.jpt.core.tests.extension.resource.JavaTestAttributeMappingProvider;
import org.eclipse.jpt.core.tests.extension.resource.JavaTestTypeMapping;
import org.eclipse.jpt.core.tests.extension.resource.JavaTestTypeMappingProvider;
import org.eclipse.jpt.core.tests.extension.resource.TestJavaBasicMapping;
import org.eclipse.jpt.core.tests.extension.resource.TestJavaEntity;
import org.eclipse.jpt.core.tests.extension.resource.TestJpaFactory;
import org.eclipse.jpt.core.tests.extension.resource.TestJpaPlatform;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.platform.JpaPlatformExtensionTests;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.projects.TestJpaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JpaPlatformTests
extends ContextModelTestCase {
    protected TestJpaProject testProject;
    protected static final String PROJECT_NAME = "ExtensionTestProject";
    protected static final String PACKAGE_NAME = "extension.test";
    public static final String TEST_PLUGIN_CLASS = ExtensionTestPlugin.class.getName();
    public static final String TEST_PLUGIN_ID = "org.eclipse.jpt.core.tests.extension.resource";
    public static final String TEST_PLATFORM_CLASS_NAME = TestJpaPlatform.class.getName();
    public static final String TEST_PLATFORM_LABEL = "Test Jpa Platform";
    public static final String TEST_JPA_FACTORY = TestJpaFactory.class.getName();
    public static final String TEST_TYPE_MAPPING_PROVIDER_CLASS = JavaTestTypeMappingProvider.class.getName();
    public static final String TEST_ATTRIBUTE_MAPPING_PROVIDER_CLASS = JavaTestAttributeMappingProvider.class.getName();

    public JpaPlatformTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        JpaPlatformExtensionTests.verifyExtensionTestProjectExists();
    }

    protected TestJavaProject buildJavaProject(boolean autoBuild) throws Exception {
        return super.buildJpaProject(PROJECT_NAME, autoBuild, this.buildConfig());
    }

    protected IDataModel buildConfig() throws Exception {
        JpaFacetDataModelProvider configFactory = new JpaFacetDataModelProvider();
        IDataModel config = (IDataModel)configFactory.create();
        config.setProperty("JpaFacetDataModelProperties.PLATFORM_ID", (Object)"core.testJpaPlatform");
        return config;
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    protected JpaPlatform jpaPlatform() {
        return this.jpaProject().getJpaPlatform();
    }

    public void testJpaFactory() {
        JpaPlatformTests.assertTrue((boolean)this.jpaPlatform().getJpaFactory().getClass().getName().equals(TEST_JPA_FACTORY));
    }

    public void testBuildJavaTypeMappingFromMappingKey() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTypeMapping javaTypeMapping = this.jpaProject().getJpaPlatform().buildJavaTypeMappingFromMappingKey("test", this.javaPersistentType());
        JpaPlatformTests.assertTrue((boolean)(javaTypeMapping instanceof JavaTestTypeMapping));
        javaTypeMapping = this.jpaPlatform().buildJavaTypeMappingFromMappingKey("entity", this.javaPersistentType());
        JpaPlatformTests.assertTrue((boolean)(javaTypeMapping instanceof TestJavaEntity));
    }

    public void testBuildJavaAttributeMappingFromMappingKey() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeMapping javaAttributeMapping = this.jpaProject().getJpaPlatform().buildJavaAttributeMappingFromMappingKey("testAttribute", this.javaPersistentType().getAttributeNamed("name"));
        JpaPlatformTests.assertTrue((boolean)(javaAttributeMapping instanceof JavaTestAttributeMapping));
        javaAttributeMapping = this.jpaPlatform().buildJavaAttributeMappingFromMappingKey("basic", this.javaPersistentType().getAttributeNamed("name"));
        JpaPlatformTests.assertTrue((boolean)(javaAttributeMapping instanceof TestJavaBasicMapping));
    }
}

