/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.ManyToManyAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class ManyToManyTests
extends JavaResourceModelTestCase {
    public ManyToManyTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestManyToMany() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.ManyToMany"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany");
            }
        });
    }

    private ICompilationUnit createTestManyToManyWithFetch() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.ManyToMany", "javax.persistence.FetchType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany(fetch=FetchType.EAGER)");
            }
        });
    }

    private ICompilationUnit createTestManyToManyWithTargetEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.ManyToMany"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany(targetEntity=AnnotationTestType.class)");
            }
        });
    }

    private ICompilationUnit createTestManyToManyWithMappedBy() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.ManyToMany"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany(mappedBy=\"foo\")");
            }
        });
    }

    private ICompilationUnit createTestManyToManyWithCascade() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.ManyToMany", "javax.persistence.CascadeType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany(cascade=CascadeType.ALL)");
            }
        });
    }

    private ICompilationUnit createTestManyToManyWithMultipleCascade() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.ManyToMany", "javax.persistence.CascadeType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany(cascade={CascadeType.MERGE, CascadeType.REMOVE})");
            }
        });
    }

    private ICompilationUnit createTestManyToManyWithDuplicateCascade() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.ManyToMany", "javax.persistence.CascadeType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany(cascade={CascadeType.MERGE, CascadeType.MERGE})");
            }
        });
    }

    public void testManyToMany() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertNotNull((Object)manyToMany);
    }

    public void testGetFetch() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertEquals((Object)FetchType.EAGER, (Object)manyToMany.getFetch());
    }

    public void testSetFetch() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertEquals((Object)FetchType.EAGER, (Object)manyToMany.getFetch());
        manyToMany.setFetch(FetchType.LAZY);
        ManyToManyTests.assertEquals((Object)FetchType.LAZY, (Object)manyToMany.getFetch());
        this.assertSourceContains("@ManyToMany(fetch=LAZY)", cu);
    }

    public void testSetFetchNull() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertEquals((Object)FetchType.EAGER, (Object)manyToMany.getFetch());
        manyToMany.setFetch(null);
        ManyToManyTests.assertNull((Object)manyToMany.getFetch());
        this.assertSourceContains("@ManyToMany", cu);
        this.assertSourceDoesNotContain("fetch", cu);
    }

    public void testGetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertEquals((String)"AnnotationTestType", (String)manyToMany.getTargetEntity());
    }

    public void testSetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertEquals((String)"AnnotationTestType", (String)manyToMany.getTargetEntity());
        manyToMany.setTargetEntity("Foo");
        this.assertSourceContains("@ManyToMany(targetEntity=Foo.class)", cu);
    }

    public void testSetTargetEntityNull() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertEquals((String)"AnnotationTestType", (String)manyToMany.getTargetEntity());
        manyToMany.setTargetEntity(null);
        this.assertSourceContains("@ManyToMany", cu);
        this.assertSourceDoesNotContain("targetEntity", cu);
    }

    public void testGetFullyQualifiedTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertEquals((String)"test.AnnotationTestType", (String)manyToMany.getFullyQualifiedTargetEntity());
        manyToMany.setTargetEntity("Foo");
        this.assertSourceContains("@ManyToMany(targetEntity=Foo.class)", cu);
        ManyToManyTests.assertEquals((String)"Foo", (String)manyToMany.getTargetEntity());
        ManyToManyTests.assertEquals((String)"Foo", (String)manyToMany.getFullyQualifiedTargetEntity());
    }

    public void testGetMappedBy() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithMappedBy();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertEquals((String)"foo", (String)manyToMany.getMappedBy());
    }

    public void testGetMappedByNull() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertEquals(null, (String)manyToMany.getMappedBy());
    }

    public void testSetMappedBy() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertNull((Object)manyToMany.getMappedBy());
        manyToMany.setMappedBy("bar");
        ManyToManyTests.assertEquals((String)"bar", (String)manyToMany.getMappedBy());
        this.assertSourceContains("@ManyToMany(mappedBy=\"bar\")", cu);
    }

    public void testSetMappedByNull() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithMappedBy();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertEquals((String)"foo", (String)manyToMany.getMappedBy());
        manyToMany.setMappedBy(null);
        ManyToManyTests.assertNull((Object)manyToMany.getMappedBy());
        this.assertSourceContains("@ManyToMany", cu);
        this.assertSourceDoesNotContain("mappedBy", cu);
    }

    public void testSetCascadeAll() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertFalse((boolean)manyToMany.isCascadeAll());
        manyToMany.setCascadeAll(true);
        this.assertSourceContains("@ManyToMany(cascade=ALL)", cu);
        ManyToManyTests.assertTrue((boolean)manyToMany.isCascadeAll());
    }

    public void testSetCascadeMerge() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertFalse((boolean)manyToMany.isCascadeMerge());
        manyToMany.setCascadeMerge(true);
        this.assertSourceContains("@ManyToMany(cascade=MERGE)", cu);
        ManyToManyTests.assertTrue((boolean)manyToMany.isCascadeMerge());
    }

    public void testSetCascadePersist() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertFalse((boolean)manyToMany.isCascadePersist());
        manyToMany.setCascadePersist(true);
        this.assertSourceContains("@ManyToMany(cascade=PERSIST)", cu);
        ManyToManyTests.assertTrue((boolean)manyToMany.isCascadePersist());
    }

    public void testSetCascadeRemove() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertFalse((boolean)manyToMany.isCascadeRemove());
        manyToMany.setCascadeRemove(true);
        this.assertSourceContains("@ManyToMany(cascade=REMOVE)", cu);
        ManyToManyTests.assertTrue((boolean)manyToMany.isCascadeRemove());
    }

    public void testSetCascadeRefresh() throws Exception {
        ICompilationUnit cu = this.createTestManyToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertFalse((boolean)manyToMany.isCascadeRefresh());
        manyToMany.setCascadeRefresh(true);
        this.assertSourceContains("@ManyToMany(cascade=REFRESH)", cu);
        ManyToManyTests.assertTrue((boolean)manyToMany.isCascadeRefresh());
    }

    public void testCascadeMoreThanOnce() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithCascade();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertTrue((boolean)manyToMany.isCascadeAll());
        manyToMany.setCascadeAll(true);
        ManyToManyTests.assertTrue((boolean)manyToMany.isCascadeAll());
        this.assertSourceContains("@ManyToMany(cascade=CascadeType.ALL)", cu);
        manyToMany.setCascadeAll(false);
        ManyToManyTests.assertFalse((boolean)manyToMany.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
        manyToMany.setCascadeAll(false);
        ManyToManyTests.assertFalse((boolean)manyToMany.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testDuplicateCascade() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithDuplicateCascade();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertTrue((boolean)manyToMany.isCascadeMerge());
        manyToMany.setCascadeMerge(false);
        ManyToManyTests.assertTrue((boolean)manyToMany.isCascadeMerge());
        manyToMany.setCascadeMerge(false);
        ManyToManyTests.assertFalse((boolean)manyToMany.isCascadeMerge());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testMultipleCascade() throws Exception {
        ICompilationUnit cu = this.createTestManyToManyWithMultipleCascade();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany");
        ManyToManyTests.assertTrue((boolean)manyToMany.isCascadeMerge());
        ManyToManyTests.assertTrue((boolean)manyToMany.isCascadeRemove());
        manyToMany.setCascadeMerge(false);
        this.assertSourceContains("@ManyToMany(cascade=REMOVE)", cu);
        manyToMany.setCascadeRemove(false);
        this.assertSourceDoesNotContain("cascade", cu);
    }
}

